/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.implcore.internal;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class DaemonThreadFactory
implements ThreadFactory {
    private static final String DELIMITER = "-";
    private final AtomicInteger threadIdGen = new AtomicInteger();
    private final String threadPrefix;

    public DaemonThreadFactory(String threadPrefix) {
        this.threadPrefix = threadPrefix + DELIMITER;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        try {
            thread.setName(this.threadPrefix + this.threadIdGen.getAndIncrement());
            thread.setDaemon(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return thread;
    }
}

