/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.trace.util;

import com.google.bigtable.repackaged.com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.bigtable.repackaged.com.google.errorprone.annotations.MustBeClosed;
import com.google.bigtable.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.io.opencensus.common.Scope;
import com.google.bigtable.repackaged.io.opencensus.trace.Sampler;
import com.google.bigtable.repackaged.io.opencensus.trace.Status;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracer;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracing;
import com.google.bigtable.repackaged.io.opencensus.trace.export.SpanData;
import com.google.bigtable.repackaged.io.opencensus.trace.export.SpanExporter;
import com.google.bigtable.repackaged.io.opencensus.trace.samplers.Samplers;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TimeLimitedHandler
extends SpanExporter.Handler {
    private static final Logger logger = Logger.getLogger(TimeLimitedHandler.class.getName());
    private static final Tracer tracer = Tracing.getTracer();
    private static final Sampler lowProbabilitySampler = Samplers.probabilitySampler(1.0E-4);
    private final Duration deadline;
    private final String exportSpanName;

    protected TimeLimitedHandler(Duration deadline, String exportSpanName) {
        this.deadline = deadline;
        this.exportSpanName = exportSpanName;
    }

    public abstract void timeLimitedExport(Collection<SpanData> var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(final Collection<SpanData> spanDataList) {
        Scope exportScope = this.newExportScope();
        try {
            SimpleTimeLimiter timeLimiter = SimpleTimeLimiter.create(Executors.newSingleThreadExecutor());
            timeLimiter.callWithTimeout(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TimeLimitedHandler.this.timeLimitedExport(spanDataList);
                    return null;
                }
            }, this.deadline.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            TimeLimitedHandler.handleException(e, "Timeout when exporting traces: " + e);
        }
        catch (InterruptedException e) {
            TimeLimitedHandler.handleException(e, "Interrupted when exporting traces: " + e);
        }
        catch (Exception e) {
            TimeLimitedHandler.handleException(e, "Failed to export traces: " + e);
        }
        finally {
            exportScope.close();
        }
    }

    @MustBeClosed
    private Scope newExportScope() {
        return tracer.spanBuilder(this.exportSpanName).setSampler(lowProbabilitySampler).startScopedSpan();
    }

    private static void handleException(Exception e, String logMessage) {
        Status status = e instanceof TimeoutException ? Status.DEADLINE_EXCEEDED : Status.UNKNOWN;
        tracer.getCurrentSpan().setStatus(status.withDescription(e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage()));
        logger.log(Level.WARNING, logMessage);
    }
}

