/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.opencensus.common.Timestamp;
import com.google.bigtable.repackaged.io.opencensus.contrib.resource.util.ResourceUtils;
import com.google.bigtable.repackaged.io.opencensus.exporter.trace.ocagent.TraceProtoUtils;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.common.v1.LibraryInfo;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.common.v1.Node;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.common.v1.ProcessIdentifier;
import com.google.bigtable.repackaged.io.opencensus.proto.agent.common.v1.ServiceInfo;
import com.google.bigtable.repackaged.io.opencensus.proto.resource.v1.Resource;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Map;
import javax.annotation.Nullable;

final class OcAgentNodeUtils {
    @VisibleForTesting
    static final String OC_AGENT_EXPORTER_VERSION = "0.28.0";
    @Nullable
    private static final com.google.bigtable.repackaged.io.opencensus.resource.Resource AUTO_DETECTED_RESOURCE = ResourceUtils.detectResource();

    static Node getNodeInfo(String serviceName) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        Timestamp censusTimestamp = Timestamp.fromMillis(System.currentTimeMillis());
        return Node.newBuilder().setIdentifier(OcAgentNodeUtils.getProcessIdentifier(jvmName, censusTimestamp)).setLibraryInfo(OcAgentNodeUtils.getLibraryInfo(OC_AGENT_EXPORTER_VERSION)).setServiceInfo(OcAgentNodeUtils.getServiceInfo(serviceName)).build();
    }

    @VisibleForTesting
    static ProcessIdentifier getProcessIdentifier(String jvmName, Timestamp censusTimestamp) {
        int pid;
        String hostname;
        int delimiterIndex = jvmName.indexOf(64);
        if (delimiterIndex < 1) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = "localhost";
            }
            pid = new SecureRandom().nextInt();
        } else {
            hostname = jvmName.substring(delimiterIndex + 1, jvmName.length());
            try {
                pid = Integer.parseInt(jvmName.substring(0, delimiterIndex));
            }
            catch (NumberFormatException e) {
                pid = new SecureRandom().nextInt();
            }
        }
        return ProcessIdentifier.newBuilder().setHostName(hostname).setPid(pid).setStartTimestamp(TraceProtoUtils.toTimestampProto(censusTimestamp)).build();
    }

    @VisibleForTesting
    static LibraryInfo getLibraryInfo(String currentOcJavaVersion) {
        return LibraryInfo.newBuilder().setLanguage(LibraryInfo.Language.JAVA).setCoreLibraryVersion(currentOcJavaVersion).setExporterVersion(OC_AGENT_EXPORTER_VERSION).build();
    }

    @VisibleForTesting
    static ServiceInfo getServiceInfo(String serviceName) {
        return ServiceInfo.newBuilder().setName(serviceName).build();
    }

    @Nullable
    static Resource getAutoDetectedResourceProto() {
        return OcAgentNodeUtils.toResourceProto(AUTO_DETECTED_RESOURCE);
    }

    @Nullable
    @VisibleForTesting
    static Resource toResourceProto(@Nullable com.google.bigtable.repackaged.io.opencensus.resource.Resource resource) {
        if (resource == null || resource.getType() == null) {
            return null;
        }
        Resource.Builder resourceProtoBuilder = Resource.newBuilder();
        resourceProtoBuilder.setType(resource.getType());
        for (Map.Entry<String, String> keyValuePairs : resource.getLabels().entrySet()) {
            resourceProtoBuilder.putLabels(keyValuePairs.getKey(), keyValuePairs.getValue());
        }
        return resourceProtoBuilder.build();
    }

    private OcAgentNodeUtils() {
    }
}

