/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.monitoring.v3;

import com.google.bigtable.repackaged.com.google.api.MonitoredResource;
import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.bigtable.repackaged.com.google.api.gax.paging.AbstractPage;
import com.google.bigtable.repackaged.com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PageContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.GroupServiceSettings;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.GroupServiceStub;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.GroupServiceStubSettings;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.monitoring.v3.CreateGroupRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.DeleteGroupRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.GetGroupRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.Group;
import com.google.bigtable.repackaged.com.google.monitoring.v3.GroupName;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ListGroupMembersResponse;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ListGroupsRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ListGroupsResponse;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ProjectName;
import com.google.bigtable.repackaged.com.google.monitoring.v3.UpdateGroupRequest;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class GroupServiceClient
implements BackgroundResource {
    private final GroupServiceSettings settings;
    private final GroupServiceStub stub;

    public static final GroupServiceClient create() throws IOException {
        return GroupServiceClient.create(GroupServiceSettings.newBuilder().build());
    }

    public static final GroupServiceClient create(GroupServiceSettings settings) throws IOException {
        return new GroupServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GroupServiceClient create(GroupServiceStub stub) {
        return new GroupServiceClient(stub);
    }

    protected GroupServiceClient(GroupServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GroupServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GroupServiceClient(GroupServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GroupServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GroupServiceStub getStub() {
        return this.stub;
    }

    public final ListGroupsPagedResponse listGroups(ListGroupsRequest request) {
        return this.listGroupsPagedCallable().call(request);
    }

    public final UnaryCallable<ListGroupsRequest, ListGroupsPagedResponse> listGroupsPagedCallable() {
        return this.stub.listGroupsPagedCallable();
    }

    public final UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable() {
        return this.stub.listGroupsCallable();
    }

    public final Group getGroup(GroupName name) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGroup(request);
    }

    public final Group getGroup(String name) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setName(name).build();
        return this.getGroup(request);
    }

    public final Group getGroup(GetGroupRequest request) {
        return this.getGroupCallable().call(request);
    }

    public final UnaryCallable<GetGroupRequest, Group> getGroupCallable() {
        return this.stub.getGroupCallable();
    }

    public final Group createGroup(ProjectName name, Group group) {
        CreateGroupRequest request = CreateGroupRequest.newBuilder().setName(name == null ? null : name.toString()).setGroup(group).build();
        return this.createGroup(request);
    }

    public final Group createGroup(String name, Group group) {
        CreateGroupRequest request = CreateGroupRequest.newBuilder().setName(name).setGroup(group).build();
        return this.createGroup(request);
    }

    public final Group createGroup(CreateGroupRequest request) {
        return this.createGroupCallable().call(request);
    }

    public final UnaryCallable<CreateGroupRequest, Group> createGroupCallable() {
        return this.stub.createGroupCallable();
    }

    public final Group updateGroup(Group group) {
        UpdateGroupRequest request = UpdateGroupRequest.newBuilder().setGroup(group).build();
        return this.updateGroup(request);
    }

    public final Group updateGroup(UpdateGroupRequest request) {
        return this.updateGroupCallable().call(request);
    }

    public final UnaryCallable<UpdateGroupRequest, Group> updateGroupCallable() {
        return this.stub.updateGroupCallable();
    }

    public final void deleteGroup(GroupName name) {
        DeleteGroupRequest request = DeleteGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteGroup(request);
    }

    public final void deleteGroup(String name) {
        DeleteGroupRequest request = DeleteGroupRequest.newBuilder().setName(name).build();
        this.deleteGroup(request);
    }

    public final void deleteGroup(DeleteGroupRequest request) {
        this.deleteGroupCallable().call(request);
    }

    public final UnaryCallable<DeleteGroupRequest, Empty> deleteGroupCallable() {
        return this.stub.deleteGroupCallable();
    }

    public final ListGroupMembersPagedResponse listGroupMembers(GroupName name) {
        ListGroupMembersRequest request = ListGroupMembersRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listGroupMembers(request);
    }

    public final ListGroupMembersPagedResponse listGroupMembers(String name) {
        ListGroupMembersRequest request = ListGroupMembersRequest.newBuilder().setName(name).build();
        return this.listGroupMembers(request);
    }

    public final ListGroupMembersPagedResponse listGroupMembers(ListGroupMembersRequest request) {
        return this.listGroupMembersPagedCallable().call(request);
    }

    public final UnaryCallable<ListGroupMembersRequest, ListGroupMembersPagedResponse> listGroupMembersPagedCallable() {
        return this.stub.listGroupMembersPagedCallable();
    }

    public final UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersCallable() {
        return this.stub.listGroupMembersCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGroupMembersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource, ListGroupMembersPage, ListGroupMembersFixedSizeCollection> {
        private ListGroupMembersFixedSizeCollection(List<ListGroupMembersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGroupMembersFixedSizeCollection createEmptyCollection() {
            return new ListGroupMembersFixedSizeCollection(null, 0);
        }

        @Override
        protected ListGroupMembersFixedSizeCollection createCollection(List<ListGroupMembersPage> pages, int collectionSize) {
            return new ListGroupMembersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGroupMembersPage
    extends AbstractPage<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource, ListGroupMembersPage> {
        private ListGroupMembersPage(PageContext<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource> context, ListGroupMembersResponse response) {
            super(context, response);
        }

        private static ListGroupMembersPage createEmptyPage() {
            return new ListGroupMembersPage(null, null);
        }

        @Override
        protected ListGroupMembersPage createPage(PageContext<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource> context, ListGroupMembersResponse response) {
            return new ListGroupMembersPage(context, response);
        }

        @Override
        public ApiFuture<ListGroupMembersPage> createPageAsync(PageContext<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource> context, ApiFuture<ListGroupMembersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGroupMembersPagedResponse
    extends AbstractPagedListResponse<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource, ListGroupMembersPage, ListGroupMembersFixedSizeCollection> {
        public static ApiFuture<ListGroupMembersPagedResponse> createAsync(PageContext<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource> context, ApiFuture<ListGroupMembersResponse> futureResponse) {
            ApiFuture<ListGroupMembersPage> futurePage = ListGroupMembersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, new ApiFunction<ListGroupMembersPage, ListGroupMembersPagedResponse>(){

                @Override
                public ListGroupMembersPagedResponse apply(ListGroupMembersPage input) {
                    return new ListGroupMembersPagedResponse(input);
                }
            }, MoreExecutors.directExecutor());
        }

        private ListGroupMembersPagedResponse(ListGroupMembersPage page) {
            super(page, ListGroupMembersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage, ListGroupsFixedSizeCollection> {
        private ListGroupsFixedSizeCollection(List<ListGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGroupsFixedSizeCollection createEmptyCollection() {
            return new ListGroupsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListGroupsFixedSizeCollection createCollection(List<ListGroupsPage> pages, int collectionSize) {
            return new ListGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGroupsPage
    extends AbstractPage<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage> {
        private ListGroupsPage(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ListGroupsResponse response) {
            super(context, response);
        }

        private static ListGroupsPage createEmptyPage() {
            return new ListGroupsPage(null, null);
        }

        @Override
        protected ListGroupsPage createPage(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ListGroupsResponse response) {
            return new ListGroupsPage(context, response);
        }

        @Override
        public ApiFuture<ListGroupsPage> createPageAsync(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ApiFuture<ListGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGroupsPagedResponse
    extends AbstractPagedListResponse<ListGroupsRequest, ListGroupsResponse, Group, ListGroupsPage, ListGroupsFixedSizeCollection> {
        public static ApiFuture<ListGroupsPagedResponse> createAsync(PageContext<ListGroupsRequest, ListGroupsResponse, Group> context, ApiFuture<ListGroupsResponse> futureResponse) {
            ApiFuture<ListGroupsPage> futurePage = ListGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, new ApiFunction<ListGroupsPage, ListGroupsPagedResponse>(){

                @Override
                public ListGroupsPagedResponse apply(ListGroupsPage input) {
                    return new ListGroupsPagedResponse(input);
                }
            }, MoreExecutors.directExecutor());
        }

        private ListGroupsPagedResponse(ListGroupsPage page) {
            super(page, ListGroupsFixedSizeCollection.createEmptyCollection());
        }
    }
}

