/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.stats;

import com.google.bigtable.repackaged.com.google.api.MonitoredResource;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.MetricExporter;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Metric;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.stats.BigtableStackdriverExportUtils;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.bigtable.repackaged.com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ProjectName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class BigtableCreateTimeSeriesExporter
extends MetricExporter {
    private static final Logger logger = Logger.getLogger(BigtableCreateTimeSeriesExporter.class.getName());
    private final MetricServiceClient metricServiceClient;
    private final MonitoredResource monitoredResource;
    private final String clientId;

    BigtableCreateTimeSeriesExporter(MetricServiceClient metricServiceClient, MonitoredResource monitoredResource) {
        this.metricServiceClient = metricServiceClient;
        this.monitoredResource = monitoredResource;
        this.clientId = BigtableStackdriverExportUtils.getDefaultTaskValue();
    }

    @Override
    public void export(Collection<Metric> metrics) {
        Map<Object, Object> projectToTimeSeries = new HashMap();
        for (Metric metric : metrics) {
            if (!metric.getMetricDescriptor().getName().contains("bigtable")) continue;
            try {
                projectToTimeSeries = metric.getTimeSeriesList().stream().collect(Collectors.groupingBy(timeSeries -> BigtableStackdriverExportUtils.getProjectId(metric.getMetricDescriptor(), timeSeries), Collectors.mapping(timeSeries -> BigtableStackdriverExportUtils.convertTimeSeries(metric.getMetricDescriptor(), timeSeries, this.clientId, this.monitoredResource), Collectors.toList())));
                for (Map.Entry<Object, Object> entry : projectToTimeSeries.entrySet()) {
                    ProjectName projectName = ProjectName.of((String)entry.getKey());
                    CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName(projectName.toString()).addAllTimeSeries((Iterable)entry.getValue()).build();
                    this.metricServiceClient.createServiceTimeSeries(request);
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Exception thrown when exporting TimeSeries.", e);
            }
        }
    }
}

