/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.ApiClock;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.NanoClock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

final class DynamicFlowControlStats {
    private static final double DEFAULT_DECAY_CONSTANT = 0.015;
    private static final long DECAY_CYCLE_SECOND = TimeUnit.MINUTES.toSeconds(15L);
    private final AtomicLong lastAdjustedTimestampMs = new AtomicLong(0L);
    private final DecayingAverage meanLatency;

    DynamicFlowControlStats() {
        this(0.015, NanoClock.getDefaultClock());
    }

    @InternalApi(value="visible for testing")
    DynamicFlowControlStats(double decayConstant, ApiClock clock) {
        this.meanLatency = new DecayingAverage(decayConstant, clock);
    }

    void updateLatency(long latency) {
        this.meanLatency.update(latency);
    }

    double getMeanLatency() {
        return this.meanLatency.getMean();
    }

    public long getLastAdjustedTimestampMs() {
        return this.lastAdjustedTimestampMs.get();
    }

    boolean setLastAdjustedTimestampMs(long last, long now) {
        return this.lastAdjustedTimestampMs.compareAndSet(last, now);
    }

    private class DecayingAverage {
        private double decayConstant;
        private double mean;
        private double weightedCount;
        private long decayCycleStartEpoch;
        private final ApiClock clock;

        DecayingAverage(double decayConstant, ApiClock clock) {
            this.decayConstant = decayConstant;
            this.mean = 0.0;
            this.weightedCount = 0.0;
            this.clock = clock;
            this.decayCycleStartEpoch = TimeUnit.MILLISECONDS.toSeconds(clock.millisTime());
        }

        synchronized void update(long value) {
            long now = TimeUnit.MILLISECONDS.toSeconds(this.clock.millisTime());
            double weight = this.getWeight(now);
            this.mean = this.mean * (this.weightedCount / (this.weightedCount + weight)) + weight * (double)value / (this.weightedCount + weight);
            this.weightedCount += weight;
        }

        double getMean() {
            return this.mean;
        }

        private double getWeight(long now) {
            long elapsedSecond = now - this.decayCycleStartEpoch;
            double weight = Math.exp(this.decayConstant * (double)elapsedSecond);
            if (elapsedSecond > DECAY_CYCLE_SECOND) {
                this.mean /= weight;
                this.weightedCount /= weight;
                this.decayCycleStartEpoch = now;
                return 1.0;
            }
            return weight;
        }
    }
}

