/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class BulkMutation
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3522061250439399088L;
    private final String tableId;
    private transient MutateRowsRequest.Builder builder;

    public static BulkMutation create(String tableId) {
        return new BulkMutation(tableId);
    }

    private BulkMutation(@Nonnull String tableId) {
        Preconditions.checkNotNull(tableId);
        this.tableId = tableId;
        this.builder = MutateRowsRequest.newBuilder();
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (MutateRowsRequest.Builder)MutateRowsRequest.newBuilder().mergeFrom(input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo(output);
    }

    public BulkMutation add(@Nonnull String rowKey, @Nonnull Mutation mutation) {
        Preconditions.checkNotNull(rowKey);
        Preconditions.checkNotNull(mutation);
        return this.add(ByteString.copyFromUtf8(rowKey), mutation);
    }

    public BulkMutation add(@Nonnull ByteString rowKey, @Nonnull Mutation mutation) {
        Preconditions.checkNotNull(rowKey);
        Preconditions.checkNotNull(mutation);
        this.builder.addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(rowKey).addAllMutations(mutation.getMutations()).build());
        return this;
    }

    public BulkMutation add(@Nonnull RowMutationEntry entry) {
        Preconditions.checkNotNull(entry, "Row mutation entry can't be null");
        this.builder.addEntries(entry.toProto());
        return this;
    }

    public int getEntryCount() {
        return this.builder.getEntriesCount();
    }

    @InternalApi
    public MutateRowsRequest toProto(RequestContext requestContext) {
        String tableName = NameUtil.formatTableName(requestContext.getProjectId(), requestContext.getInstanceId(), this.tableId);
        return this.builder.setTableName(tableName).setAppProfileId(requestContext.getAppProfileId()).build();
    }

    @BetaApi
    public static BulkMutation fromProto(@Nonnull MutateRowsRequest request) {
        BulkMutation bulkMutation = BulkMutation.create(NameUtil.extractTableIdFromTableName(request.getTableName()));
        bulkMutation.builder = request.toBuilder();
        return bulkMutation;
    }

    public BulkMutation clone() {
        BulkMutation bulkMutation = BulkMutation.create(this.tableId);
        bulkMutation.builder = this.builder.clone();
        return bulkMutation;
    }
}

