/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.implcore.internal;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CurrentState {
    private final AtomicReference<InternalState> currentInternalState;

    public CurrentState(State defaultState) {
        this.currentInternalState = new AtomicReference<InternalState>(defaultState == State.ENABLED ? InternalState.ENABLED_NOT_READ : InternalState.DISABLED_NOT_READ);
    }

    public State get() {
        InternalState internalState = this.currentInternalState.get();
        while (!internalState.isRead) {
            this.currentInternalState.compareAndSet(internalState, internalState.state == State.ENABLED ? InternalState.ENABLED_READ : InternalState.DISABLED_READ);
            internalState = this.currentInternalState.get();
        }
        return internalState.state;
    }

    public State getInternal() {
        return this.currentInternalState.get().state;
    }

    public boolean set(State state) {
        InternalState internalState;
        do {
            Preconditions.checkState(!(internalState = this.currentInternalState.get()).isRead, "State was already read, cannot set state.");
            if (state != internalState.state) continue;
            return false;
        } while (!this.currentInternalState.compareAndSet(internalState, state == State.ENABLED ? InternalState.ENABLED_NOT_READ : InternalState.DISABLED_NOT_READ));
        return true;
    }

    private static enum InternalState {
        ENABLED_NOT_READ(State.ENABLED, false),
        ENABLED_READ(State.ENABLED, true),
        DISABLED_NOT_READ(State.DISABLED, false),
        DISABLED_READ(State.DISABLED, true);

        private final State state;
        private final boolean isRead;

        private InternalState(State state, boolean isRead) {
            this.state = state;
            this.isRead = isRead;
        }
    }

    public static enum State {
        ENABLED,
        DISABLED;

    }
}

