/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util;

import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.AutoValue_IntervalMetricReader_Options;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.MetricExporter;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.MetricReader;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

public final class IntervalMetricReader {
    @VisibleForTesting
    static final Duration DEFAULT_INTERVAL = Duration.create(60L, 0);
    private static final Duration ZERO = Duration.create(0L, 0);
    private final Thread workerThread;
    private final Worker worker;

    private IntervalMetricReader(Worker worker) {
        this.worker = worker;
        this.workerThread = new Thread(worker);
        try {
            this.workerThread.setName("ExportWorkerThread");
            this.workerThread.setDaemon(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.workerThread.start();
    }

    public static IntervalMetricReader create(MetricExporter metricExporter, MetricReader metricReader, Options options) {
        Preconditions.checkNotNull(options, "options");
        Duration exportInterval = Preconditions.checkNotNull(options.getExportInterval(), "exportInterval");
        Preconditions.checkArgument(exportInterval.compareTo(ZERO) > 0, "Export interval must be positive");
        return new IntervalMetricReader(new Worker(Preconditions.checkNotNull(metricExporter, "metricExporter"), exportInterval.toMillis(), Preconditions.checkNotNull(metricReader, "metricReader")));
    }

    public void readAndExportNow() {
        this.worker.readAndExport();
    }

    public void stop() {
        this.workerThread.interrupt();
    }

    private static final class Worker
    implements Runnable {
        private final MetricExporter metricExporter;
        private final long exportInterval;
        private final MetricReader metricReader;

        private Worker(MetricExporter metricExporter, long exportInterval, MetricReader metricReader) {
            this.metricExporter = metricExporter;
            this.exportInterval = exportInterval;
            this.metricReader = metricReader;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.exportInterval);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
                this.readAndExport();
            }
            this.readAndExport();
        }

        private void readAndExport() {
            this.metricReader.readAndExport(this.metricExporter);
        }
    }

    @Immutable
    public static abstract class Options {
        Options() {
        }

        public abstract Duration getExportInterval();

        public static Builder builder() {
            return new AutoValue_IntervalMetricReader_Options.Builder().setExportInterval(DEFAULT_INTERVAL);
        }

        public static abstract class Builder {
            public abstract Builder setExportInterval(Duration var1);

            public abstract Options build();
        }
    }
}

