/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.delegates;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.engine.EngineMetrics;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IEngineMetric;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.TransformStatus;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

@GuiPlugin(description="Pipeline Graph Grid Delegate")
public class HopGuiPipelineGridDelegate {
    private static final Class<?> PKG = HopGui.class;
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "HopGuiWorkflowGridDelegate-ToolBar";
    public static final String TOOLBAR_ICON_SHOW_HIDE_INACTIVE = "ToolbarIcon-10000-ShowHideInactive";
    public static final String TOOLBAR_ICON_SHOW_HIDE_SELECTED = "ToolbarIcon-10010-ShowHideSelected";
    public static final long UPDATE_TIME_VIEW = 1000L;
    private HopGui hopGui;
    private HopGuiPipelineGraph pipelineGraph;
    private CTabItem pipelineGridTab;
    private TableView pipelineGridView;
    private ToolBar toolbar;
    private GuiToolbarWidgets toolbarWidget;
    private Composite pipelineGridComposite;
    private boolean hideInactiveTransforms;
    private boolean showSelectedTransforms;
    private final ReentrantLock refreshViewLock;
    private List<ColumnInfo> previousRefreshColumns = null;
    private static final String METRICS_FORMAT = " ###,###,###,###";
    private static NumberFormat metricFormat = new DecimalFormat(" ###,###,###,###");

    public HopGuiPipelineGridDelegate(HopGui hopGui, HopGuiPipelineGraph pipelineGraph) {
        this.hopGui = hopGui;
        this.pipelineGraph = pipelineGraph;
        this.refreshViewLock = new ReentrantLock();
        this.hideInactiveTransforms = false;
    }

    public void showGridView() {
        if (this.pipelineGridTab == null || this.pipelineGridTab.isDisposed()) {
            this.addPipelineGrid();
        } else {
            this.pipelineGridTab.dispose();
            this.pipelineGraph.checkEmptyExtraView();
        }
    }

    public void addPipelineGrid() {
        if (this.pipelineGraph.extraViewTabFolder == null || this.pipelineGraph.extraViewTabFolder.isDisposed()) {
            this.pipelineGraph.addExtraView();
        } else if (this.pipelineGridTab != null && !this.pipelineGridTab.isDisposed()) {
            this.pipelineGraph.extraViewTabFolder.setSelection(this.pipelineGridTab);
            return;
        }
        this.pipelineGridTab = new CTabItem(this.pipelineGraph.extraViewTabFolder, 0);
        this.pipelineGridTab.setImage(GuiResource.getInstance().getImageShowGrid());
        this.pipelineGridTab.setText(BaseMessages.getString(PKG, (String)"HopGui.PipelineGraph.GridTab.Name", (String[])new String[0]));
        this.pipelineGridComposite = new Composite((Composite)this.pipelineGraph.extraViewTabFolder, 0);
        this.pipelineGridComposite.setLayout((Layout)new FormLayout());
        this.addToolBar();
        String transformNameColumnName = BaseMessages.getString(PKG, (String)"PipelineLog.Column.TransformName", (String[])new String[0]);
        ValueMetaString valueMeta = new ValueMetaString(transformNameColumnName);
        valueMeta.setIgnoreWhitespace(true);
        ColumnInfo transformNameColumnInfo = new ColumnInfo(transformNameColumnName, 1, false, true);
        transformNameColumnInfo.setValueMeta((IValueMeta)valueMeta);
        ColumnInfo[] columns = new ColumnInfo[]{transformNameColumnInfo, new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Copynr", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Read", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Written", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Input", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Output", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Updated", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Rejected", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Errors", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Active", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Time", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Speed", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.PriorityBufferSizes", (String[])new String[0]), 1, false, true)};
        columns[1].setAlignment(131072);
        columns[2].setAlignment(131072);
        columns[3].setAlignment(131072);
        columns[4].setAlignment(131072);
        columns[5].setAlignment(131072);
        columns[6].setAlignment(131072);
        columns[7].setAlignment(131072);
        columns[8].setAlignment(131072);
        columns[9].setAlignment(16384);
        columns[10].setAlignment(131072);
        columns[11].setAlignment(131072);
        columns[12].setAlignment(131072);
        this.pipelineGridView = new TableView(this.pipelineGraph.getVariables(), this.pipelineGridComposite, 67586, columns, 1, true, null, this.hopGui.getProps());
        FormData fdView = new FormData();
        fdView.left = new FormAttachment(0, 0);
        fdView.right = new FormAttachment(100, 0);
        fdView.top = new FormAttachment((Control)this.toolbar, 0);
        fdView.bottom = new FormAttachment(100, 0);
        this.pipelineGridView.setLayoutData(fdView);
        ColumnInfo numberColumn = this.pipelineGridView.getNumberColumn();
        ValueMetaString numberColumnValueMeta = new ValueMetaString("#", HopGuiPipelineGridDelegate::subTransformCompare);
        numberColumn.setValueMeta((IValueMeta)numberColumnValueMeta);
        Timer tim = new Timer("HopGuiPipelineGraph: " + this.pipelineGraph.getMeta().getName());
        TimerTask timtask = new TimerTask(){

            @Override
            public void run() {
                if (!HopGuiPipelineGridDelegate.this.hopGui.getDisplay().isDisposed()) {
                    HopGuiPipelineGridDelegate.this.hopGui.getDisplay().asyncExec(() -> HopGuiPipelineGridDelegate.this.refreshView());
                }
            }
        };
        tim.schedule(timtask, 0L, 1000L);
        this.pipelineGridTab.addDisposeListener(disposeEvent -> tim.cancel());
        this.pipelineGridTab.setControl((Control)this.pipelineGridComposite);
        this.pipelineGraph.extraViewTabFolder.setSelection(this.pipelineGridTab);
    }

    public static HopGuiPipelineGridDelegate getInstance() {
        IHopFileTypeHandler fileTypeHandler = HopGui.getInstance().getActiveFileTypeHandler();
        if (fileTypeHandler instanceof HopGuiPipelineGraph) {
            HopGuiPipelineGraph graph = (HopGuiPipelineGraph)fileTypeHandler;
            return graph.pipelineGridDelegate;
        }
        return null;
    }

    private void addToolBar() {
        this.toolbar = new ToolBar(this.pipelineGridComposite, 16704);
        FormData fdToolBar = new FormData();
        fdToolBar.left = new FormAttachment(0, 0);
        fdToolBar.top = new FormAttachment(0, 0);
        fdToolBar.right = new FormAttachment(100, 0);
        this.toolbar.setLayoutData((Object)fdToolBar);
        this.hopGui.getProps().setLook((Control)this.toolbar, 6);
        this.toolbarWidget = new GuiToolbarWidgets();
        this.toolbarWidget.registerGuiPluginObject(this);
        this.toolbarWidget.createToolbarWidgets((Composite)this.toolbar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        this.toolbar.pack();
    }

    @GuiToolbarElement(root="HopGuiWorkflowGridDelegate-ToolBar", id="ToolbarIcon-10000-ShowHideInactive", toolTip="i18n:org.apache.hop.ui.hopgui:PipelineLog.Button.ShowOnlyActiveTransforms", image="ui/images/show.svg")
    public void showHideInactive() {
        this.hideInactiveTransforms = !this.hideInactiveTransforms;
        ToolItem toolItem = this.toolbarWidget.findToolItem(TOOLBAR_ICON_SHOW_HIDE_INACTIVE);
        if (toolItem != null) {
            if (this.hideInactiveTransforms) {
                toolItem.setImage(GuiResource.getInstance().getImageHide());
            } else {
                toolItem.setImage(GuiResource.getInstance().getImageShow());
            }
        }
        this.refreshView();
    }

    @GuiToolbarElement(root="HopGuiWorkflowGridDelegate-ToolBar", id="ToolbarIcon-10010-ShowHideSelected", toolTip="i18n:org.apache.hop.ui.hopgui:PipelineLog.Button.ShowOnlySelectedTransforms", image="ui/images/show-all.svg")
    public void showHideSelected() {
        this.showSelectedTransforms = !this.showSelectedTransforms;
        ToolItem toolItem = this.toolbarWidget.findToolItem(TOOLBAR_ICON_SHOW_HIDE_SELECTED);
        if (toolItem != null) {
            if (this.showSelectedTransforms) {
                toolItem.setImage(GuiResource.getInstance().getImageShowSelected());
            } else {
                toolItem.setImage(GuiResource.getInstance().getImageShowAll());
            }
        }
        this.refreshView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshView() {
        this.refreshViewLock.lock();
        try {
            if (this.pipelineGraph.pipeline == null || this.pipelineGridView == null || this.pipelineGridView.isDisposed()) {
                return;
            }
            EngineMetrics engineMetrics = this.pipelineGraph.pipeline.getEngineMetrics();
            ArrayList<IEngineComponent> shownComponents = new ArrayList<IEngineComponent>();
            for (IEngineComponent component : engineMetrics.getComponents()) {
                boolean select = true;
                select = select && (!this.hideInactiveTransforms || component.isRunning());
                if (!(select = select && (!this.showSelectedTransforms || component.isSelected()))) continue;
                shownComponents.add(component);
            }
            ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
            columns.add(new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.TransformName", (String[])new String[0]), 1, false, true));
            ColumnInfo copyColumn = new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineLog.Column.Copynr", (String[])new String[0]), 1, true, true);
            copyColumn.setAlignment(131072);
            columns.add(copyColumn);
            ArrayList usedMetrics = new ArrayList(engineMetrics.getMetricsList());
            Collections.sort(usedMetrics, (o1, o2) -> o1.getDisplayPriority().compareTo(o2.getDisplayPriority()));
            for (IEngineMetric metric : usedMetrics) {
                ColumnInfo column = new ColumnInfo(metric.getHeader(), 1, metric.isNumeric(), true);
                column.setToolTip(metric.getTooltip());
                ValueMetaString stringMeta = new ValueMetaString(metric.getCode());
                ValueMetaInteger valueMeta = new ValueMetaInteger(metric.getCode(), 15, 0);
                valueMeta.setConversionMask(METRICS_FORMAT);
                stringMeta.setConversionMetadata((IValueMeta)valueMeta);
                column.setValueMeta((IValueMeta)stringMeta);
                column.setAlignment(131072);
                columns.add(column);
            }
            ValueMetaString stringMeta = new ValueMetaString("string");
            ColumnInfo durationColumn = new ColumnInfo("Duration", 1, false, true);
            durationColumn.setValueMeta((IValueMeta)stringMeta);
            durationColumn.setAlignment(131072);
            columns.add(durationColumn);
            ValueMetaInteger speedMeta = new ValueMetaInteger("speed", 15, 0);
            speedMeta.setConversionMask(" ###,###,###,##0");
            stringMeta.setConversionMetadata((IValueMeta)speedMeta);
            ColumnInfo speedColumn = new ColumnInfo("Speed", 1, false, true);
            speedColumn.setValueMeta((IValueMeta)stringMeta);
            speedColumn.setAlignment(131072);
            columns.add(speedColumn);
            columns.add(new ColumnInfo("Status", 1, false, true));
            ArrayList componentStringsList = new ArrayList();
            int row = 1;
            for (IEngineComponent component : shownComponents) {
                ArrayList<String> componentStrings = new ArrayList<String>();
                componentStrings.add(Integer.toString(row++));
                componentStrings.add(Const.NVL((String)component.getName(), (String)""));
                componentStrings.add(Integer.toString(component.getCopyNr()));
                for (IEngineMetric metric : usedMetrics) {
                    Long value = engineMetrics.getComponentMetric(component, metric);
                    componentStrings.add(value == null ? "" : this.formatMetric(value));
                }
                String duration = this.calculateDuration(component);
                componentStrings.add(duration);
                String speed = (String)engineMetrics.getComponentSpeedMap().get(component);
                componentStrings.add(Const.NVL((String)speed, (String)""));
                String status = (String)engineMetrics.getComponentStatusMap().get(component);
                componentStrings.add(Const.NVL((String)status, (String)""));
                componentStringsList.add(componentStrings);
            }
            if (this.haveColumnsChanged(columns)) {
                this.pipelineGridView.dispose();
                this.pipelineGridView = new TableView(this.pipelineGraph.getVariables(), this.pipelineGridComposite, 0, columns.toArray(new ColumnInfo[0]), shownComponents.size(), null, PropsUi.getInstance());
                this.pipelineGridView.setSortable(false);
                FormData fdView = new FormData();
                fdView.left = new FormAttachment(0, 0);
                fdView.right = new FormAttachment(100, 0);
                fdView.top = new FormAttachment((Control)this.toolbar, 0);
                fdView.bottom = new FormAttachment(100, 0);
                this.pipelineGridView.setLayoutData(fdView);
                this.pipelineGridComposite.layout(true, true);
            }
            while (this.pipelineGridView.table.getItemCount() > componentStringsList.size()) {
                this.pipelineGridView.table.remove(this.pipelineGridView.table.getItemCount() - 1);
            }
            for (row = 0; row < componentStringsList.size(); ++row) {
                List componentStrings = (List)componentStringsList.get(row);
                TableItem item = row < this.pipelineGridView.table.getItemCount() ? this.pipelineGridView.table.getItem(row) : new TableItem(this.pipelineGridView.table, 0);
                for (int col = 0; col < componentStrings.size(); ++col) {
                    item.setText(col, (String)componentStrings.get(col));
                }
            }
            this.pipelineGridView.optWidth(true);
            this.previousRefreshColumns = columns;
        }
        finally {
            this.refreshViewLock.unlock();
        }
    }

    private boolean haveColumnsChanged(List<ColumnInfo> columns) {
        if (this.previousRefreshColumns == null) {
            return true;
        }
        if (this.previousRefreshColumns.size() != columns.size()) {
            return true;
        }
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo newColumn = columns.get(i);
            ColumnInfo prvColumn = this.previousRefreshColumns.get(i);
            if (!newColumn.getName().equals(prvColumn.getName())) {
                return true;
            }
            if (newColumn.getType() == prvColumn.getType()) continue;
            return true;
        }
        return false;
    }

    private String calculateDuration(IEngineComponent component) {
        String duration;
        Date firstRowReadDate = component.getFirstRowReadDate();
        if (firstRowReadDate != null) {
            long durationMs = component.getLastRowWrittenDate() == null ? System.currentTimeMillis() - firstRowReadDate.getTime() : component.getLastRowWrittenDate().getTime() - firstRowReadDate.getTime();
            duration = Utils.getDurationHMS((double)((double)durationMs / 1000.0));
        } else {
            duration = "";
        }
        return duration;
    }

    private String formatMetric(Long value) {
        return metricFormat.format(value);
    }

    private void updateRowFromBaseTransform(ITransform baseTransform, TableItem row) {
        TransformStatus transformStatus = new TransformStatus((IEngineComponent)baseTransform);
        String[] fields = transformStatus.getPipelineLogFields();
        this.updateCellsIfChanged(fields, row);
        if (baseTransform.getErrors() > 0L) {
            row.setBackground(GuiResource.getInstance().getColorRed());
        } else {
            row.setBackground(GuiResource.getInstance().getColorWhite());
        }
    }

    private void updateCellsIfChanged(String[] fields, TableItem row) {
        for (int f = 1; f < fields.length; ++f) {
            if (fields[f].equalsIgnoreCase(row.getText(f))) continue;
            row.setText(f, fields[f]);
        }
    }

    public CTabItem getPipelineGridTab() {
        return this.pipelineGridTab;
    }

    static int subTransformCompare(Object o1, Object o2) {
        String[] string1 = o1.toString().split("\\.");
        String[] string2 = o2.toString().split("\\.");
        int cmp = Integer.compare(Integer.parseInt(string1[0]), Integer.parseInt(string2[0]));
        if (cmp == 0) {
            if (string1.length == 2 && string2.length == 2) {
                cmp = Integer.compare(Integer.parseInt(string1[1]), Integer.parseInt(string2[1]));
            } else if (string1.length < string2.length) {
                cmp = -1;
            } else if (string2.length < string1.length) {
                cmp = 1;
            }
        }
        return cmp;
    }
}

