/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserObjectsOwnedListEntry;
import com.ibm.as400.access.UserSpace;
import java.io.IOException;

public class UserObjectsOwnedList {
    private static final String USERSPACE_NAME = "JT4SYLOBJAQTEMP     ";
    private static final String USERSPACE_PATH = "/QSYS.LIB/QTEMP.LIB/JT4SYLOBJA.USRSPC";
    private static final String CONTINUATION_HANDLE_BLANKS = "                    ";
    public static final int SELECTION_FILE_SYSTEM_LIBRARY = 0;
    private static final String SELECTION_FILE_SYSTEM_LIBRARY_0300 = "OBJA0300";
    public static final int SELECTION_FILE_SYSTEM_DIRECTORY = 1;
    private static final String SELECTION_FILE_SYSTEM_DIRECTORY_0310 = "OBJA0310";
    public static final int SELECTION_OBJECT_RELATION_AUTHORIZED = 0;
    private static final String SELECTION_OBJECT_RELATION_AUTHORIZED_PRIV = "*OBJAUT   ";
    public static final int SELECTION_OBJECT_RELATION_OWNED = 1;
    private static final String SELECTION_OBJECT_RELATION_OWNED_PRIV = "*OBJOWN   ";
    public static final int SELECTION_OBJECT_RELATION_OWNED_OR_AUTHORIZED = 2;
    private static final String SELECTION_OBJECT_RELATION_OWNED_OR_AUTHORIZED_PRIV = "*BOTH     ";
    private static final String SELECTION_OBJECT_TYPE_ALL_PRIV = "*ALL      ";
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private AS400 system_;
    private String userName_;
    private String selectionFileSystem_;
    private String selectionObjectRelation_;

    public UserObjectsOwnedList(AS400 aS400, String string) {
        this(aS400, string, 0, 1);
    }

    public UserObjectsOwnedList(AS400 aS400, String string, int n, int n2) {
        this.setSystem(aS400);
        this.setUserName(string);
        this.setSelectionFileSystem(n);
        this.setSelectionObjectRelation(n2);
        if (Trace.traceOn_) {
            Trace.log(1, this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserObjectsOwnedListEntry[] getObjectList() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n = this.system_.getCcsid();
        CharConverter charConverter = new CharConverter(n);
        ProgramParameter[] programParameterArray = new ProgramParameter[7];
        programParameterArray[0] = new ProgramParameter(charConverter.stringToByteArray(USERSPACE_NAME));
        programParameterArray[1] = new ProgramParameter(charConverter.stringToByteArray(this.selectionFileSystem_));
        StringBuffer stringBuffer = new StringBuffer("          ");
        stringBuffer.replace(0, this.userName_.length(), this.userName_);
        programParameterArray[2] = new ProgramParameter(charConverter.stringToByteArray(stringBuffer.toString()));
        programParameterArray[3] = new ProgramParameter(charConverter.stringToByteArray(SELECTION_OBJECT_TYPE_ALL_PRIV));
        programParameterArray[4] = new ProgramParameter(charConverter.stringToByteArray(this.selectionObjectRelation_));
        programParameterArray[5] = new ProgramParameter(charConverter.stringToByteArray(CONTINUATION_HANDLE_BLANKS));
        programParameterArray[6] = errorCode_;
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QSYLOBJA.PGM", programParameterArray);
        programCall.suggestThreadsafe();
        boolean bl = programCall.isStayOnThread();
        Object object = bl ? USERSPACE_PATH : this.system_;
        byte[] byArray = null;
        Object object2 = object;
        synchronized (object2) {
            UserSpace userSpace = new UserSpace(this.system_, USERSPACE_PATH);
            try {
                userSpace.setMustUseProgramCall(true);
                if (!bl) {
                    userSpace.setMustUseSockets(true);
                }
                userSpace.create(262144, true, "", (byte)0, "User space for UserObjectsOwnedList", "*EXCLUDE");
                if (!programCall.run()) {
                    throw new AS400Exception(programCall.getMessageList());
                }
                int n2 = userSpace.getLength();
                byArray = new byte[n2];
                userSpace.read(byArray, 0);
            }
            finally {
                try {
                    userSpace.delete();
                }
                catch (Exception exception) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                }
            }
        }
        int n3 = BinaryConverter.byteArrayToInt(byArray, 116);
        int n4 = BinaryConverter.byteArrayToInt(byArray, 124);
        int n5 = BinaryConverter.byteArrayToInt(byArray, 132);
        int n6 = BinaryConverter.byteArrayToInt(byArray, 136);
        int n7 = BinaryConverter.byteArrayToInt(byArray, 140);
        String string = charConverter.byteArrayToString(byArray, 103, 1);
        if (n7 == 0) {
            n7 = n;
        }
        charConverter = new CharConverter(n7);
        String string2 = charConverter.byteArrayToString(byArray, n3 + 10, 20).trim();
        int n8 = BinaryConverter.byteArrayToInt(byArray, n3 + 30);
        if (Trace.traceOn_) {
            Trace.log(1, "UserObjectsOwnedList.getObjectList()  informationStatus='" + string + "' reasonCode='" + n8 + "' continuationHandle='" + string2 + "' numEntries='" + n5 + "'");
        }
        UserObjectsOwnedListEntry[] userObjectsOwnedListEntryArray = new UserObjectsOwnedListEntry[n5];
        int n9 = n4;
        for (int i = 0; i < n5; ++i) {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            String string12;
            String string13;
            String string14;
            String string15;
            String string16;
            String string17;
            String string18;
            String string19;
            String string20;
            if (this.selectionFileSystem_.equals(SELECTION_FILE_SYSTEM_LIBRARY_0300)) {
                n9 = n4 + i * n6;
                String string21 = charConverter.byteArrayToString(byArray, n9, 10).trim();
                String string22 = charConverter.byteArrayToString(byArray, n9 += 10, 10).trim();
                string20 = charConverter.byteArrayToString(byArray, n9 += 10, 10).trim();
                string19 = charConverter.byteArrayToString(byArray, n9 += 10, 1).trim();
                string18 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
                string17 = charConverter.byteArrayToString(byArray, ++n9, 10).trim();
                string16 = charConverter.byteArrayToString(byArray, n9 += 10, 1).trim();
                string15 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
                string14 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
                string13 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
                string12 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
                string11 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
                string10 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
                string9 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
                string8 = charConverter.byteArrayToString(byArray, ++n9, 10).trim();
                string7 = charConverter.byteArrayToString(byArray, n9 += 10, 50).trim();
                string6 = charConverter.byteArrayToString(byArray, n9 += 50, 1).trim();
                ++n9;
                string5 = charConverter.byteArrayToString(byArray, n9 += 10, 1).trim();
                string4 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
                String string23 = charConverter.byteArrayToString(byArray, ++n9, 10).trim();
                string3 = charConverter.byteArrayToString(byArray, n9 += 10, 10).trim();
                n9 += 10;
                userObjectsOwnedListEntryArray[i] = new UserObjectsOwnedListEntry(string21, string22, string20, string19, string18, string17, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7, string6, string5, string4, string23, string3);
                continue;
            }
            int n10 = BinaryConverter.byteArrayToInt(byArray, n9);
            int n11 = BinaryConverter.byteArrayToInt(byArray, n9 += 4);
            string20 = charConverter.byteArrayToString(byArray, n9 += 4, 10).trim();
            string19 = charConverter.byteArrayToString(byArray, n9 += 10, 1).trim();
            string18 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
            string17 = charConverter.byteArrayToString(byArray, ++n9, 10).trim();
            string16 = charConverter.byteArrayToString(byArray, n9 += 10, 1).trim();
            string15 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
            string14 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
            string13 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
            string5 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
            string4 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
            ++n9;
            string12 = charConverter.byteArrayToString(byArray, n9 += 10, 1).trim();
            string11 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
            string10 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
            string9 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
            string6 = charConverter.byteArrayToString(byArray, ++n9, 1).trim();
            ++n9;
            string8 = charConverter.byteArrayToString(byArray, n9 += 10, 10).trim();
            string7 = charConverter.byteArrayToString(byArray, n9 += 10, 50).trim();
            string3 = charConverter.byteArrayToString(byArray, n9 += 50, 10).trim();
            n9 += 10;
            int n12 = BinaryConverter.byteArrayToInt(byArray, n10 + 0);
            CharConverter charConverter2 = new CharConverter(n12);
            String string24 = charConverter2.byteArrayToString(byArray, n10 + 32, n11 - 32).trim();
            n9 += 10;
            n9 = n10 + n11;
            userObjectsOwnedListEntryArray[i] = new UserObjectsOwnedListEntry(string20, string19, string18, string17, string16, string15, string14, string13, string12, string11, string10, string9, string8, string7, string6, string5, string4, string3, string24);
        }
        return userObjectsOwnedListEntryArray;
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public void setUserName(String string) {
        if (string == null) {
            throw new NullPointerException("userName");
        }
        this.userName_ = string;
    }

    public String getUserName() {
        return this.userName_;
    }

    public void setSelectionFileSystem(int n) {
        switch (n) {
            case 0: {
                this.selectionFileSystem_ = SELECTION_FILE_SYSTEM_LIBRARY_0300;
                break;
            }
            case 1: {
                this.selectionFileSystem_ = SELECTION_FILE_SYSTEM_DIRECTORY_0310;
                break;
            }
            default: {
                Trace.log(2, "UserObjectsOwnedList.setSelectionFileSystem() PARAMETER_VALUE_NOT_VALID");
                throw new ExtendedIllegalArgumentException("selectionFileSystem", 2);
            }
        }
    }

    public int getSelectionFileSystem() {
        if (this.selectionFileSystem_.equals(SELECTION_FILE_SYSTEM_LIBRARY_0300)) {
            return 0;
        }
        return 1;
    }

    public void setSelectionObjectRelation(int n) {
        switch (n) {
            case 0: {
                this.selectionObjectRelation_ = SELECTION_OBJECT_RELATION_AUTHORIZED_PRIV;
                break;
            }
            case 1: {
                this.selectionObjectRelation_ = SELECTION_OBJECT_RELATION_OWNED_PRIV;
                break;
            }
            case 2: {
                this.selectionObjectRelation_ = SELECTION_OBJECT_RELATION_OWNED_OR_AUTHORIZED_PRIV;
                break;
            }
            default: {
                Trace.log(2, "UserObjectsOwnedList.setSelectionObjectRelation() PARAMETER_VALUE_NOT_VALID");
                throw new ExtendedIllegalArgumentException("selectionObjectRelation", 2);
            }
        }
    }

    public int getSelectionObjectRelation() {
        if (this.selectionObjectRelation_.equals(SELECTION_OBJECT_RELATION_AUTHORIZED_PRIV)) {
            return 0;
        }
        if (this.selectionObjectRelation_.equals(SELECTION_OBJECT_RELATION_OWNED_PRIV)) {
            return 1;
        }
        return 2;
    }

    public String toString() {
        String string = "UserObjectsOwnedList (getSystem()=" + this.getSystem() + " getUserName()=" + this.getUserName() + " getSelectionFileSystem()=" + this.getSelectionFileSystem() + " getSelectionObjectRelation()=" + this.getSelectionObjectRelation() + ")";
        return string;
    }
}

