/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.actions.check;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.actions.check.CheckConnections;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CheckConnectionsDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = CheckConnectionsDialog.class;
    private CheckConnections action;
    private boolean changed;
    private Text wName;
    private TableView wConnections;

    public CheckConnectionsDialog(Shell parent, IAction iAction, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (CheckConnections)iAction;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"CheckConnectionsDialog.Dialog.Title", (String[])new String[0]));
        }
    }

    public IAction open() {
        String[] availableConnectionNames;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText("Check Neo4j Connections");
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText("Action name");
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlConnections = new Label((Composite)this.shell, 16384);
        wlConnections.setText(BaseMessages.getString(PKG, (String)"CheckConnectionsDialog.Connections.Label", (String[])new String[0]));
        this.props.setLook((Control)wlConnections);
        FormData fdlConnections = new FormData();
        fdlConnections.left = new FormAttachment(0, 0);
        fdlConnections.right = new FormAttachment(middle, -margin);
        fdlConnections.top = new FormAttachment((Control)this.wName, margin);
        wlConnections.setLayoutData((Object)fdlConnections);
        try {
            IHopMetadataSerializer connectionSerializer = this.getMetadataProvider().getSerializer(NeoConnection.class);
            List names = connectionSerializer.listObjectNames();
            Collections.sort(names);
            availableConnectionNames = names.toArray(new String[0]);
        }
        catch (HopException e2) {
            availableConnectionNames = new String[]{};
        }
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"CheckConnectionsDialog.ConnectionName.Column.Label", (String[])new String[0]), 2, availableConnectionNames, false)};
        columns[0].setUsingVariables(true);
        this.wConnections = new TableView((IVariables)this.action, (Composite)this.shell, 67586, columns, this.action.getConnectionNames().size(), false, lsMod, this.props);
        FormData fdConnections = new FormData();
        fdConnections.left = new FormAttachment(0, 0);
        fdConnections.top = new FormAttachment((Control)wlConnections, margin);
        fdConnections.right = new FormAttachment(100, 0);
        fdConnections.bottom = new FormAttachment((Control)wOk, -margin * 2);
        this.wConnections.setLayoutData((Object)fdConnections);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void getData() {
        this.wName.setText(Const.NVL((String)this.action.getName(), (String)""));
        this.wConnections.removeAll();
        for (int i = 0; i < this.action.getConnectionNames().size(); ++i) {
            this.wConnections.add(new String[]{Const.NVL((String)this.action.getConnectionNames().get(i), (String)"")});
        }
        this.wConnections.removeEmptyRows();
        this.wConnections.setRowNums();
        this.wConnections.optWidth(true);
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"CheckConnectionsDialog.MissingName.Warning.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"CheckConnectionsDialog.MissingName.Warning.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        int nrItems = this.wConnections.nrNonEmpty();
        this.action.setConnectionNames(new ArrayList<String>());
        for (int i = 0; i < nrItems; ++i) {
            String connectionName = this.wConnections.getNonEmpty(i).getText(1);
            this.action.getConnectionNames().add(connectionName);
        }
        this.dispose();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

