/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRecord;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.ClickHouseVersion;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseDatabaseMetaData;
import com.clickhouse.jdbc.ClickHouseDriver;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.JdbcConfig;
import com.clickhouse.jdbc.JdbcParameterizedQuery;
import com.clickhouse.jdbc.JdbcParseHandler;
import com.clickhouse.jdbc.JdbcWrapper;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.AbstractPreparedStatement;
import com.clickhouse.jdbc.internal.ClickHouseJdbcUrlParser;
import com.clickhouse.jdbc.internal.ClickHouseStatementImpl;
import com.clickhouse.jdbc.internal.FakeTransaction;
import com.clickhouse.jdbc.internal.InputBasedPreparedStatement;
import com.clickhouse.jdbc.internal.SqlBasedPreparedStatement;
import com.clickhouse.jdbc.internal.TableBasedPreparedStatement;
import com.clickhouse.jdbc.parser.ClickHouseSqlParser;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import com.clickhouse.jdbc.parser.StatementType;
import java.io.Serializable;
import java.net.URI;
import java.sql.ClientInfoStatus;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class ClickHouseConnectionImpl
extends JdbcWrapper
implements ClickHouseConnection {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseConnectionImpl.class);
    private static final String CREATE_DB = "create database if not exists `";
    private final JdbcConfig jdbcConf;
    private final ClickHouseClient client;
    private final ClickHouseRequest<?> clientRequest;
    private boolean autoCommit;
    private boolean closed;
    private String database;
    private boolean readOnly;
    private int networkTimeout;
    private int rsHoldability;
    private int txIsolation;
    private final Optional<TimeZone> clientTimeZone;
    private final Calendar defaultCalendar;
    private final TimeZone jvmTimeZone;
    private final TimeZone serverTimeZone;
    private final ClickHouseVersion serverVersion;
    private final String user;
    private final int initialReadOnly;
    private final Map<String, Class<?>> typeMap;
    private final AtomicReference<FakeTransaction> fakeTransaction;
    private URI uri;

    protected static ClickHouseRecord getServerInfo(ClickHouseNode node, ClickHouseRequest<?> request, boolean createDbIfNotExist) throws SQLException {
        ClickHouseRequest<?> newReq = request.copy();
        if (!createDbIfNotExist) {
            newReq.option(ClickHouseClientOption.DATABASE, (Serializable)((Object)""));
        }
        ClickHouseResponse response = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)newReq.option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false))).option(ClickHouseClientOption.COMPRESS, Boolean.valueOf(false))).option(ClickHouseClientOption.DECOMPRESS, Boolean.valueOf(false))).option(ClickHouseClientOption.FORMAT, (Serializable)((Object)ClickHouseFormat.RowBinaryWithNamesAndTypes))).query("select currentUser(), timezone(), version(), getSetting('readonly') readonly FORMAT RowBinaryWithNamesAndTypes")).execute().get();
        try {
            ClickHouseRecord clickHouseRecord = response.firstRecord();
            if (response != null) {
                response.close();
            }
            return clickHouseRecord;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException | CancellationException e) {
                Thread.currentThread().interrupt();
                throw SqlExceptionUtils.forCancellation(e);
            }
            catch (Exception e) {
                SQLException sqlExp = SqlExceptionUtils.handle(e);
                if (createDbIfNotExist && sqlExp.getErrorCode() == 81) {
                    String db = node.getDatabase(request.getConfig());
                    ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)newReq.use("")).query(new StringBuilder(CREATE_DB.length() + 1 + db.length()).append(CREATE_DB).append(db).append('`').toString())).execute().get();
                    try {
                        ClickHouseRecord clickHouseRecord = ClickHouseConnectionImpl.getServerInfo(node, request, false);
                        if (resp != null) {
                            resp.close();
                        }
                        return clickHouseRecord;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (resp != null) {
                                try {
                                    resp.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                            }
                            throw throwable3;
                        }
                        catch (InterruptedException | CancellationException ex) {
                            Thread.currentThread().interrupt();
                            throw SqlExceptionUtils.forCancellation(ex);
                        }
                        catch (SQLException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            throw SqlExceptionUtils.handle(ex);
                        }
                    }
                }
                throw sqlExp;
            }
        }
    }

    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            throw SqlExceptionUtils.clientError("Cannot operate on a closed connection");
        }
    }

    protected void ensureSupport(String feature, boolean silent) throws SQLException {
        String msg = feature + " is not supported";
        if (this.jdbcConf.isJdbcCompliant()) {
            if (silent) {
                log.debug((Object)"[JDBC Compliant Mode] %s. You may change %s to false to throw SQLException instead.", msg, "jdbcCompliant");
            } else {
                log.warn((Object)"[JDBC Compliant Mode] %s. You may change %s to false to throw SQLException instead.", msg, "jdbcCompliant");
            }
        } else if (!silent) {
            throw SqlExceptionUtils.unsupportedError(msg);
        }
    }

    protected void ensureTransactionSupport() throws SQLException {
        this.ensureSupport("Transaction", false);
    }

    protected List<ClickHouseColumn> getTableColumns(String dbName, String tableName, String columns) throws SQLException {
        List<ClickHouseColumn> list;
        if (tableName == null || columns == null) {
            throw SqlExceptionUtils.clientError("Failed to extract table and columns from the query");
        }
        columns = columns.isEmpty() ? "*" : columns.substring(1);
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ").append(columns).append(" FROM ");
        if (!ClickHouseChecker.isNullOrEmpty(dbName)) {
            builder.append('`').append(ClickHouseUtils.escape(dbName, '`')).append('`').append('.');
        }
        builder.append('`').append(ClickHouseUtils.escape(tableName, '`')).append('`').append(" WHERE 0");
        try (ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)this.clientRequest.copy().format(ClickHouseFormat.RowBinaryWithNamesAndTypes)).query(builder.toString())).execute().get();){
            list = resp.getColumns();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw SqlExceptionUtils.forCancellation(e);
        }
        catch (Exception e) {
            throw SqlExceptionUtils.handle(e);
        }
        return list;
    }

    final FakeTransaction getTransaction() {
        return this.fakeTransaction.get();
    }

    public ClickHouseConnectionImpl(String url) throws SQLException {
        this(url, new Properties());
    }

    public ClickHouseConnectionImpl(String url, Properties properties) throws SQLException {
        this(ClickHouseJdbcUrlParser.parse(url, properties));
    }

    public ClickHouseConnectionImpl(ClickHouseJdbcUrlParser.ConnectionInfo connInfo) throws SQLException {
        this.jdbcConf = connInfo.getJdbcConfig();
        this.autoCommit = !this.jdbcConf.isJdbcCompliant() || this.jdbcConf.isAutoCommit();
        this.uri = connInfo.getUri();
        log.debug((Object)"Creating a new connection to %s", connInfo.getUri());
        ClickHouseNode node = connInfo.getServer();
        log.debug((Object)"Target node: %s", node);
        this.jvmTimeZone = TimeZone.getDefault();
        this.client = ClickHouseClient.builder().options(ClickHouseDriver.toClientOptions(connInfo.getProperties())).nodeSelector(ClickHouseNodeSelector.of(node.getProtocol(), new ClickHouseProtocol[0])).build();
        this.clientRequest = this.client.connect(node);
        ClickHouseConfig config = this.clientRequest.getConfig();
        String currentUser = null;
        TimeZone timeZone = null;
        ClickHouseVersion version = null;
        if (config.hasServerInfo()) {
            timeZone = config.getServerTimeZone();
            version = config.getServerVersion();
            this.initialReadOnly = this.jdbcConf.isCreateDbIfNotExist() ? ClickHouseConnectionImpl.getServerInfo(node, this.clientRequest, true).getValue(3).asInteger() : ((Integer)this.clientRequest.getSettings().getOrDefault("readonly", 0)).intValue();
        } else {
            ClickHouseRecord r = ClickHouseConnectionImpl.getServerInfo(node, this.clientRequest, this.jdbcConf.isCreateDbIfNotExist());
            currentUser = r.getValue(0).asString();
            String tz = r.getValue(1).asString();
            String ver = r.getValue(2).asString();
            version = ClickHouseVersion.of(ver);
            if (version.check("(,20.7)")) {
                throw SqlExceptionUtils.unsupportedError("Sorry this driver only supports ClickHouse server 20.7 or above");
            }
            if (ClickHouseChecker.isNullOrBlank(tz)) {
                tz = "UTC";
            }
            timeZone = "UTC".equals(tz) ? ClickHouseValues.UTC_TIMEZONE : TimeZone.getTimeZone(tz);
            this.initialReadOnly = r.getValue(3).asInteger();
            ((ClickHouseRequest)this.clientRequest.option(ClickHouseClientOption.SERVER_TIME_ZONE, (Serializable)((Object)tz))).option(ClickHouseClientOption.SERVER_VERSION, (Serializable)((Object)ver));
        }
        this.autoCommit = true;
        this.closed = false;
        this.database = config.getDatabase();
        this.clientRequest.use(this.database);
        this.readOnly = this.initialReadOnly != 0;
        this.networkTimeout = 0;
        this.rsHoldability = 1;
        this.txIsolation = this.jdbcConf.isJdbcCompliant() ? 2 : 0;
        this.user = currentUser != null ? currentUser : node.getCredentials(config).getUserName();
        this.serverTimeZone = timeZone;
        if (config.isUseServerTimeZone()) {
            this.clientTimeZone = Optional.empty();
            this.defaultCalendar = new GregorianCalendar();
        } else {
            this.clientTimeZone = Optional.of(config.getUseTimeZone());
            this.defaultCalendar = new GregorianCalendar(this.clientTimeZone.get());
        }
        this.serverVersion = version;
        this.typeMap = new HashMap(this.jdbcConf.getTypeMap());
        this.fakeTransaction = new AtomicReference();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureOpen();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureOpen();
        if (this.autoCommit == autoCommit) {
            return;
        }
        this.ensureTransactionSupport();
        this.autoCommit = autoCommit;
        if (this.autoCommit) {
            FakeTransaction tx = this.fakeTransaction.getAndSet(null);
            if (tx != null) {
                tx.logTransactionDetails(log, "committed");
                tx.clear();
            }
        } else if (!this.fakeTransaction.compareAndSet(null, new FakeTransaction())) {
            log.warn((Object)"[JDBC Compliant Mode] not able to start a new transaction, reuse the exist one", new Object[0]);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureOpen();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot commit in auto-commit mode");
        }
        this.ensureTransactionSupport();
        FakeTransaction tx = this.fakeTransaction.getAndSet(new FakeTransaction());
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        tx.logTransactionDetails(log, "committed");
        tx.clear();
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot rollback in auto-commit mode");
        }
        this.ensureTransactionSupport();
        FakeTransaction tx = this.fakeTransaction.getAndSet(new FakeTransaction());
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        tx.logTransactionDetails(log, "rolled back");
        tx.clear();
    }

    @Override
    public void close() throws SQLException {
        try {
            this.client.close();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to close connection due to %s", e.getMessage());
            throw SqlExceptionUtils.handle(e);
        }
        finally {
            this.closed = true;
        }
        FakeTransaction tx = this.fakeTransaction.getAndSet(null);
        if (tx != null) {
            tx.logTransactionDetails(log, "committed");
            tx.clear();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ClickHouseDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureOpen();
        if (this.initialReadOnly != 0) {
            if (!readOnly) {
                throw SqlExceptionUtils.clientError("Cannot change the setting on a read-only connection");
            }
        } else {
            if (readOnly) {
                this.clientRequest.set("readonly", Integer.valueOf(2));
            } else {
                this.clientRequest.removeSetting("readonly");
            }
            this.readOnly = readOnly;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpen();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureOpen();
        log.warn((Object)"ClickHouse does not support catalog, please use setSchema instead", new Object[0]);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureOpen();
        if (level != 1 && level != 2 && level != 4 && level != 8) {
            throw new SQLException("Invalid transaction isolation level: " + level);
        }
        this.txIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureOpen();
        return this.txIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureOpen();
        return new HashMap(this.typeMap);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureOpen();
        if (map != null) {
            this.typeMap.putAll(map);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureOpen();
        if (holdability != 2 && holdability != 1) {
            throw new SQLException("Invalid holdability: " + holdability);
        }
        this.rsHoldability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureOpen();
        return this.rsHoldability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot set savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("setSavepoint not implemented");
        }
        FakeTransaction tx = this.fakeTransaction.updateAndGet(current -> current != null ? current : new FakeTransaction());
        return tx.newSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot rollback to savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("rollback not implemented");
        }
        if (!(savepoint instanceof FakeTransaction.FakeSavepoint)) {
            throw SqlExceptionUtils.clientError("Unsupported type of savepoint: " + savepoint);
        }
        FakeTransaction tx = this.fakeTransaction.get();
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        FakeTransaction.FakeSavepoint s = (FakeTransaction.FakeSavepoint)savepoint;
        tx.logSavepointDetails(log, s, "rolled back");
        tx.toSavepoint(s);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot release savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("rollback not implemented");
        }
        if (!(savepoint instanceof FakeTransaction.FakeSavepoint)) {
            throw SqlExceptionUtils.clientError("Unsupported type of savepoint: " + savepoint);
        }
        FakeTransaction tx = this.fakeTransaction.get();
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        FakeTransaction.FakeSavepoint s = (FakeTransaction.FakeSavepoint)savepoint;
        tx.logSavepointDetails(log, s, "released");
        tx.toSavepoint(s);
    }

    @Override
    public ClickHouseStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        return new ClickHouseStatementImpl(this, this.clientRequest.copy(), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JdbcParameterizedQuery preparedQuery;
        this.ensureOpen();
        ClickHouseConfig config = this.clientRequest.getConfig();
        ClickHouseSqlStatement[] stmts = this.parse(sql, config);
        if (stmts.length != 1) {
            throw SqlExceptionUtils.clientError("Prepared statement only supports one query but we got: " + stmts.length);
        }
        ClickHouseSqlStatement parsedStmt = stmts[0];
        try {
            preparedQuery = this.jdbcConf.useNamedParameter() ? ClickHouseParameterizedQuery.of(this.clientRequest.getConfig(), parsedStmt.getSQL()) : JdbcParameterizedQuery.of(config, parsedStmt.getSQL());
        }
        catch (RuntimeException e) {
            throw SqlExceptionUtils.clientError(e);
        }
        AbstractPreparedStatement ps = null;
        if (preparedQuery.hasParameter()) {
            if (parsedStmt.hasTempTable() || parsedStmt.hasInput()) {
                throw SqlExceptionUtils.clientError("External table, input function, and query parameter cannot be used together in PreparedStatement.");
            }
            if (parsedStmt.getStatementType() == StatementType.INSERT && !parsedStmt.containsKeyword("SELECT") && parsedStmt.hasValues() && (!parsedStmt.hasFormat() || this.clientRequest.getFormat().name().equals(parsedStmt.getFormat()))) {
                String query = parsedStmt.getSQL();
                int startIndex = parsedStmt.getPositions().get("ValuesStart");
                int endIndex = parsedStmt.getPositions().get("ValuesEnd");
                boolean useStream = true;
                for (int i = startIndex + 1; i < endIndex; ++i) {
                    char ch = query.charAt(i);
                    if (ch == '?' || ch == ',' || Character.isWhitespace(ch)) continue;
                    useStream = false;
                    break;
                }
                if (useStream) {
                    ps = new InputBasedPreparedStatement(this, (ClickHouseRequest<?>)this.clientRequest.write().query(query.substring(0, parsedStmt.getStartPosition("VALUES")), this.newQueryId()), this.getTableColumns(parsedStmt.getDatabase(), parsedStmt.getTable(), parsedStmt.getContentBetweenKeywords("ColumnsStart", "ColumnsEnd")), resultSetType, resultSetConcurrency, resultSetHoldability);
                }
            }
        } else if (parsedStmt.hasTempTable()) {
            ps = new TableBasedPreparedStatement(this, (ClickHouseRequest<?>)this.clientRequest.write().query(parsedStmt.getSQL(), this.newQueryId()), parsedStmt, resultSetType, resultSetConcurrency, resultSetHoldability);
        } else if (parsedStmt.getStatementType() == StatementType.INSERT) {
            if (!ClickHouseChecker.isNullOrBlank(parsedStmt.getInput())) {
                ps = new InputBasedPreparedStatement(this, (ClickHouseRequest<?>)this.clientRequest.write().query(parsedStmt.getSQL(), this.newQueryId()), ClickHouseColumn.parse(parsedStmt.getInput()), resultSetType, resultSetConcurrency, resultSetHoldability);
            } else if (!(parsedStmt.containsKeyword("SELECT") || parsedStmt.hasValues() || parsedStmt.hasFormat() && !this.clientRequest.getFormat().name().equals(parsedStmt.getFormat()))) {
                ps = new InputBasedPreparedStatement(this, (ClickHouseRequest<?>)this.clientRequest.write().query(parsedStmt.getSQL(), this.newQueryId()), this.getTableColumns(parsedStmt.getDatabase(), parsedStmt.getTable(), parsedStmt.getContentBetweenKeywords("ColumnsStart", "ColumnsEnd")), resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        }
        return ps != null ? ps : new SqlBasedPreparedStatement(this, (ClickHouseRequest<?>)this.clientRequest.copy().query(preparedQuery, this.newQueryId()), stmts[0], resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureOpen();
        return this.createClob();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw SqlExceptionUtils.clientError("Negative milliseconds is not allowed");
        }
        if (this.isClosed()) {
            return false;
        }
        return this.client.ping(this.clientRequest.getServer(), (int)TimeUnit.SECONDS.toMillis(timeout));
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.ensureOpen();
        }
        catch (SQLException e) {
            HashMap<String, ClientInfoStatus> failedProps = new HashMap<String, ClientInfoStatus>();
            failedProps.put("ApplicationName", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpHeaders", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpParameters", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException(e.getMessage(), failedProps);
        }
        if ("ApplicationName".equals(name)) {
            if (ClickHouseChecker.isNullOrBlank(value)) {
                this.clientRequest.removeOption(ClickHouseClientOption.CLIENT_NAME);
            } else {
                this.clientRequest.option(ClickHouseClientOption.CLIENT_NAME, (Serializable)((Object)value));
            }
        } else if ("CustomHttpHeaders".equals(name)) {
            if (ClickHouseChecker.isNullOrBlank(value)) {
                this.clientRequest.removeOption(ClickHouseHttpOption.CUSTOM_HEADERS);
            } else {
                this.clientRequest.option(ClickHouseHttpOption.CUSTOM_HEADERS, (Serializable)((Object)value));
            }
        } else if ("CustomHttpParameters".equals(name)) {
            if (ClickHouseChecker.isNullOrBlank(value)) {
                this.clientRequest.removeOption(ClickHouseHttpOption.CUSTOM_PARAMS);
            } else {
                this.clientRequest.option(ClickHouseHttpOption.CUSTOM_PARAMS, (Serializable)((Object)value));
            }
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.ensureOpen();
        }
        catch (SQLException e) {
            HashMap<String, ClientInfoStatus> failedProps = new HashMap<String, ClientInfoStatus>();
            failedProps.put("ApplicationName", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpHeaders", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpParameters", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException(e.getMessage(), failedProps);
        }
        if (properties != null) {
            String value = properties.getProperty("ApplicationName");
            if (ClickHouseChecker.isNullOrBlank(value)) {
                this.clientRequest.removeOption(ClickHouseClientOption.CLIENT_NAME);
            } else {
                this.clientRequest.option(ClickHouseClientOption.CLIENT_NAME, (Serializable)((Object)value));
            }
            value = properties.getProperty("CustomHttpHeaders");
            if (ClickHouseChecker.isNullOrBlank(value)) {
                this.clientRequest.removeOption(ClickHouseHttpOption.CUSTOM_HEADERS);
            } else {
                this.clientRequest.option(ClickHouseHttpOption.CUSTOM_HEADERS, (Serializable)((Object)value));
            }
            value = properties.getProperty("CustomHttpParameters");
            if (ClickHouseChecker.isNullOrBlank(value)) {
                this.clientRequest.removeOption(ClickHouseHttpOption.CUSTOM_PARAMS);
            } else {
                this.clientRequest.option(ClickHouseHttpOption.CUSTOM_PARAMS, (Serializable)((Object)value));
            }
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureOpen();
        ClickHouseConfig config = this.clientRequest.getConfig();
        String value = null;
        if ("ApplicationName".equals(name)) {
            value = config.getClientName();
        } else if ("CustomHttpHeaders".equals(name)) {
            value = (String)((Object)config.getOption(ClickHouseHttpOption.CUSTOM_HEADERS));
        } else if ("CustomHttpParameters".equals(name)) {
            value = (String)((Object)config.getOption(ClickHouseHttpOption.CUSTOM_PARAMS));
        }
        return value;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureOpen();
        ClickHouseConfig config = this.clientRequest.getConfig();
        Properties props = new Properties();
        props.setProperty("ApplicationName", config.getClientName());
        props.setProperty("CustomHttpHeaders", (String)((Object)config.getOption(ClickHouseHttpOption.CUSTOM_HEADERS)));
        props.setProperty("CustomHttpParameters", (String)((Object)config.getOption(ClickHouseHttpOption.CUSTOM_PARAMS)));
        return props;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureOpen();
        if (schema == null || schema.isEmpty()) {
            throw new SQLException("Non-empty schema name is required", "3F000");
        }
        if (!schema.equals(this.database)) {
            this.database = schema;
            this.clientRequest.use(schema);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureOpen();
        return this.getCurrentDatabase();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw SqlExceptionUtils.clientError("Non-null executor is required");
        }
        executor.execute(() -> {
            try {
                this.client.close();
            }
            finally {
                this.closed = true;
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.ensureOpen();
        if (executor == null) {
            throw SqlExceptionUtils.clientError("Non-null executor is required");
        }
        if (milliseconds < 0) {
            throw SqlExceptionUtils.clientError("Negative milliseconds is not allowed");
        }
        executor.execute(() -> {
            this.networkTimeout = milliseconds;
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureOpen();
        return this.networkTimeout;
    }

    @Override
    public ClickHouseConfig getConfig() {
        return this.clientRequest.getConfig();
    }

    @Override
    public String getCurrentDatabase() {
        return this.database;
    }

    @Override
    public String getCurrentUser() {
        return this.user;
    }

    @Override
    public Calendar getDefaultCalendar() {
        return this.defaultCalendar;
    }

    @Override
    public Optional<TimeZone> getEffectiveTimeZone() {
        return this.clientTimeZone;
    }

    @Override
    public TimeZone getJvmTimeZone() {
        return this.jvmTimeZone;
    }

    @Override
    public TimeZone getServerTimeZone() {
        return this.serverTimeZone;
    }

    @Override
    public ClickHouseVersion getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public JdbcConfig getJdbcConfig() {
        return this.jdbcConf;
    }

    @Override
    public String newQueryId() {
        FakeTransaction tx = this.fakeTransaction.get();
        return tx != null ? tx.newQuery(null) : UUID.randomUUID().toString();
    }

    @Override
    public ClickHouseSqlStatement[] parse(String sql, ClickHouseConfig config) {
        return ClickHouseSqlParser.parse(sql, config != null ? config : this.clientRequest.getConfig(), this.jdbcConf.isJdbcCompliant() ? JdbcParseHandler.INSTANCE : null);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == ClickHouseClient.class || iface == ClickHouseRequest.class || super.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == ClickHouseClient.class) {
            return iface.cast(this.client);
        }
        if (iface == ClickHouseRequest.class) {
            return iface.cast(this.clientRequest);
        }
        return super.unwrap(iface);
    }
}

