/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.http;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseSslContextProvider;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseSslMode;
import com.clickhouse.client.data.ClickHouseExternalTable;
import com.clickhouse.client.http.ClickHouseHttpConnection;
import com.clickhouse.client.http.ClickHouseHttpResponse;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class HttpUrlConnectionImpl
extends ClickHouseHttpConnection {
    private static final Logger log = LoggerFactory.getLogger(HttpUrlConnectionImpl.class);
    private static final byte[] HEADER_CONTENT_DISPOSITION = "Content-Disposition: form-data; name=\"".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HEADER_OCTET_STREAM = "Content-Type: application/octet-stream\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HEADER_BINARY_ENCODING = "Content-Transfer-Encoding: binary\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SUFFIX_QUERY = "query\"\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SUFFIX_FORMAT = "_format\"\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SUFFIX_STRUCTURE = "_structure\"\r\n\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SUFFIX_FILENAME = "\"; filename=\"".getBytes(StandardCharsets.US_ASCII);
    private final HttpURLConnection conn;

    private ClickHouseHttpResponse buildResponse() throws IOException {
        String displayName = this.getResponseHeader("X-ClickHouse-Server-Display-Name", this.server.getHost());
        String queryId = this.getResponseHeader("X-ClickHouse-Query-Id", "");
        String summary = this.getResponseHeader("X-ClickHouse-Summary", "{}");
        ClickHouseConfig c = this.config;
        ClickHouseFormat format = c.getFormat();
        TimeZone timeZone = c.getServerTimeZone();
        boolean hasQueryResult = false;
        if (!ClickHouseChecker.isNullOrEmpty(queryId)) {
            String value = this.getResponseHeader("X-ClickHouse-Format", "");
            if (!ClickHouseChecker.isNullOrEmpty(value)) {
                format = ClickHouseFormat.valueOf(value);
                hasQueryResult = true;
            }
            timeZone = !ClickHouseChecker.isNullOrEmpty(value = this.getResponseHeader("X-ClickHouse-Timezone", "")) ? TimeZone.getTimeZone(value) : timeZone;
        }
        return new ClickHouseHttpResponse(this, hasQueryResult ? ClickHouseClient.getAsyncResponseInputStream(c, this.conn.getInputStream(), null) : ClickHouseClient.getResponseInputStream(c, this.conn.getInputStream(), null), displayName, queryId, summary, format, timeZone);
    }

    private HttpURLConnection newConnection(String url, boolean post) throws IOException {
        HttpURLConnection newConn = (HttpURLConnection)new URL(url).openConnection();
        if (newConn instanceof HttpsURLConnection && this.config.isSsl()) {
            HttpsURLConnection secureConn = (HttpsURLConnection)newConn;
            SSLContext sslContext = ClickHouseSslContextProvider.getProvider().getSslContext(SSLContext.class, this.config).orElse(null);
            HostnameVerifier verifier = this.config.getSslMode() == ClickHouseSslMode.STRICT ? HttpsURLConnection.getDefaultHostnameVerifier() : (hostname, session) -> true;
            secureConn.setHostnameVerifier(verifier);
            secureConn.setSSLSocketFactory(sslContext.getSocketFactory());
        }
        if (post) {
            newConn.setInstanceFollowRedirects(true);
            newConn.setRequestMethod("POST");
        }
        newConn.setUseCaches(false);
        newConn.setAllowUserInteraction(false);
        newConn.setDoInput(true);
        newConn.setDoOutput(true);
        newConn.setConnectTimeout(this.config.getConnectionTimeout());
        newConn.setReadTimeout(this.config.getSocketTimeout());
        return newConn;
    }

    private String getResponseHeader(String header, String defaultValue) {
        String value = this.conn.getHeaderField(header);
        return value != null ? value : defaultValue;
    }

    private void setHeaders(HttpURLConnection conn, Map<String, String> headers) {
        if ((headers = this.mergeHeaders(headers)) == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
    }

    private void checkResponse(HttpURLConnection conn) throws IOException {
        if (conn.getResponseCode() != 200) {
            String errorMsg;
            String errorCode = conn.getHeaderField("X-ClickHouse-Exception-Code");
            String serverName = conn.getHeaderField("X-ClickHouse-Server-Display-Name");
            int bufferSize = (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue();
            ByteArrayOutputStream output = new ByteArrayOutputStream(bufferSize);
            ClickHouseInputStream.pipe(conn.getErrorStream(), (OutputStream)output, bufferSize);
            byte[] bytes = output.toByteArray();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)ClickHouseClient.getResponseInputStream(this.config, new ByteArrayInputStream(bytes), null), StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                while ((errorMsg = reader.readLine()) != null) {
                    builder.append(errorMsg).append('\n');
                }
                errorMsg = builder.toString();
            }
            catch (IOException e) {
                log.warn((Object)"Error while reading error message[code=%s] from server [%s]", errorCode, serverName, e);
                errorMsg = new String(bytes, StandardCharsets.UTF_8);
            }
            throw new IOException(errorMsg);
        }
    }

    protected HttpUrlConnectionImpl(ClickHouseNode server, ClickHouseRequest<?> request, ExecutorService executor) throws IOException {
        super(server, request);
        this.conn = this.newConnection(this.url, true);
    }

    @Override
    protected boolean isReusable() {
        return false;
    }

    @Override
    protected ClickHouseHttpResponse post(String sql, InputStream data, List<ClickHouseExternalTable> tables, Map<String, String> headers) throws IOException {
        boolean hasInput;
        Charset charset = StandardCharsets.US_ASCII;
        byte[] boundary = null;
        if (tables != null && !tables.isEmpty()) {
            String uuid = UUID.randomUUID().toString();
            this.conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=".concat(uuid));
            boundary = uuid.getBytes(charset);
        } else {
            this.conn.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        }
        this.setHeaders(this.conn, headers);
        ClickHouseConfig c = this.config;
        boolean bl = hasInput = data != null || boundary != null;
        if (hasInput) {
            this.conn.setChunkedStreamingMode(this.config.getRequestChunkSize());
        }
        try (ClickHouseOutputStream out = hasInput ? ClickHouseClient.getAsyncRequestOutputStream(this.config, this.conn.getOutputStream(), null) : ClickHouseClient.getRequestOutputStream(c, this.conn.getOutputStream(), null);){
            byte[] sqlBytes = sql.getBytes(StandardCharsets.UTF_8);
            if (boundary != null) {
                byte[] linePrefix = new byte[]{13, 10, 45, 45};
                byte[] lineSuffix = new byte[]{13, 10};
                out.writeBytes(linePrefix);
                out.writeBytes(boundary);
                out.writeBytes(lineSuffix);
                out.writeBytes(HEADER_CONTENT_DISPOSITION);
                out.writeBytes(SUFFIX_QUERY);
                out.writeBytes(sqlBytes);
                for (ClickHouseExternalTable t : tables) {
                    byte[] tableName = t.getName().getBytes(StandardCharsets.UTF_8);
                    for (int i = 0; i < 3; ++i) {
                        out.writeBytes(linePrefix);
                        out.writeBytes(boundary);
                        out.writeBytes(lineSuffix);
                        out.writeBytes(HEADER_CONTENT_DISPOSITION);
                        out.writeBytes(tableName);
                        if (i == 0) {
                            out.writeBytes(SUFFIX_FORMAT);
                            out.writeBytes(t.getFormat().name().getBytes(charset));
                            continue;
                        }
                        if (i == 1) {
                            out.writeBytes(SUFFIX_STRUCTURE);
                            out.writeBytes(t.getStructure().getBytes(StandardCharsets.UTF_8));
                            continue;
                        }
                        out.writeBytes(SUFFIX_FILENAME);
                        out.writeBytes(tableName);
                        out.writeBytes(new byte[]{34, 13, 10});
                        break;
                    }
                    out.writeBytes(HEADER_OCTET_STREAM);
                    out.writeBytes(HEADER_BINARY_ENCODING);
                    ClickHouseInputStream.pipe(t.getContent(), (OutputStream)out, c.getWriteBufferSize());
                }
                out.writeBytes(linePrefix);
                out.writeBytes(boundary);
                out.writeBytes(new byte[]{45, 45});
                out.writeBytes(lineSuffix);
            } else {
                out.writeBytes(sqlBytes);
                if (data != null && data.available() > 0) {
                    if (sqlBytes[sqlBytes.length - 1] != 10) {
                        out.write(10);
                    }
                    ClickHouseInputStream.pipe(data, (OutputStream)out, c.getWriteBufferSize());
                }
            }
        }
        this.checkResponse(this.conn);
        return this.buildResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ping(int timeout) {
        block11: {
            String response = (String)((Object)this.config.getOption(ClickHouseHttpOption.DEFAULT_RESPONSE));
            HttpURLConnection c = null;
            try {
                boolean bl;
                c = this.newConnection(this.getBaseUrl() + "ping", false);
                c.setConnectTimeout(timeout);
                c.setReadTimeout(timeout);
                this.checkResponse(c);
                int size = 12;
                ByteArrayOutputStream out = new ByteArrayOutputStream(size);
                try {
                    ClickHouseInputStream.pipe(c.getInputStream(), (OutputStream)out, size);
                    c.disconnect();
                    c = null;
                    bl = response.equals(new String(out.toByteArray(), StandardCharsets.UTF_8));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.debug((Object)"Failed to ping server: ", e.getMessage());
                        break block11;
                    }
                }
                out.close();
                return bl;
            }
            finally {
                if (c != null) {
                    c.disconnect();
                }
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.conn.disconnect();
    }
}

