/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.io.kafka.KafkaSourceDescriptor;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaCommitOffset<K, V>
extends PTransform<PCollection<KV<KafkaSourceDescriptor, KafkaRecord<K, V>>>, PCollection<Void>> {
    private final KafkaIO.ReadSourceDescriptors<K, V> readSourceDescriptors;

    KafkaCommitOffset(KafkaIO.ReadSourceDescriptors<K, V> readSourceDescriptors) {
        this.readSourceDescriptors = readSourceDescriptors;
    }

    public PCollection<Void> expand(PCollection<KV<KafkaSourceDescriptor, KafkaRecord<K, V>>> input) {
        try {
            return ((PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<KV<KafkaSourceDescriptor, Long>>(){}).via((SerializableFunction & Serializable)element -> KV.of((Object)((KafkaSourceDescriptor)element.getKey()), (Object)((KafkaRecord)element.getValue()).getOffset())))).setCoder((Coder)KvCoder.of((Coder)input.getPipeline().getSchemaRegistry().getSchemaCoder(KafkaSourceDescriptor.class), (Coder)VarLongCoder.of())).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)5L))))).apply((PTransform)Max.longsPerKey())).apply((PTransform)ParDo.of((DoFn)new CommitOffsetDoFn(this.readSourceDescriptors)))).setCoder((Coder)VoidCoder.of());
        }
        catch (NoSuchSchemaException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    static class CommitOffsetDoFn
    extends DoFn<KV<KafkaSourceDescriptor, Long>, Void> {
        private static final Logger LOG = LoggerFactory.getLogger(CommitOffsetDoFn.class);
        private final Map<String, Object> consumerConfig;
        private final SerializableFunction<Map<String, Object>, Consumer<byte[], byte[]>> consumerFactoryFn;

        CommitOffsetDoFn(KafkaIO.ReadSourceDescriptors readSourceDescriptors) {
            this.consumerConfig = readSourceDescriptors.getConsumerConfig();
            this.consumerFactoryFn = readSourceDescriptors.getConsumerFactoryFn();
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element KV<KafkaSourceDescriptor, Long> element) {
            Map<String, Object> updatedConsumerConfig = this.overrideBootstrapServersConfig(this.consumerConfig, (KafkaSourceDescriptor)element.getKey());
            try (Consumer consumer = (Consumer)this.consumerFactoryFn.apply(updatedConsumerConfig);){
                try {
                    consumer.commitSync(Collections.singletonMap(((KafkaSourceDescriptor)element.getKey()).getTopicPartition(), new OffsetAndMetadata((Long)element.getValue() + 1L)));
                }
                catch (Exception e) {
                    LOG.warn("Getting exception when committing offset: {}", (Object)e.getMessage());
                }
            }
        }

        private Map<String, Object> overrideBootstrapServersConfig(Map<String, Object> currentConfig, KafkaSourceDescriptor description) {
            Preconditions.checkState((currentConfig.containsKey("bootstrap.servers") || description.getBootStrapServers() != null ? 1 : 0) != 0);
            HashMap<String, Object> config = new HashMap<String, Object>(currentConfig);
            if (description.getBootStrapServers() != null && description.getBootStrapServers().size() > 0) {
                config.put("bootstrap.servers", String.join((CharSequence)",", description.getBootStrapServers()));
            }
            return config;
        }
    }
}

