/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.javafilter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.javafilter.JavaFilterMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JavaFilterDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = JavaFilterMeta.class;
    private Text wTransformName;
    private CCombo wTrueTo;
    private CCombo wFalseTo;
    private StyledTextComp wCondition;
    private final JavaFilterMeta input;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;

    public JavaFilterDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (JavaFilterMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JavaFilterDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Group wSettingsGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)wSettingsGroup);
        wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"JavaFIlterDialog.Settings.Label", (String[])new String[0]));
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 10;
        settingsLayout.marginHeight = 10;
        wSettingsGroup.setLayout((Layout)settingsLayout);
        Label wlTrueTo = new Label((Composite)wSettingsGroup, 131072);
        wlTrueTo.setText(BaseMessages.getString(PKG, (String)"JavaFilterDialog.SendTrueTo.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTrueTo);
        FormData fdlTrueTo = new FormData();
        fdlTrueTo.left = new FormAttachment(0, 0);
        fdlTrueTo.right = new FormAttachment(middle, -margin);
        fdlTrueTo.top = new FormAttachment((Control)this.wTransformName, margin);
        wlTrueTo.setLayoutData((Object)fdlTrueTo);
        this.wTrueTo = new CCombo((Composite)wSettingsGroup, 2048);
        this.props.setLook((Control)this.wTrueTo);
        TransformMeta transforminfo = this.pipelineMeta.findTransform(this.transformName);
        if (transforminfo != null) {
            List nextTransforms = this.pipelineMeta.findNextTransforms(transforminfo);
            for (TransformMeta transformMeta : nextTransforms) {
                this.wTrueTo.add(transformMeta.getName());
            }
        }
        this.wTrueTo.addModifyListener(lsMod);
        FormData fdTrueTo = new FormData();
        fdTrueTo.left = new FormAttachment(middle, 0);
        fdTrueTo.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTrueTo.right = new FormAttachment(100, 0);
        this.wTrueTo.setLayoutData((Object)fdTrueTo);
        Label wlFalseTo = new Label((Composite)wSettingsGroup, 131072);
        wlFalseTo.setText(BaseMessages.getString(PKG, (String)"JavaFilterDialog.SendFalseTo.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFalseTo);
        FormData fdlFalseTo = new FormData();
        fdlFalseTo.left = new FormAttachment(0, 0);
        fdlFalseTo.right = new FormAttachment(middle, -margin);
        fdlFalseTo.top = new FormAttachment((Control)this.wTrueTo, margin);
        wlFalseTo.setLayoutData((Object)fdlFalseTo);
        this.wFalseTo = new CCombo((Composite)wSettingsGroup, 2048);
        this.props.setLook((Control)this.wFalseTo);
        transforminfo = this.pipelineMeta.findTransform(this.transformName);
        if (transforminfo != null) {
            List nextTransforms = this.pipelineMeta.findNextTransforms(transforminfo);
            for (TransformMeta transformMeta : nextTransforms) {
                this.wFalseTo.add(transformMeta.getName());
            }
        }
        this.wFalseTo.addModifyListener(lsMod);
        FormData fdFalseFrom = new FormData();
        fdFalseFrom.left = new FormAttachment(middle, 0);
        fdFalseFrom.top = new FormAttachment((Control)this.wTrueTo, margin);
        fdFalseFrom.right = new FormAttachment(100, 0);
        this.wFalseTo.setLayoutData((Object)fdFalseFrom);
        Label wlCondition = new Label((Composite)wSettingsGroup, 131072);
        wlCondition.setText(BaseMessages.getString(PKG, (String)"JavaFIlterDialog.Condition.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCondition);
        FormData fdlCondition = new FormData();
        fdlCondition.top = new FormAttachment((Control)this.wFalseTo, margin);
        fdlCondition.left = new FormAttachment(0, 0);
        fdlCondition.right = new FormAttachment(middle, -margin);
        wlCondition.setLayoutData((Object)fdlCondition);
        this.wCondition = new StyledTextComp(this.variables, (Composite)wSettingsGroup, 19202);
        this.props.setLook((Control)this.wCondition);
        this.wCondition.addModifyListener(lsMod);
        FormData fdCondition = new FormData();
        fdCondition.top = new FormAttachment((Control)this.wFalseTo, margin);
        fdCondition.left = new FormAttachment(middle, 0);
        fdCondition.right = new FormAttachment(100, 0);
        fdCondition.bottom = new FormAttachment(100, -margin);
        this.wCondition.setLayoutData((Object)fdCondition);
        FormData fdSettingsGroup = new FormData();
        fdSettingsGroup.left = new FormAttachment(0, margin);
        fdSettingsGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSettingsGroup.right = new FormAttachment(100, -margin);
        fdSettingsGroup.bottom = new FormAttachment((Control)this.wOk, -margin);
        wSettingsGroup.setLayoutData((Object)fdSettingsGroup);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        this.shell.getDisplay().syncExec(() -> {
            Set keySet = fields.keySet();
            ArrayList entries = new ArrayList(keySet);
            String[] fieldNames = entries.toArray(new String[entries.size()]);
            Const.sortStrings((String[])fieldNames);
            this.colinf[5].setComboValues(fieldNames);
        });
    }

    public void getData() {
        this.wTrueTo.setText(Const.NVL((String)this.input.getTrueTransform(), (String)""));
        this.wFalseTo.setText(Const.NVL((String)this.input.getFalseTransform(), (String)""));
        this.wCondition.setText(Const.NVL((String)this.input.getCondition(), (String)""));
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setCondition(this.wCondition.getText());
        this.input.setTrueTransform(Const.NVL((String)this.wTrueTo.getText(), null));
        this.input.setFalseTransform(Const.NVL((String)this.wFalseTo.getText(), null));
        this.dispose();
    }
}

