/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hop.core.IAttributes;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.IExtensionData;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.attributes.AttributesUtil;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.DefaultLogLevel;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.xml.XmlMetadataUtil;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

public abstract class ActionBase
implements IAction,
Cloneable,
ILoggingObject,
IAttributes,
IExtensionData,
ICheckResultSource,
IResourceHolder {
    private String name;
    private String description;
    private String pluginId;
    private boolean changed;
    private IVariables variables = new Variables();
    protected Map<String, String> entryTransformSetVariablesMap = new ConcurrentHashMap<String, String>();
    protected IWorkflowEngine<WorkflowMeta> parentWorkflow;
    protected ILogChannel log;
    private LogLevel logLevel = DefaultLogLevel.getLogLevel();
    protected String containerObjectId;
    private IHopMetadataProvider metadataProvider;
    protected Map<String, Map<String, String>> attributesMap;
    protected Map<String, Object> extensionDataMap;
    protected WorkflowMeta parentWorkflowMeta;

    protected ActionBase() {
        this.name = null;
        this.description = null;
        this.log = new LogChannel((Object)this);
        this.setVariable("Internal.Action.ID", this.log.getLogChannelId());
        this.attributesMap = new HashMap<String, Map<String, String>>();
        this.extensionDataMap = new HashMap<String, Object>();
    }

    protected ActionBase(String name, String description) {
        this.setName(name);
        this.setDescription(description);
        this.log = new LogChannel((Object)this);
        this.setVariable("Internal.Action.ID", this.log.getLogChannelId());
        this.attributesMap = new HashMap<String, Map<String, String>>();
        this.extensionDataMap = new HashMap<String, Object>();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ActionBase)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.name.equalsIgnoreCase(((ActionBase)obj).getName());
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }

    @Override
    public void clear() {
        this.name = null;
        this.description = null;
        this.changed = false;
    }

    public String getTypeDesc() {
        IPlugin plugin = PluginRegistry.getInstance().findPluginWithId(ActionPluginType.class, this.pluginId);
        return plugin.getDescription();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTypeId() {
        return "ACTION";
    }

    @Override
    public void setChanged() {
        this.setChanged(true);
    }

    @Override
    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public boolean isStart() {
        return false;
    }

    @Override
    public boolean isWorkflow() {
        return "WORKFLOW".equals(this.pluginId);
    }

    @Override
    public boolean isPipeline() {
        return "PIPELINE".equals(this.pluginId);
    }

    @Override
    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.getName()));
        xml.append("      ").append(XmlHandler.addTagValue((String)"description", (String)this.getDescription()));
        xml.append("      ").append(XmlHandler.addTagValue((String)"type", (String)this.pluginId));
        xml.append(AttributesUtil.getAttributesXml(this.attributesMap));
        try {
            xml.append(XmlMetadataUtil.serializeObjectToXml((Object)this));
        }
        catch (HopException e) {
            throw new RuntimeException("Error serializing action metadata to XML", e);
        }
        return xml.toString();
    }

    public void loadXml(Node node) throws HopXmlException {
        try {
            this.setName(XmlHandler.getTagValue((Node)node, (String)"name"));
            this.setDescription(XmlHandler.getTagValue((Node)node, (String)"description"));
            this.attributesMap = AttributesUtil.loadAttributes(XmlHandler.getSubNode((Node)node, (String)"attributes"));
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load base info for action", (Throwable)e);
        }
    }

    @Override
    public void loadXml(Node entryNode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        this.loadXml(entryNode);
        XmlMetadataUtil.deSerializeFromXml((Node)entryNode, this.getClass(), (Object)this, (IHopMetadataProvider)metadataProvider);
    }

    @Override
    public Object clone() {
        ActionBase je;
        try {
            je = (ActionBase)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
        return je;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean resetErrorsBeforeExecution() {
        return true;
    }

    @Override
    public boolean isEvaluation() {
        return false;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public List<SqlStatement> getSqlStatements(IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return new ArrayList<SqlStatement>();
    }

    @Override
    public String getFilename() {
        return null;
    }

    @Override
    public String getRealFilename() {
        return null;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[0];
    }

    public void copyFrom(IVariables variables) {
        this.variables.copyFrom(variables);
    }

    public String resolve(String aString) {
        return this.variables.resolve(aString);
    }

    public String[] resolve(String[] aString) {
        return this.variables.resolve(aString);
    }

    public String resolve(String aString, IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        return this.variables.resolve(aString, rowMeta, rowData);
    }

    public IVariables getParentVariables() {
        if (this.parentWorkflow != null) {
            return this.parentWorkflow;
        }
        return this.variables.getParentVariables();
    }

    public void setParentVariables(IVariables parent) {
        this.variables.setParentVariables(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getVariableBoolean(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty((CharSequence)variableName) && !Utils.isEmpty((CharSequence)(value = this.resolve(variableName)))) {
            return ValueMetaString.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeFrom(IVariables parent) {
        this.variables.initializeFrom(parent);
    }

    public String[] getVariableNames() {
        return this.variables.getVariableNames();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareWith(IVariables variables) {
        this.variables = variables;
    }

    public void setVariables(Map<String, String> map) {
        this.variables.setVariables(map);
    }

    @Override
    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
    }

    @Override
    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        return new ArrayList<ResourceReference>(5);
    }

    @Override
    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming namingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        return null;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public String getDialogClassName() {
        return null;
    }

    protected IVariables getVariables() {
        return this.variables;
    }

    @Override
    public void setParentWorkflow(IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        this.parentWorkflow = parentWorkflow;
        this.logLevel = parentWorkflow.getLogLevel();
        this.log = new LogChannel((Object)this, parentWorkflow);
        this.setVariable("Internal.Action.ID", this.log.getLogChannelId());
        this.containerObjectId = parentWorkflow.getContainerId();
    }

    @Override
    public IWorkflowEngine<WorkflowMeta> getParentWorkflow() {
        return this.parentWorkflow;
    }

    public boolean isBasic() {
        return this.log.isBasic();
    }

    public boolean isDetailed() {
        return this.log.isDetailed();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public boolean isRowlevel() {
        return this.log.isRowLevel();
    }

    public void logMinimal(String message) {
        this.log.logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.log.logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.log.logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.log.logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.log.logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.log.logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.log.logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.log.logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.log.logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.log.logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.log.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.log.logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.log.logError(message, arguments);
    }

    @Override
    public ILogChannel getLogChannel() {
        return this.log;
    }

    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    public String getObjectName() {
        return this.getName();
    }

    public String getObjectCopy() {
        return null;
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.ACTION;
    }

    public ILoggingObject getParent() {
        return this.parentWorkflow;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        this.log.setLogLevel(logLevel);
    }

    public String getContainerId() {
        return this.containerObjectId;
    }

    public void setContainerObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    public Date getRegistrationDate() {
        return null;
    }

    @Override
    public String[] getReferencedObjectDescriptions() {
        return null;
    }

    @Override
    public boolean[] isReferencedObjectEnabled() {
        return null;
    }

    @Override
    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return null;
    }

    public boolean isGatheringMetrics() {
        return this.log != null && this.log.isGatheringMetrics();
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        if (this.log != null) {
            this.log.setGatheringMetrics(gatheringMetrics);
        }
    }

    public boolean isForcingSeparateLogging() {
        return this.log != null && this.log.isForcingSeparateLogging();
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        if (this.log != null) {
            this.log.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public void setAttributesMap(Map<String, Map<String, String>> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public Map<String, Map<String, String>> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttribute(String groupName, String key, String value) {
        Map<String, String> attributes = this.getAttributes(groupName);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            this.attributesMap.put(groupName, attributes);
        }
        attributes.put(key, value);
    }

    public void setAttributes(String groupName, Map<String, String> attributes) {
        this.attributesMap.put(groupName, attributes);
    }

    public Map<String, String> getAttributes(String groupName) {
        return this.attributesMap.get(groupName);
    }

    public String getAttribute(String groupName, String key) {
        Map<String, String> attributes = this.attributesMap.get(groupName);
        if (attributes == null) {
            return null;
        }
        return attributes.get(key);
    }

    public Map<String, Object> getExtensionDataMap() {
        return this.extensionDataMap;
    }

    @Override
    public WorkflowMeta getParentWorkflowMeta() {
        return this.parentWorkflowMeta;
    }

    @Override
    public void setParentWorkflowMeta(WorkflowMeta parentWorkflowMeta) {
        this.parentWorkflowMeta = parentWorkflowMeta;
    }

    protected Map<String, String> getEntryTransformSetVariablesMap() {
        return this.entryTransformSetVariablesMap;
    }

    public void setEntryTransformSetVariable(String variableName, String variableValue) {
        if (variableName != null) {
            if (variableValue != null) {
                this.entryTransformSetVariablesMap.put(variableName, variableValue);
            } else {
                this.entryTransformSetVariablesMap.put(variableName, "");
            }
        }
    }

    public String getEntryTransformSetVariable(String variableName) {
        return this.entryTransformSetVariablesMap.get(variableName);
    }
}

