/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;

@HopMetadata(key="pipeline-run-configuration", name="Pipeline Run Configuration", description="Describes how and with which engine a pipeline is to be executed", image="ui/images/pipeline_run_config.svg", documentationUrl="/metadata-types/pipeline-run-config.html")
public class PipelineRunConfiguration
extends HopMetadataBase
implements Cloneable,
IHopMetadata {
    public static final String GUI_PLUGIN_ELEMENT_PARENT_ID = "PipelineRunConfiguration-PluginSpecific-Options";
    @HopMetadataProperty
    private String description;
    @HopMetadataProperty
    private String executionInfoLocationName;
    @HopMetadataProperty
    private List<DescribedVariable> configurationVariables;
    @HopMetadataProperty
    private IPipelineEngineRunConfiguration engineRunConfiguration;
    @HopMetadataProperty(key="dataProfile")
    protected String executionDataProfileName;

    public PipelineRunConfiguration() {
        this.configurationVariables = new ArrayList<DescribedVariable>();
    }

    public PipelineRunConfiguration(String name, String description, String executionInfoLocationName, List<DescribedVariable> configurationVariables, IPipelineEngineRunConfiguration engineRunConfiguration, String executionDataProfileName) {
        this.name = name;
        this.description = description;
        this.executionInfoLocationName = executionInfoLocationName;
        this.configurationVariables = configurationVariables;
        this.engineRunConfiguration = engineRunConfiguration;
        this.executionDataProfileName = executionDataProfileName;
    }

    public PipelineRunConfiguration(PipelineRunConfiguration runConfiguration) {
        this();
        this.name = runConfiguration.name;
        this.description = runConfiguration.description;
        this.executionInfoLocationName = runConfiguration.executionInfoLocationName;
        this.configurationVariables.addAll(runConfiguration.getConfigurationVariables());
        if (runConfiguration.getEngineRunConfiguration() != null) {
            this.engineRunConfiguration = runConfiguration.engineRunConfiguration.clone();
        }
        this.executionDataProfileName = runConfiguration.executionDataProfileName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExecutionInfoLocationName() {
        return this.executionInfoLocationName;
    }

    public void setExecutionInfoLocationName(String executionInfoLocationName) {
        this.executionInfoLocationName = executionInfoLocationName;
    }

    public List<DescribedVariable> getConfigurationVariables() {
        return this.configurationVariables;
    }

    public void setConfigurationVariables(List<DescribedVariable> configurationVariables) {
        this.configurationVariables = configurationVariables;
    }

    public IPipelineEngineRunConfiguration getEngineRunConfiguration() {
        return this.engineRunConfiguration;
    }

    public void setEngineRunConfiguration(IPipelineEngineRunConfiguration engineRunConfiguration) {
        this.engineRunConfiguration = engineRunConfiguration;
    }

    public String getExecutionDataProfileName() {
        return this.executionDataProfileName;
    }

    public void setExecutionDataProfileName(String executionDataProfileName) {
        this.executionDataProfileName = executionDataProfileName;
    }

    public void applyToVariables(IVariables variables) {
        for (DescribedVariable vvd : this.configurationVariables) {
            if (!StringUtils.isNotEmpty((String)vvd.getName())) continue;
            variables.setVariable(vvd.getName(), variables.resolve(vvd.getValue()));
        }
    }
}

