/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.nullif;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.nullif.NullIf;
import org.apache.hop.pipeline.transforms.nullif.NullIfData;
import org.w3c.dom.Node;

@Transform(id="NullIf", image="NullIf.svg", name="i18n::NullIf.Name", description="i18n::NullIf.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", keywords={"i18n::NullIfMeta.keyword"}, documentationUrl="/pipeline/transforms/nullif.html")
@InjectionSupported(localizationPrefix="Injection.NullIf.", groups={"FIELDS"})
public class NullIfMeta
extends BaseTransformMeta<NullIf, NullIfData> {
    private static final Class<?> PKG = NullIfMeta.class;
    @InjectionDeep
    private Field[] fields;

    public Field[] getFields() {
        return this.fields;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int count) {
        this.fields = new Field[count];
        for (int i = 0; i < count; ++i) {
            this.fields[i] = new Field();
        }
    }

    public Object clone() {
        NullIfMeta retval = (NullIfMeta)((Object)super.clone());
        int count = this.fields.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.getFields()[i] = this.fields[i].clone();
        }
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node fieldNodes = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int count = XmlHandler.countNodes((Node)fieldNodes, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fieldNodes, (String)"field", (int)i);
                this.fields[i].setFieldName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.fields[i].setFieldValue(XmlHandler.getTagValue((Node)fnode, (String)"value"));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"NullIfMeta.Exception.UnableToReadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fields[i].setFieldName("field" + i);
            this.fields[i].setFieldValue("");
        }
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (r == null) {
            r = new RowMeta();
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fields.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.fields[i].getFieldName()));
            retval.append("        " + XmlHandler.addTagValue((String)"value", (String)this.fields[i].getFieldValue()));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.NoReceivingFieldsError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.TransformReceivingFieldsOK", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.TransformRecevingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"NullIfMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public static class Field
    implements Cloneable {
        @Injection(name="FIELDNAME", group="FIELDS")
        private String fieldName;
        @Injection(name="FIELDVALUE", group="FIELDS")
        private String fieldValue;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldValue() {
            return this.fieldValue;
        }

        public void setFieldValue(String fieldValue) {
            Boolean isEmptyAndNullDiffer = ValueMetaBase.convertStringToBoolean((String)Const.NVL((String)System.getProperty("HOP_EMPTY_STRING_DIFFERS_FROM_NULL", "N"), (String)"N"));
            this.fieldValue = fieldValue == null && isEmptyAndNullDiffer != false ? "" : fieldValue;
        }

        public Field clone() {
            try {
                return (Field)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

