/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p43p2.io.netty.handler.codec.base64;

import java.util.List;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.buffer.ByteBuf;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.channel.ChannelHandler;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.channel.ChannelHandlerContext;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.handler.codec.MessageToMessageEncoder;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.handler.codec.base64.Base64;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.handler.codec.base64.Base64Dialect;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        this.dialect = ObjectUtil.checkNotNull(dialect, "dialect");
        this.breakLines = breakLines;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.encode(msg, msg.readerIndex(), msg.readableBytes(), this.breakLines, this.dialect));
    }
}

