/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsonoutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutput;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutputData;

public abstract class BaseFileOutputMeta<Main extends JsonOutput, Data extends JsonOutputData>
extends BaseTransformMeta<Main, Data> {
    @Injection(name="INC_TRANSFORMNR_IN_FILENAME")
    protected boolean transformNrInFilename;
    @Injection(name="INC_PARTNR_IN_FILENAME")
    protected boolean partNrInFilename;
    @Injection(name="INC_DATE_IN_FILENAME")
    protected boolean dateInFilename;
    @Injection(name="INC_TIME_IN_FILENAME")
    protected boolean timeInFilename;
    @Injection(name="EXTENSION")
    protected String extension;
    @Injection(name="FILENAME")
    protected String fileName;
    @Injection(name="RUN_AS_COMMAND")
    private boolean fileAsCommand;
    @Injection(name="SPECIFY_DATE_FORMAT")
    private boolean specifyingFormat;
    @Injection(name="DATE_FORMAT")
    private String dateTimeFormat;
    @Injection(name="COMPRESSION")
    private String fileCompression;

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public abstract int getSplitEvery();

    public int getSplitEvery(IVariables variables) {
        return this.getSplitEvery();
    }

    public abstract void setSplitEvery(int var1);

    public boolean isFileAsCommand() {
        return this.fileAsCommand;
    }

    public void setFileAsCommand(boolean fileAsCommand) {
        this.fileAsCommand = fileAsCommand;
    }

    public boolean isSpecifyingFormat() {
        return this.specifyingFormat;
    }

    public void setSpecifyingFormat(boolean specifyingFormat) {
        this.specifyingFormat = specifyingFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public boolean isPartNrInFilename() {
        return this.partNrInFilename;
    }

    public boolean isTransformNrInFilename() {
        return this.transformNrInFilename;
    }

    public String getFileCompression() {
        return this.fileCompression;
    }

    public void setFileCompression(String fileCompression) {
        this.fileCompression = fileCompression;
    }

    public String[] getFiles(IVariables variables) {
        return this.getFiles(variables, true);
    }

    private String[] getFiles(IVariables variables, boolean showSamples) {
        String realFileName = variables.resolve(this.fileName);
        String realExtension = variables.resolve(this.extension);
        return this.getFiles(realFileName, realExtension, showSamples);
    }

    public String[] getFiles(String realFileName, String realExtension, boolean showSamples) {
        Date now = new Date();
        if (showSamples) {
            int nr;
            int copies = 1;
            int splits = 1;
            int parts = 1;
            if (this.isTransformNrInFilename()) {
                copies = 3;
            }
            if (this.isPartNrInFilename()) {
                parts = 3;
            }
            if (this.getSplitEvery() != 0) {
                splits = 3;
            }
            if ((nr = copies * parts * splits) > 1) {
                ++nr;
            }
            String[] retval = new String[nr];
            int i = 0;
            for (int transform = 0; transform < copies; ++transform) {
                for (int part = 0; part < parts; ++part) {
                    for (int split = 0; split < splits; ++split) {
                        retval[i] = this.buildFilename(realFileName, realExtension, "" + transform, this.getPartPrefix() + part, "" + split, now, false, showSamples);
                        ++i;
                    }
                }
            }
            if (i < nr) {
                retval[i] = "...";
            }
            return retval;
        }
        return new String[]{this.buildFilename(realFileName, realExtension, "<transform>", "<partition>", "<split>", now, false, showSamples)};
    }

    protected String getPartPrefix() {
        return "";
    }

    public String buildFilename(IVariables variables, String copyNr, String partitionNr, String splitNr, boolean ziparchive) {
        return this.buildFilename(variables, copyNr, partitionNr, splitNr, ziparchive, true);
    }

    public String buildFilename(IVariables variables, String transformnr, String partnr, String splitnr, boolean ziparchive, boolean showSamples) {
        String realFileName = variables.resolve(this.fileName);
        String realExtension = variables.resolve(this.extension);
        return this.buildFilename(realFileName, realExtension, transformnr, partnr, splitnr, new Date(), ziparchive, showSamples);
    }

    private String buildFilename(String realFileName, String realExtension, String transformnr, String partnr, String splitnr, Date date, boolean ziparchive, boolean showSamples) {
        return this.buildFilename(realFileName, realExtension, transformnr, partnr, splitnr, date, ziparchive, showSamples, this);
    }

    protected String buildFilename(String realFileName, String realExtension, String transformnr, String partnr, String splitnr, Date date, boolean ziparchive, boolean showSamples, BaseFileOutputMeta meta) {
        return this.buildFilename(null, realFileName, realExtension, transformnr, partnr, splitnr, date, ziparchive, showSamples, meta);
    }

    protected String buildFilename(IVariables variables, String realFileName, String realExtension, String transformnr, String partnr, String splitnr, Date date, boolean ziparchive, boolean showSamples, BaseFileOutputMeta meta) {
        Date now;
        SimpleDateFormat daf = new SimpleDateFormat();
        Object retval = realFileName;
        if (meta.isFileAsCommand()) {
            return retval;
        }
        Date date2 = now = date == null ? new Date() : date;
        if (meta.isSpecifyingFormat() && !Utils.isEmpty((CharSequence)meta.getDateTimeFormat())) {
            daf.applyPattern(meta.getDateTimeFormat());
            String dt = daf.format(now);
            retval = (String)retval + dt;
        } else {
            if (meta.isDateInFilename()) {
                if (showSamples) {
                    daf.applyPattern("yyyMMdd");
                    String d = daf.format(now);
                    retval = (String)retval + "_" + d;
                } else {
                    retval = (String)retval + "_<yyyMMdd>";
                }
            }
            if (meta.isTimeInFilename()) {
                if (showSamples) {
                    daf.applyPattern("HHmmss");
                    String t = daf.format(now);
                    retval = (String)retval + "_" + t;
                } else {
                    retval = (String)retval + "_<HHmmss>";
                }
            }
        }
        if (meta.isTransformNrInFilename()) {
            retval = (String)retval + "_" + transformnr;
        }
        if (meta.isPartNrInFilename()) {
            retval = (String)retval + "_" + partnr;
        }
        if (meta.getSplitEvery(variables) > 0) {
            retval = (String)retval + "_" + splitnr;
        }
        if ("Zip".equals(meta.getFileCompression())) {
            if (ziparchive) {
                retval = (String)retval + ".zip";
            } else if (realExtension != null && realExtension.length() != 0) {
                retval = (String)retval + "." + realExtension;
            }
        } else {
            if (realExtension != null && realExtension.length() != 0) {
                retval = (String)retval + "." + realExtension;
            }
            if ("GZip".equals(meta.getFileCompression())) {
                retval = (String)retval + ".gz";
            }
        }
        return retval;
    }
}

