/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.gettablenames;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.gettablenames.GetTableNamesData;
import org.apache.hop.pipeline.transforms.gettablenames.GetTableNamesMeta;

public class GetTableNames
extends BaseTransform<GetTableNamesMeta, GetTableNamesData> {
    private static final Class<?> PKG = GetTableNamesMeta.class;

    public GetTableNames(TransformMeta transformMeta, GetTableNamesMeta meta, GetTableNamesData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)((GetTableNamesData)this.data).outputRowMeta.size());
        return rowData;
    }

    public boolean processRow() throws HopException {
        if (((GetTableNamesMeta)this.meta).isDynamicSchema()) {
            ((GetTableNamesData)this.data).readrow = this.getRow();
            if (((GetTableNamesData)this.data).readrow == null) {
                this.setOutputDone();
                return false;
            }
        }
        if (this.first) {
            this.first = false;
            if (((GetTableNamesMeta)this.meta).isDynamicSchema()) {
                ((GetTableNamesData)this.data).inputRowMeta = this.getInputRowMeta();
                ((GetTableNamesData)this.data).outputRowMeta = ((GetTableNamesData)this.data).inputRowMeta.clone();
                ((GetTableNamesData)this.data).totalpreviousfields = ((GetTableNamesData)this.data).inputRowMeta.size();
                if (Utils.isEmpty((CharSequence)((GetTableNamesMeta)this.meta).getSchemaFieldName())) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetTableNames.Log.NoSchemaField", (String[])new String[0]));
                    throw new HopException(BaseMessages.getString(PKG, (String)"GetTableNames.Log.NoSchemaField", (String[])new String[0]));
                }
                if (((GetTableNamesData)this.data).indexOfSchemaField < 0) {
                    ((GetTableNamesData)this.data).indexOfSchemaField = ((GetTableNamesData)this.data).inputRowMeta.indexOfValue(((GetTableNamesMeta)this.meta).getSchemaFieldName());
                    if (((GetTableNamesData)this.data).indexOfSchemaField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"GetTableNames.Log.ErrorFindingField", (String[])new String[0]) + "[" + ((GetTableNamesMeta)this.meta).getSchemaFieldName() + "]");
                        throw new HopException(BaseMessages.getString(PKG, (String)"GetTableNames.Exception.CouldnotFindField", (String[])new String[]{((GetTableNamesMeta)this.meta).getSchemaFieldName()}));
                    }
                }
            } else {
                ((GetTableNamesData)this.data).outputRowMeta = new RowMeta();
            }
            ((GetTableNamesMeta)this.meta).getFields(((GetTableNamesData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        if (((GetTableNamesMeta)this.meta).isDynamicSchema()) {
            ((GetTableNamesData)this.data).realSchemaName = ((GetTableNamesData)this.data).inputRowMeta.getString(((GetTableNamesData)this.data).readrow, ((GetTableNamesData)this.data).indexOfSchemaField);
        }
        Object[] outputRow = this.buildEmptyRow();
        if (((GetTableNamesMeta)this.meta).isDynamicSchema()) {
            System.arraycopy(((GetTableNamesData)this.data).readrow, 0, outputRow, 0, ((GetTableNamesData)this.data).readrow.length);
        }
        this.processIncludeCatalog(outputRow);
        this.processIncludeSchema(outputRow);
        this.processIncludeTable(outputRow);
        this.processIncludeView(outputRow);
        this.processIncludeProcedure(outputRow);
        this.processIncludeSynonym(outputRow);
        if (!((GetTableNamesMeta)this.meta).isDynamicSchema()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void processIncludeSynonym(Object[] outputRow) throws HopDatabaseException, HopTransformException, HopValueException {
        if (((GetTableNamesMeta)this.meta).isIncludeSynonym()) {
            String[] synonyms = ((GetTableNamesData)this.data).db.getSynonyms(((GetTableNamesData)this.data).realSchemaName, ((GetTableNamesMeta)this.meta).isAddSchemaInOut());
            String objectType = BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectType.Synonym", (String[])new String[0]);
            for (int i = 0; i < synonyms.length && !this.isStopped(); ++i) {
                Object[] outputRowSyn = (Object[])outputRow.clone();
                int outputIndex = ((GetTableNamesData)this.data).totalpreviousfields;
                String synonym = synonyms[i];
                outputRowSyn[outputIndex++] = synonym;
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realObjectTypeFieldName)) {
                    outputRowSyn[outputIndex++] = objectType;
                }
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realIsSystemObjectFieldName)) {
                    outputRowSyn[outputIndex++] = ((GetTableNamesData)this.data).db.isSystemTable(synonym);
                }
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realSqlCreationFieldName)) {
                    outputRowSyn[outputIndex++] = null;
                }
                ++((GetTableNamesData)this.data).rownr;
                this.putRow(((GetTableNamesData)this.data).outputRowMeta, outputRowSyn);
                this.logInfo(outputRowSyn);
            }
        }
    }

    private void processIncludeProcedure(Object[] outputRow) throws HopDatabaseException, HopTransformException, HopValueException {
        if (((GetTableNamesMeta)this.meta).isIncludeProcedure()) {
            String[] procNames = ((GetTableNamesData)this.data).db.getProcedures();
            String objectType = BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectType.Procedure", (String[])new String[0]);
            for (int i = 0; i < procNames.length && !this.isStopped(); ++i) {
                Object[] outputRowProc = (Object[])outputRow.clone();
                int outputIndex = ((GetTableNamesData)this.data).totalpreviousfields;
                String procName = procNames[i];
                outputRowProc[outputIndex++] = procName;
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realObjectTypeFieldName)) {
                    outputRowProc[outputIndex++] = objectType;
                }
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realIsSystemObjectFieldName)) {
                    outputRowProc[outputIndex++] = ((GetTableNamesData)this.data).db.isSystemTable(procName);
                }
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realSqlCreationFieldName)) {
                    outputRowProc[outputIndex++] = null;
                }
                ++((GetTableNamesData)this.data).rownr;
                this.putRow(((GetTableNamesData)this.data).outputRowMeta, outputRowProc);
                this.logInfo(outputRowProc);
            }
        }
    }

    @VisibleForTesting
    void processIncludeView(Object[] outputRow) {
        if (((GetTableNamesMeta)this.meta).isIncludeView()) {
            try {
                String[] viewNames = ((GetTableNamesData)this.data).db.getViews(((GetTableNamesData)this.data).realSchemaName, ((GetTableNamesMeta)this.meta).isAddSchemaInOut());
                String[] viewNamesWithoutSchema = ((GetTableNamesData)this.data).db.getViews(((GetTableNamesData)this.data).realSchemaName, false);
                String objectType = BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectType.View", (String[])new String[0]);
                for (int i = 0; i < viewNames.length && !this.isStopped(); ++i) {
                    Object[] outputRowView = (Object[])outputRow.clone();
                    int outputIndex = ((GetTableNamesData)this.data).totalpreviousfields;
                    String viewName = viewNames[i];
                    String viewNameWithoutSchema = viewNamesWithoutSchema[i];
                    outputRowView[outputIndex++] = viewName;
                    if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realObjectTypeFieldName)) {
                        outputRowView[outputIndex++] = objectType;
                    }
                    if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realIsSystemObjectFieldName)) {
                        outputRowView[outputIndex++] = ((GetTableNamesData)this.data).db.isSystemTable(viewNameWithoutSchema);
                    }
                    if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realSqlCreationFieldName)) {
                        outputRowView[outputIndex++] = null;
                    }
                    ++((GetTableNamesData)this.data).rownr;
                    this.putRow(((GetTableNamesData)this.data).outputRowMeta, outputRowView);
                    this.logInfo(outputRowView);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    void processIncludeTable(Object[] outputRow) throws HopDatabaseException, HopTransformException, HopValueException {
        if (((GetTableNamesMeta)this.meta).isIncludeTable()) {
            String[] tableNames = ((GetTableNamesData)this.data).db.getTablenames(((GetTableNamesData)this.data).realSchemaName, ((GetTableNamesMeta)this.meta).isAddSchemaInOut());
            String[] tableNamesWithoutSchema = ((GetTableNamesData)this.data).db.getTablenames(((GetTableNamesData)this.data).realSchemaName, false);
            String objectType = BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectType.Table", (String[])new String[0]);
            for (int i = 0; i < tableNames.length && !this.isStopped(); ++i) {
                int indexOfLastClosedBracket;
                Object[] outputRowTable = (Object[])outputRow.clone();
                int outputIndex = ((GetTableNamesData)this.data).totalpreviousfields;
                String tableName = tableNames[i];
                String tableNameWithoutSchema = tableNamesWithoutSchema[i];
                outputRowTable[outputIndex++] = tableName;
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realObjectTypeFieldName)) {
                    outputRowTable[outputIndex++] = objectType;
                }
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realIsSystemObjectFieldName)) {
                    outputRowTable[outputIndex++] = ((GetTableNamesData)this.data).db.isSystemTable(tableNameWithoutSchema);
                }
                String pk = null;
                String[] pkc = ((GetTableNamesData)this.data).db.getPrimaryKeyColumnNames(tableNameWithoutSchema);
                if (pkc != null && pkc.length == 1) {
                    pk = pkc[0];
                }
                Object sql = ((GetTableNamesData)this.data).db.getCreateTableStatement(tableName, ((GetTableNamesData)this.data).db.getTableFieldsMeta(((GetTableNamesData)this.data).realSchemaName, tableNameWithoutSchema), null, false, pk, true);
                if (pkc != null && (indexOfLastClosedBracket = ((String)sql).lastIndexOf(")")) > -1) {
                    sql = ((String)sql).substring(0, indexOfLastClosedBracket);
                    sql = (String)sql + ", PRIMARY KEY (";
                    for (int k = 0; k < pkc.length; ++k) {
                        if (k > 0) {
                            sql = (String)sql + ", ";
                        }
                        sql = (String)sql + pkc[k];
                    }
                    sql = (String)sql + ")" + Const.CR + ")" + Const.CR + ";";
                }
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realSqlCreationFieldName)) {
                    outputRowTable[outputIndex++] = sql;
                }
                ++((GetTableNamesData)this.data).rownr;
                this.putRow(((GetTableNamesData)this.data).outputRowMeta, outputRowTable);
                this.logInfo(outputRowTable);
            }
        }
    }

    private void processIncludeSchema(Object[] outputRow) throws HopDatabaseException, HopTransformException, HopValueException {
        if (((GetTableNamesMeta)this.meta).isIncludeSchema()) {
            String objectType = BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectType.Schema", (String[])new String[0]);
            String[] schemaNames = new String[]{};
            schemaNames = !Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realSchemaName) ? new String[]{((GetTableNamesData)this.data).realSchemaName} : ((GetTableNamesData)this.data).db.getSchemas();
            for (int i = 0; i < schemaNames.length && !this.isStopped(); ++i) {
                Object[] outputRowSchema = (Object[])outputRow.clone();
                int outputIndex = ((GetTableNamesData)this.data).totalpreviousfields;
                String schemaName = schemaNames[i];
                outputRowSchema[outputIndex++] = schemaName;
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realObjectTypeFieldName)) {
                    outputRowSchema[outputIndex++] = objectType;
                }
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realIsSystemObjectFieldName)) {
                    outputRowSchema[outputIndex++] = ((GetTableNamesData)this.data).db.isSystemTable(schemaName);
                }
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realSqlCreationFieldName)) {
                    outputRowSchema[outputIndex++] = null;
                }
                ++((GetTableNamesData)this.data).rownr;
                this.putRow(((GetTableNamesData)this.data).outputRowMeta, outputRowSchema);
                this.logInfo(outputRowSchema);
            }
        }
    }

    private void processIncludeCatalog(Object[] outputRow) throws HopDatabaseException, HopTransformException, HopValueException {
        if (((GetTableNamesMeta)this.meta).isIncludeCatalog()) {
            String objectType = BaseMessages.getString(PKG, (String)"GetTableNames.ObjectType.Catalog", (String[])new String[0]);
            String[] catalogsNames = ((GetTableNamesData)this.data).db.getCatalogs();
            for (int i = 0; i < catalogsNames.length && !this.isStopped(); ++i) {
                Object[] outputRowCatalog = (Object[])outputRow.clone();
                int outputIndex = ((GetTableNamesData)this.data).totalpreviousfields;
                String catalogName = catalogsNames[i];
                outputRowCatalog[outputIndex++] = catalogName;
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realObjectTypeFieldName)) {
                    outputRowCatalog[outputIndex++] = objectType;
                }
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realIsSystemObjectFieldName)) {
                    outputRowCatalog[outputIndex++] = ((GetTableNamesData)this.data).db.isSystemTable(catalogName);
                }
                if (!Utils.isEmpty((CharSequence)((GetTableNamesData)this.data).realSqlCreationFieldName)) {
                    outputRowCatalog[outputIndex++] = null;
                }
                ++((GetTableNamesData)this.data).rownr;
                this.putRow(((GetTableNamesData)this.data).outputRowMeta, outputRowCatalog);
                this.logInfo(outputRowCatalog);
            }
        }
    }

    private void logInfo(Object[] outputRow) throws HopValueException {
        if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"GetTableNames.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"GetTableNames.Log.PutoutRow", (String[])new String[]{((GetTableNamesData)this.data).outputRowMeta.getString(outputRow)}));
        }
    }

    public boolean init() {
        block9: {
            if (super.init()) {
                if (Utils.isEmpty((CharSequence)((GetTableNamesMeta)this.meta).getTablenameFieldName())) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetTableNames.Error.TablenameFieldNameMissing", (String[])new String[0]));
                    return false;
                }
                String realSchemaName = this.resolve(((GetTableNamesMeta)this.meta).getSchemaName());
                if (!Utils.isEmpty((CharSequence)realSchemaName)) {
                    ((GetTableNamesData)this.data).realSchemaName = realSchemaName;
                }
                ((GetTableNamesData)this.data).realTableNameFieldName = this.resolve(((GetTableNamesMeta)this.meta).getTablenameFieldName());
                ((GetTableNamesData)this.data).realObjectTypeFieldName = this.resolve(((GetTableNamesMeta)this.meta).getObjectTypeFieldName());
                ((GetTableNamesData)this.data).realIsSystemObjectFieldName = this.resolve(((GetTableNamesMeta)this.meta).isSystemObjectFieldName());
                ((GetTableNamesData)this.data).realSqlCreationFieldName = this.resolve(((GetTableNamesMeta)this.meta).getSqlCreationFieldName());
                if (!(((GetTableNamesMeta)this.meta).isIncludeCatalog() || ((GetTableNamesMeta)this.meta).isIncludeSchema() || ((GetTableNamesMeta)this.meta).isIncludeTable() || ((GetTableNamesMeta)this.meta).isIncludeView() || ((GetTableNamesMeta)this.meta).isIncludeProcedure() || ((GetTableNamesMeta)this.meta).isIncludeSynonym())) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetTableNames.Error.includeAtLeastOneType", (String[])new String[0]));
                    return false;
                }
                try {
                    ((GetTableNamesData)this.data).outputRowMeta = new RowMeta();
                    ((GetTableNamesMeta)this.meta).getFields(((GetTableNamesData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                }
                catch (Exception e) {
                    this.logError("Error initializing transform: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
                ((GetTableNamesData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((GetTableNamesMeta)this.meta).getDatabase());
                try {
                    ((GetTableNamesData)this.data).db.connect();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"GetTableNames.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    return true;
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetTableNames.Log.DBException", (String[])new String[0]) + e.getMessage());
                    if (((GetTableNamesData)this.data).db == null) break block9;
                    ((GetTableNamesData)this.data).db.disconnect();
                }
            }
        }
        return false;
    }

    public void dispose() {
        if (((GetTableNamesData)this.data).db != null) {
            ((GetTableNamesData)this.data).db.disconnect();
            ((GetTableNamesData)this.data).db = null;
        }
        super.dispose();
    }
}

