/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.response;

import cc.blynk.clickhouse.response.StreamSplitter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class ByteFragment {
    final byte[] buf;
    protected final int start;
    final int len;
    private static final ByteFragment EMPTY = new ByteFragment(new byte[0], 0, 0);
    private static final byte[] reverse;
    private static final byte[] convert;

    public ByteFragment(byte[] buf, int start, int len) {
        this.buf = buf;
        this.start = start;
        this.len = len;
    }

    static ByteFragment fromString(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        return new ByteFragment(bytes, 0, bytes.length);
    }

    public boolean isNull() {
        return this.len == 2 && this.buf[this.start] == 92 && this.buf[this.start + 1] == 78;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ByteFragment{[");
        for (byte b1 : this.buf) {
            if (b1 == 9) {
                b.append("<TAB>");
                continue;
            }
            b.append((char)b1);
        }
        b.append(']');
        b.append(", start=").append(this.start).append(", len=").append(this.len).append('}');
        return b.toString();
    }

    String asString() {
        return new String(this.buf, this.start, this.len, StandardCharsets.UTF_8);
    }

    static void escape(byte[] bytes, OutputStream stream) throws IOException {
        for (byte b : bytes) {
            if (b < 0 || b >= reverse.length) {
                stream.write(b);
                continue;
            }
            byte converted = reverse[b];
            if (converted != -1) {
                stream.write(92);
                stream.write(converted);
                continue;
            }
            stream.write(b);
        }
    }

    int getLen() {
        return this.len;
    }

    String asString(boolean unescape) {
        if (unescape) {
            if (this.isNull()) {
                return null;
            }
            return new String(this.unescape(), StandardCharsets.UTF_8);
        }
        return this.asString();
    }

    private int count(byte sep) {
        int res = 0;
        for (int i = this.start; i < this.start + this.len; ++i) {
            if (this.buf[i] != sep) continue;
            ++res;
        }
        return res;
    }

    ByteArrayInputStream asStream() {
        return new ByteArrayInputStream(this.buf, this.start, this.len);
    }

    ByteFragment[] split(byte sep) {
        StreamSplitter ss = new StreamSplitter(this, sep);
        int c = this.count(sep) + 1;
        ByteFragment[] res = new ByteFragment[c];
        try {
            ByteFragment next;
            int i = 0;
            while ((next = ss.next()) != null) {
                res[i++] = next;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (res[c - 1] == null) {
            res[c - 1] = EMPTY;
        }
        return res;
    }

    byte[] unescape() {
        int resLen = 0;
        boolean prevSlash = false;
        for (int i = this.start; i < this.start + this.len; ++i) {
            if (prevSlash) {
                ++resLen;
                prevSlash = false;
                continue;
            }
            if (this.buf[i] == 92) {
                prevSlash = true;
                continue;
            }
            ++resLen;
        }
        if (resLen == this.len) {
            return this.getBytesCopy();
        }
        byte[] res = new byte[resLen];
        int index = 0;
        prevSlash = false;
        for (int i = this.start; i < this.start + this.len; ++i) {
            if (prevSlash) {
                prevSlash = false;
                res[index++] = convert[this.buf[i]];
                continue;
            }
            if (this.buf[i] == 92) {
                prevSlash = true;
                continue;
            }
            res[index++] = this.buf[i];
        }
        return res;
    }

    private byte[] getBytesCopy() {
        byte[] bytes = new byte[this.len];
        System.arraycopy(this.buf, this.start, bytes, 0, this.len);
        return bytes;
    }

    public int length() {
        return this.len;
    }

    int charAt(int i) {
        return this.buf[this.start + i];
    }

    ByteFragment subseq(int start, int len) {
        if (start < 0 || start + len > this.len) {
            throw new IllegalArgumentException("arg start,len=" + start + "," + len + " while this start,len=" + this.start + "," + this.len);
        }
        return new ByteFragment(this.buf, this.start + start, len);
    }

    static {
        convert = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 92, -1, -1, -1, -1, -1, 8, -1, -1, -1, 12, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, 13, -1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        reverse = new byte[convert.length];
        for (int i = 0; i < convert.length; ++i) {
            ByteFragment.reverse[i] = -1;
            byte c = convert[i];
            if (c == -1) continue;
            ByteFragment.reverse[c] = (byte)i;
        }
    }
}

