/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.http;

import cc.blynk.clickhouse.ClickHouseExternalData;
import cc.blynk.clickhouse.except.ClickHouseException;
import cc.blynk.clickhouse.except.ClickHouseExceptionSpecifier;
import cc.blynk.clickhouse.http.HttpConnector;
import cc.blynk.clickhouse.http.TrustAllHostnameVerifier;
import cc.blynk.clickhouse.settings.ClickHouseProperties;
import cc.blynk.clickhouse.util.ClickHouseLZ4InputStream;
import cc.blynk.clickhouse.util.ClickHouseLZ4OutputStream;
import cc.blynk.clickhouse.util.guava.StreamUtils;
import cc.blynk.clickhouse.util.ssl.NonValidatingTrustManager;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultHttpConnector
implements HttpConnector {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpConnector.class);
    private final ClickHouseProperties properties;
    private HttpURLConnection httpURLConnection;

    DefaultHttpConnector(ClickHouseProperties properties) {
        this.properties = properties;
    }

    @Override
    public void post(String sql, List<byte[]> data, URI uri) throws ClickHouseException {
        HttpURLConnection connection = this.buildConnection(uri);
        this.sendPostRequest(sql, data, connection);
    }

    @Override
    public InputStream post(String sql, URI uri) throws ClickHouseException {
        byte[] bytes = this.getSqlBytes(sql);
        HttpURLConnection connection = this.buildConnection(uri);
        return this.sendPostRequest(new ByteArrayInputStream(bytes), connection);
    }

    @Override
    public void post(String sql, InputStream from, URI uri) throws ClickHouseException {
        HttpURLConnection connection = this.buildConnection(uri);
        this.sendPostRequest(sql, from, connection);
    }

    @Override
    public InputStream post(List<ClickHouseExternalData> externalData, URI uri) throws ClickHouseException {
        String boundaryString = UUID.randomUUID().toString();
        HttpURLConnection connection = this.buildConnection(uri);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundaryString);
        byte[] bytes = this.buildMultipartData(externalData, boundaryString);
        ByteArrayInputStream from = new ByteArrayInputStream(bytes);
        return this.sendPostRequest(from, connection);
    }

    @Override
    public void close() {
        if (this.httpURLConnection != null) {
            this.httpURLConnection.disconnect();
        }
    }

    private void sendPostRequest(String sql, List<byte[]> batches, HttpURLConnection connection) throws ClickHouseException {
        try (OutputStream outputStream = this.properties.isDecompress() ? new ClickHouseLZ4OutputStream(connection.getOutputStream(), this.properties.getMaxCompressBufferSize()) : new DataOutputStream(connection.getOutputStream());){
            byte[] sqlBytes = this.getSqlBytes(sql);
            outputStream.write(sqlBytes);
            for (byte[] batch : batches) {
                outputStream.write(batch);
            }
            outputStream.flush();
            this.checkForErrorAndThrow(connection);
            try (InputStream is = connection.getInputStream();){
                StreamUtils.toByteArray(is);
            }
        }
        catch (IOException e) {
            log.error("Http POST request failed. {}", (Object)e.getMessage());
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    private void sendPostRequest(String sql, InputStream from, HttpURLConnection connection) throws ClickHouseException {
        try (OutputStream requestStream = this.openOutputStream(connection);
             InputStream fromIS = from;){
            byte[] sqlBytes = this.getSqlBytes(sql);
            requestStream.write(sqlBytes);
            StreamUtils.copy(fromIS, requestStream);
            requestStream.flush();
            this.checkForErrorAndThrow(connection);
            try (InputStream is = connection.getInputStream();){
                StreamUtils.toByteArray(is);
            }
        }
        catch (IOException e) {
            log.error("Http POST request failed. {}", (Object)e.getMessage());
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    private byte[] getSqlBytes(String sql) {
        if (!sql.endsWith("\n")) {
            sql = sql + "\n";
        }
        return sql.getBytes(StandardCharsets.UTF_8);
    }

    /*
     * Exception decompiling
     */
    private InputStream sendPostRequest(InputStream from, HttpURLConnection connection) throws ClickHouseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OutputStream openOutputStream(HttpURLConnection connection) throws IOException {
        OutputStream outputStream = connection.getOutputStream();
        if (this.properties.isDecompress()) {
            return new ClickHouseLZ4OutputStream(outputStream, this.properties.getMaxCompressBufferSize());
        }
        return new DataOutputStream(outputStream);
    }

    /*
     * Exception decompiling
     */
    private byte[] buildMultipartData(List<ClickHouseExternalData> externalData, String boundaryString) throws ClickHouseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpURLConnection buildConnection(URI uri) throws ClickHouseException {
        try {
            HttpURLConnection prevConnection = this.httpURLConnection;
            if (prevConnection != null) {
                prevConnection.disconnect();
            }
            URL url = uri.toURL();
            HttpURLConnection newConnection = (HttpURLConnection)url.openConnection();
            newConnection.setInstanceFollowRedirects(true);
            newConnection.setRequestMethod("POST");
            newConnection.setDoInput(true);
            newConnection.setDoOutput(true);
            newConnection.setConnectTimeout(this.properties.getConnectionTimeout());
            this.setDefaultHeaders(newConnection);
            if (newConnection instanceof HttpsURLConnection) {
                this.configureHttps((HttpsURLConnection)newConnection);
            }
            this.httpURLConnection = newConnection;
            return newConnection;
        }
        catch (IOException e) {
            log.error("Can't build connection. {}", (Object)e.getMessage());
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    private void setDefaultHeaders(HttpURLConnection connection) {
        String httpAuthorization = this.properties.getHttpAuthorization();
        if (httpAuthorization != null) {
            connection.addRequestProperty("Authorization", httpAuthorization);
        }
        connection.addRequestProperty("Content-Type", "text/plain; charset=UTF-8");
    }

    private void configureHttps(HttpsURLConnection connection) throws ClickHouseException {
        if (this.properties.getSsl()) {
            try {
                SSLContext sslContext = this.getSSLContext();
                HostnameVerifier verifier = "strict".equals(this.properties.getSslMode()) ? HttpsURLConnection.getDefaultHostnameVerifier() : TrustAllHostnameVerifier.getInstance();
                connection.setHostnameVerifier(verifier);
                SSLSocketFactory socketFactory = sslContext.getSocketFactory();
                connection.setSSLSocketFactory(socketFactory);
            }
            catch (Exception e) {
                throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
            }
        }
    }

    private void checkForErrorAndThrow(HttpURLConnection connection) throws IOException, ClickHouseException {
        if (connection.getResponseCode() != 200) {
            InputStream messageStream = connection.getErrorStream();
            byte[] bytes = StreamUtils.toByteArray(messageStream);
            if (this.properties.isCompress()) {
                try {
                    messageStream = new ClickHouseLZ4InputStream(new ByteArrayInputStream(bytes));
                    bytes = StreamUtils.toByteArray(messageStream);
                }
                catch (IOException e) {
                    log.warn("Error while read compressed stream. {}", (Object)e.getMessage());
                }
            }
            StreamUtils.close(messageStream);
            String chMessage = new String(bytes, StandardCharsets.UTF_8);
            throw ClickHouseExceptionSpecifier.specify(chMessage, this.properties.getHost(), this.properties.getPort());
        }
    }

    private SSLContext getSSLContext() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, KeyManagementException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        TrustManager[] tms = null;
        KeyManager[] kms = null;
        SecureRandom sr = null;
        switch (this.properties.getSslMode()) {
            case "none": {
                tms = new TrustManager[]{new NonValidatingTrustManager()};
                kms = new KeyManager[]{};
                sr = new SecureRandom();
                break;
            }
            case "strict": {
                if (this.properties.getSslRootCertificate().isEmpty()) break;
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(this.getKeyStore());
                tms = tmf.getTrustManagers();
                kms = new KeyManager[]{};
                sr = new SecureRandom();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown ssl mode '" + this.properties.getSslMode() + "'");
            }
        }
        ctx.init(kms, tms, sr);
        return ctx;
    }

    private KeyStore getKeyStore() throws NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException {
        InputStream caInputStream;
        KeyStore ks;
        block5: {
            try {
                ks = KeyStore.getInstance("jks");
                ks.load(null, null);
            }
            catch (KeyStoreException e) {
                throw new NoSuchAlgorithmException("jks KeyStore not available");
            }
            try {
                caInputStream = new FileInputStream(this.properties.getSslRootCertificate());
            }
            catch (FileNotFoundException ex) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                caInputStream = cl.getResourceAsStream(this.properties.getSslRootCertificate());
                if (caInputStream != null) break block5;
                throw new IOException("Could not open SSL/TLS root certificate file '" + this.properties.getSslRootCertificate() + "'", ex);
            }
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Iterator<? extends Certificate> caIt = cf.generateCertificates(caInputStream).iterator();
        StreamUtils.close(caInputStream);
        int i = 0;
        while (caIt.hasNext()) {
            ks.setCertificateEntry("cert" + i, caIt.next());
            ++i;
        }
        return ks;
    }
}

