/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.serializer.multi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;

public class MultiMetadataSerializer<T extends IHopMetadata>
implements IHopMetadataSerializer<T> {
    protected MultiMetadataProvider multiProvider;
    protected Class<T> managedClass;
    protected IVariables variables;
    protected String description;

    public MultiMetadataSerializer(MultiMetadataProvider multiProvider, Class<T> managedClass, IVariables variables, String description) {
        this.multiProvider = multiProvider;
        this.managedClass = managedClass;
        this.variables = variables;
        this.description = description;
    }

    @Override
    public T load(String objectName) throws HopException {
        List<IHopMetadataProvider> providers = this.multiProvider.getProviders();
        ListIterator<IHopMetadataProvider> providerIterator = providers.listIterator(providers.size());
        while (providerIterator.hasPrevious()) {
            IHopMetadataProvider provider = providerIterator.previous();
            IHopMetadataSerializer<T> serializer = provider.getSerializer(this.managedClass);
            if (!serializer.exists(objectName)) continue;
            return serializer.load(objectName);
        }
        return null;
    }

    @Override
    public void save(T t) throws HopException {
        IHopMetadataProvider provider;
        if (StringUtils.isEmpty((String)t.getMetadataProviderName())) {
            List<IHopMetadataProvider> providers = this.multiProvider.getProviders();
            if (providers.isEmpty()) {
                throw new HopException("No providers are listed to save object '" + t.getName() + "' to");
            }
            provider = providers.get(providers.size() - 1);
        } else {
            String sourceDescription = t.getMetadataProviderName();
            provider = this.multiProvider.findProvider(sourceDescription);
            if (provider == null) {
                throw new HopException("Hop metadata provider '" + sourceDescription + " could not be found to save object '" + t.getName() + "'");
            }
        }
        IHopMetadataSerializer<T> serializer = provider.getSerializer(this.managedClass);
        serializer.save(t);
    }

    @Override
    public T delete(String name) throws HopException {
        List<IHopMetadataProvider> providers = this.multiProvider.getProviders();
        ListIterator<IHopMetadataProvider> providerIterator = providers.listIterator(providers.size());
        while (providerIterator.hasPrevious()) {
            IHopMetadataProvider provider = providerIterator.previous();
            IHopMetadataSerializer<T> serializer = provider.getSerializer(this.managedClass);
            if (!serializer.exists(name)) continue;
            return serializer.delete(name);
        }
        throw new HopException("Object '" + name + "' was not found nor deleted from any of the metadata providers");
    }

    @Override
    public List<String> listObjectNames() throws HopException {
        HashSet<String> set = new HashSet<String>();
        for (IHopMetadataProvider provider : this.multiProvider.getProviders()) {
            set.addAll(provider.getSerializer(this.managedClass).listObjectNames());
        }
        return new ArrayList<String>(set);
    }

    @Override
    public boolean exists(String name) throws HopException {
        for (IHopMetadataProvider provider : this.multiProvider.getProviders()) {
            if (!provider.getSerializer(this.managedClass).exists(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> loadAll() throws HopException {
        HashSet<T> set = new HashSet<T>();
        for (IHopMetadataProvider provider : this.multiProvider.getProviders()) {
            set.addAll(provider.getSerializer(this.managedClass).loadAll());
        }
        return new ArrayList(set);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class<T> getManagedClass() {
        return this.managedClass;
    }

    @Override
    public IHopMetadataProvider getMetadataProvider() {
        return this.multiProvider;
    }
}

