/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelwriter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterOutputField;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterTransformData;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterTransformMeta;
import org.apache.hop.workarounds.BufferedOutputStreamWithCloseDetection;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriterTransform
extends BaseTransform<ExcelWriterTransformMeta, ExcelWriterTransformData> {
    private static final Class<?> PKG = ExcelWriterTransformMeta.class;
    public static final String STREAMER_FORCE_RECALC_PROP_NAME = "HOP_EXCEL_WRITER_STREAMER_FORCE_RECALCULATE";

    public ExcelWriterTransform(TransformMeta transformMeta, ExcelWriterTransformMeta meta, ExcelWriterTransformData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (this.first) {
            this.first = false;
            if (r == null) {
                ((ExcelWriterTransformData)this.data).outputRowMeta = new RowMeta();
                ((ExcelWriterTransformData)this.data).inputRowMeta = new RowMeta();
            } else {
                ((ExcelWriterTransformData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((ExcelWriterTransformData)this.data).inputRowMeta = this.getInputRowMeta().clone();
            }
            if (!((ExcelWriterTransformMeta)this.meta).getFile().isDoNotOpenNewFileInit()) {
                ((ExcelWriterTransformData)this.data).firstFileOpened = true;
                try {
                    this.prepareNextOutputFile(r);
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Exception.CouldNotPrepareFile", (String[])new String[]{this.resolve(((ExcelWriterTransformMeta)this.meta).getFile().getFileName())}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            if (r != null) {
                if (((ExcelWriterTransformMeta)this.meta).getFile().isDoNotOpenNewFileInit()) {
                    ((ExcelWriterTransformData)this.data).firstFileOpened = true;
                    this.prepareNextOutputFile(r);
                }
                int outputFieldsCount = ((ExcelWriterTransformMeta)this.meta).getOutputFields().size();
                ((ExcelWriterTransformData)this.data).commentauthorfieldnrs = new int[outputFieldsCount];
                ((ExcelWriterTransformData)this.data).commentfieldnrs = new int[outputFieldsCount];
                ((ExcelWriterTransformData)this.data).linkfieldnrs = new int[outputFieldsCount];
                ((ExcelWriterTransformData)this.data).fieldnrs = new int[outputFieldsCount];
                int i = 0;
                for (ExcelWriterOutputField outputField : ((ExcelWriterTransformMeta)this.meta).getOutputFields()) {
                    String outputFieldName = outputField.getName();
                    ((ExcelWriterTransformData)this.data).fieldnrs[i] = ((ExcelWriterTransformData)this.data).inputRowMeta.indexOfValue(outputFieldName);
                    if (((ExcelWriterTransformData)this.data).fieldnrs[i] < 0) {
                        this.logError("Field [" + outputFieldName + "] couldn't be found in the input stream!");
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    String commentField = outputField.getCommentField();
                    ((ExcelWriterTransformData)this.data).commentfieldnrs[i] = ((ExcelWriterTransformData)this.data).inputRowMeta.indexOfValue(commentField);
                    if (((ExcelWriterTransformData)this.data).commentfieldnrs[i] < 0 && !Utils.isEmpty((CharSequence)commentField)) {
                        this.logError("Comment Field [" + commentField + "] couldn't be found in the input stream!");
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    String commentAuthorField = outputField.getCommentAuthorField();
                    ((ExcelWriterTransformData)this.data).commentauthorfieldnrs[i] = ((ExcelWriterTransformData)this.data).inputRowMeta.indexOfValue(commentAuthorField);
                    if (((ExcelWriterTransformData)this.data).commentauthorfieldnrs[i] < 0 && !Utils.isEmpty((CharSequence)commentAuthorField)) {
                        this.logError("Comment Author Field [" + commentAuthorField + "] couldn't be found in the input stream!");
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    String hyperlinkField = outputField.getHyperlinkField();
                    ((ExcelWriterTransformData)this.data).linkfieldnrs[i] = ((ExcelWriterTransformData)this.data).inputRowMeta.indexOfValue(hyperlinkField);
                    if (((ExcelWriterTransformData)this.data).linkfieldnrs[i] < 0 && !Utils.isEmpty((CharSequence)hyperlinkField)) {
                        this.logError("Link Field [" + hyperlinkField + "] couldn't be found in the input stream!");
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    ++i;
                }
            }
        }
        if (r != null) {
            if (!((ExcelWriterTransformMeta)this.meta).isAppendLines() && !((ExcelWriterTransformMeta)this.meta).getFile().isFileNameInField() && ((ExcelWriterTransformMeta)this.meta).getFile().getSplitEvery() > 0 && ((ExcelWriterTransformData)this.data).datalines > 0 && ((ExcelWriterTransformData)this.data).datalines % ((ExcelWriterTransformMeta)this.meta).getFile().getSplitEvery() == 0) {
                this.closeOutputFile();
                this.prepareNextOutputFile(r);
            }
            this.writeNextLine(r);
            this.incrementLinesOutput();
            ++((ExcelWriterTransformData)this.data).datalines;
            this.putRow(((ExcelWriterTransformData)this.data).outputRowMeta, r);
            if (this.checkFeedback(this.getLinesOutput()) && this.log.isBasic()) {
                this.logBasic("Linenr " + this.getLinesOutput());
            }
            return true;
        }
        if (((ExcelWriterTransformData)this.data).wb != null) {
            this.closeOutputFile();
        }
        this.setOutputDone();
        this.clearWorkbookMem();
        return false;
    }

    private void clearWorkbookMem() {
        ((ExcelWriterTransformData)this.data).file = null;
        ((ExcelWriterTransformData)this.data).sheet = null;
        ((ExcelWriterTransformData)this.data).wb = null;
        ((ExcelWriterTransformData)this.data).clearStyleCache(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParentFolder(String filename) throws Exception {
        block13: {
            FileObject parentfolder = null;
            try {
                parentfolder = HopVfs.getFileObject((String)filename).getParent();
                if (parentfolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelWriter.Log.ParentFolderExist", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelWriter.Log.ParentFolderNotExist", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                }
                if (((ExcelWriterTransformMeta)this.meta).getFile().isCreateParentFolder()) {
                    parentfolder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelWriter.Log.ParentFolderCreated", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelWriter.Log.ParentFolderNotExistCreateIt", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder), HopVfs.getFriendlyURI((String)filename)}));
            }
            finally {
                if (parentfolder != null) {
                    try {
                        parentfolder.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void closeOutputFile() throws HopException {
        try (BufferedOutputStreamWithCloseDetection out = new BufferedOutputStreamWithCloseDetection(HopVfs.getOutputStream((FileObject)((ExcelWriterTransformData)this.data).file, (boolean)false));){
            if (((ExcelWriterTransformMeta)this.meta).isFooterEnabled()) {
                this.writeHeader();
            }
            if (((ExcelWriterTransformMeta)this.meta).getFile().isAutosizecolums()) {
                if (((ExcelWriterTransformData)this.data).sheet instanceof SXSSFSheet) {
                    ((SXSSFSheet)((ExcelWriterTransformData)this.data).sheet).trackAllColumnsForAutoSizing();
                }
                if (((ExcelWriterTransformMeta)this.meta).getOutputFields() == null || ((ExcelWriterTransformMeta)this.meta).getOutputFields().isEmpty()) {
                    for (int i = 0; i < ((ExcelWriterTransformData)this.data).inputRowMeta.size(); ++i) {
                        ((ExcelWriterTransformData)this.data).sheet.autoSizeColumn(i + ((ExcelWriterTransformData)this.data).startingCol);
                    }
                } else {
                    for (int i = 0; i < ((ExcelWriterTransformMeta)this.meta).getOutputFields().size(); ++i) {
                        ((ExcelWriterTransformData)this.data).sheet.autoSizeColumn(i + ((ExcelWriterTransformData)this.data).startingCol);
                    }
                }
            }
            if (((ExcelWriterTransformMeta)this.meta).isForceFormulaRecalculation()) {
                this.recalculateAllWorkbookFormulas();
            }
            ((ExcelWriterTransformData)this.data).wb.write((OutputStream)out);
        }
        catch (IOException e) {
            throw new HopException((Throwable)e);
        }
    }

    void recalculateAllWorkbookFormulas() {
        if (((ExcelWriterTransformData)this.data).wb instanceof XSSFWorkbook) {
            FormulaEvaluator evaluator = ((ExcelWriterTransformData)this.data).wb.getCreationHelper().createFormulaEvaluator();
            for (int sheetNum = 0; sheetNum < ((ExcelWriterTransformData)this.data).wb.getNumberOfSheets(); ++sheetNum) {
                Sheet sheet = ((ExcelWriterTransformData)this.data).wb.getSheetAt(sheetNum);
                for (Row r : sheet) {
                    for (Cell c : r) {
                        if (c.getCellType() != CellType.FORMULA) continue;
                        evaluator.evaluateFormulaCell(c);
                    }
                }
            }
        } else if (((ExcelWriterTransformData)this.data).wb instanceof HSSFWorkbook) {
            for (int sheetNum = 0; sheetNum < ((ExcelWriterTransformData)this.data).wb.getNumberOfSheets(); ++sheetNum) {
                HSSFSheet sheet = ((HSSFWorkbook)((ExcelWriterTransformData)this.data).wb).getSheetAt(sheetNum);
                sheet.setForceFormulaRecalculation(true);
            }
        } else {
            String forceRecalc = this.getVariable(STREAMER_FORCE_RECALC_PROP_NAME, "N");
            if ("Y".equals(forceRecalc)) {
                ((ExcelWriterTransformData)this.data).wb.setForceFormulaRecalculation(true);
            }
        }
    }

    public void writeNextLine(Object[] r) throws HopException {
        try {
            this.openLine();
            Row xlsRow = ((ExcelWriterTransformData)this.data).sheet.getRow(((ExcelWriterTransformData)this.data).posY);
            if (xlsRow == null) {
                xlsRow = ((ExcelWriterTransformData)this.data).sheet.createRow(((ExcelWriterTransformData)this.data).posY);
            }
            Object v = null;
            if (((ExcelWriterTransformMeta)this.meta).getOutputFields() == null || ((ExcelWriterTransformMeta)this.meta).getOutputFields().isEmpty()) {
                int nr = ((ExcelWriterTransformData)this.data).inputRowMeta.size();
                ((ExcelWriterTransformData)this.data).clearStyleCache(nr);
                ((ExcelWriterTransformData)this.data).linkfieldnrs = new int[nr];
                ((ExcelWriterTransformData)this.data).commentfieldnrs = new int[nr];
                for (int i = 0; i < nr; ++i) {
                    v = r[i];
                    this.writeField(v, ((ExcelWriterTransformData)this.data).inputRowMeta.getValueMeta(i), null, xlsRow, ((ExcelWriterTransformData)this.data).posX++, r, i, false);
                }
                ((ExcelWriterTransformData)this.data).posX = ((ExcelWriterTransformData)this.data).startingCol;
                ++((ExcelWriterTransformData)this.data).posY;
            } else {
                for (int i = 0; i < ((ExcelWriterTransformMeta)this.meta).getOutputFields().size(); ++i) {
                    v = r[((ExcelWriterTransformData)this.data).fieldnrs[i]];
                    ExcelWriterOutputField field = ((ExcelWriterTransformMeta)this.meta).getOutputFields().get(i);
                    this.writeField(v, ((ExcelWriterTransformData)this.data).inputRowMeta.getValueMeta(((ExcelWriterTransformData)this.data).fieldnrs[i]), field, xlsRow, ((ExcelWriterTransformData)this.data).posX++, r, i, false);
                }
                ((ExcelWriterTransformData)this.data).posX = ((ExcelWriterTransformData)this.data).startingCol;
                ++((ExcelWriterTransformData)this.data).posY;
            }
        }
        catch (Exception e) {
            this.logError("Error writing line :" + e.toString());
            throw new HopException((Throwable)e);
        }
    }

    private Comment createCellComment(String author, String comment) {
        if (((ExcelWriterTransformData)this.data).sheet instanceof XSSFSheet) {
            CreationHelper factory = ((ExcelWriterTransformData)this.data).wb.getCreationHelper();
            Drawing drawing = ((ExcelWriterTransformData)this.data).sheet.createDrawingPatriarch();
            ClientAnchor anchor = factory.createClientAnchor();
            Comment cmt = drawing.createCellComment(anchor);
            RichTextString str = factory.createRichTextString(comment);
            cmt.setString(str);
            cmt.setAuthor(author);
            return cmt;
        }
        return null;
    }

    private Cell getCellFromReference(String reference) {
        CellReference cellRef = new CellReference(reference);
        String sheetName = cellRef.getSheetName();
        Sheet sheet = ((ExcelWriterTransformData)this.data).sheet;
        if (!Utils.isEmpty((CharSequence)sheetName)) {
            sheet = ((ExcelWriterTransformData)this.data).wb.getSheet(sheetName);
        }
        if (sheet == null) {
            return null;
        }
        Row xlsRow = sheet.getRow(cellRef.getRow());
        if (xlsRow == null) {
            return null;
        }
        return xlsRow.getCell((int)cellRef.getCol());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeField(Object v, IValueMeta vMeta, ExcelWriterOutputField excelField, Row xlsRow, int posX, Object[] row, int fieldNr, boolean isTitle) throws HopException {
        try {
            String comment;
            String link;
            boolean cellExisted = true;
            Cell cell = xlsRow.getCell(posX);
            if (cell == null) {
                cellExisted = false;
                cell = xlsRow.createCell(posX);
            }
            if (!cellExisted || !((ExcelWriterTransformMeta)this.meta).isLeaveExistingStylesUnchanged()) {
                if (!isTitle && ((ExcelWriterTransformData)this.data).getCachedStyle(fieldNr) != null) {
                    cell.setCellStyle(((ExcelWriterTransformData)this.data).getCachedStyle(fieldNr));
                } else {
                    if (excelField != null) {
                        Cell styleCell;
                        String styleRef = null;
                        if (!isTitle && !Utils.isEmpty((CharSequence)excelField.getStyleCell())) {
                            styleRef = excelField.getStyleCell();
                        } else if (isTitle && !Utils.isEmpty((CharSequence)excelField.getTitleStyleCell())) {
                            styleRef = excelField.getTitleStyleCell();
                        }
                        if (styleRef != null && (styleCell = this.getCellFromReference(styleRef)) != null && cell != styleCell) {
                            cell.setCellStyle(styleCell.getCellStyle());
                        }
                    }
                    if (!(isTitle || excelField == null || Utils.isEmpty((CharSequence)excelField.getFormat()) || excelField.getFormat().startsWith("Image"))) {
                        this.setDataFormat(excelField.getFormat(), cell);
                    }
                    if (!isTitle) {
                        ((ExcelWriterTransformData)this.data).cacheStyle(fieldNr, cell.getCellStyle());
                    }
                }
            }
            if (!isTitle && excelField != null && ((ExcelWriterTransformData)this.data).linkfieldnrs[fieldNr] >= 0 && !Utils.isEmpty((CharSequence)(link = ((ExcelWriterTransformData)this.data).inputRowMeta.getValueMeta(((ExcelWriterTransformData)this.data).linkfieldnrs[fieldNr]).getString(row[((ExcelWriterTransformData)this.data).linkfieldnrs[fieldNr]])))) {
                CreationHelper ch = ((ExcelWriterTransformData)this.data).wb.getCreationHelper();
                Hyperlink hyperLink = null;
                if (link.startsWith("http:") || link.startsWith("https:") || link.startsWith("ftp:")) {
                    hyperLink = ch.createHyperlink(HyperlinkType.URL);
                    hyperLink.setLabel("URL Link");
                } else if (link.startsWith("mailto:")) {
                    hyperLink = ch.createHyperlink(HyperlinkType.EMAIL);
                    hyperLink.setLabel("Email Link");
                } else if (link.startsWith("'")) {
                    hyperLink = ch.createHyperlink(HyperlinkType.DOCUMENT);
                    hyperLink.setLabel("Link within this document");
                } else {
                    hyperLink = ch.createHyperlink(HyperlinkType.FILE);
                    hyperLink.setLabel("Link to a file");
                }
                hyperLink.setAddress(link);
                cell.setHyperlink(hyperLink);
                if (!cellExisted || !((ExcelWriterTransformMeta)this.meta).isLeaveExistingStylesUnchanged()) {
                    if (((ExcelWriterTransformData)this.data).getCachedLinkStyle(fieldNr) != null) {
                        cell.setCellStyle(((ExcelWriterTransformData)this.data).getCachedLinkStyle(fieldNr));
                    } else {
                        Font origFont = ((ExcelWriterTransformData)this.data).wb.getFontAt(cell.getCellStyle().getFontIndex());
                        Font hlinkFont = ((ExcelWriterTransformData)this.data).wb.createFont();
                        hlinkFont.setBold(origFont.getBold());
                        hlinkFont.setCharSet(origFont.getCharSet());
                        hlinkFont.setFontHeight(origFont.getFontHeight());
                        hlinkFont.setFontName(origFont.getFontName());
                        hlinkFont.setItalic(origFont.getItalic());
                        hlinkFont.setStrikeout(origFont.getStrikeout());
                        hlinkFont.setTypeOffset(origFont.getTypeOffset());
                        hlinkFont.setUnderline((byte)1);
                        hlinkFont.setColor(IndexedColors.BLUE.getIndex());
                        CellStyle style = cell.getCellStyle();
                        style.setFont(hlinkFont);
                        cell.setCellStyle(style);
                        ((ExcelWriterTransformData)this.data).cacheLinkStyle(fieldNr, cell.getCellStyle());
                    }
                }
            }
            if (!isTitle && excelField != null && ((ExcelWriterTransformData)this.data).commentfieldnrs[fieldNr] >= 0 && ((ExcelWriterTransformData)this.data).wb instanceof XSSFWorkbook && !Utils.isEmpty((CharSequence)(comment = ((ExcelWriterTransformData)this.data).inputRowMeta.getValueMeta(((ExcelWriterTransformData)this.data).commentfieldnrs[fieldNr]).getString(row[((ExcelWriterTransformData)this.data).commentfieldnrs[fieldNr]])))) {
                String author = ((ExcelWriterTransformData)this.data).commentauthorfieldnrs[fieldNr] >= 0 ? ((ExcelWriterTransformData)this.data).inputRowMeta.getValueMeta(((ExcelWriterTransformData)this.data).commentauthorfieldnrs[fieldNr]).getString(row[((ExcelWriterTransformData)this.data).commentauthorfieldnrs[fieldNr]]) : "Apache Hop";
                cell.setCellComment(this.createCellComment(author, comment));
            }
            if (!isTitle && excelField != null && excelField.isFormula()) {
                cell.setCellFormula(vMeta.getString(v));
                return;
            } else {
                switch (vMeta.getType()) {
                    case 3: {
                        if (v == null || vMeta.getDate(v) == null) return;
                        cell.setCellValue(vMeta.getDate(v));
                        return;
                    }
                    case 4: {
                        if (v == null) return;
                        cell.setCellValue(vMeta.getBoolean(v).booleanValue());
                        return;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        if (v == null) return;
                        cell.setCellValue(vMeta.getNumber(v).doubleValue());
                        return;
                    }
                    default: {
                        if (v == null) return;
                        cell.setCellValue(vMeta.getString(v));
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            this.logError("Error writing field (" + ((ExcelWriterTransformData)this.data).posX + "," + ((ExcelWriterTransformData)this.data).posY + ") : " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            throw new HopException((Throwable)e);
        }
    }

    private void setDataFormat(String excelFieldFormat, Cell cell) {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Log.SetDataFormat", (Object[])new Object[]{excelFieldFormat, CellReference.convertNumToColString((int)cell.getColumnIndex()), cell.getRowIndex()}));
        }
        DataFormat format = ((ExcelWriterTransformData)this.data).wb.createDataFormat();
        short formatIndex = format.getFormat(excelFieldFormat);
        CellStyle style = ((ExcelWriterTransformData)this.data).wb.createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());
        style.setDataFormat(formatIndex);
        cell.setCellStyle(style);
    }

    public String buildFilename(IRowMeta rowMeta, Object[] row) {
        return ((ExcelWriterTransformMeta)this.meta).buildFilename(rowMeta, row, (IVariables)this);
    }

    public String buildFilename(int splitNr) {
        return ((ExcelWriterTransformMeta)this.meta).buildFilename((IVariables)this, this.getCopy(), splitNr);
    }

    public static void copyFile(FileObject in, FileObject out) throws HopException {
        try (BufferedInputStream fis = new BufferedInputStream(HopVfs.getInputStream((FileObject)in));
             BufferedOutputStream fos = new BufferedOutputStream(HopVfs.getOutputStream((FileObject)out, (boolean)false));){
            byte[] buf = new byte[0x100000];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareNextOutputFile(Object[] row) throws HopException {
        try {
            int numOfFields;
            if (((ExcelWriterTransformData)this.data).realSheetname != null && ((ExcelWriterTransformData)this.data).realSheetname.length() > 31) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Exception.MaxSheetName", (String[])new String[]{((ExcelWriterTransformData)this.data).realSheetname}));
            }
            int n = numOfFields = ((ExcelWriterTransformMeta)this.meta).getOutputFields() != null && ((ExcelWriterTransformMeta)this.meta).getOutputFields().size() > 0 ? ((ExcelWriterTransformMeta)this.meta).getOutputFields().size() : 0;
            if (numOfFields == 0) {
                numOfFields = ((ExcelWriterTransformData)this.data).inputRowMeta != null ? ((ExcelWriterTransformData)this.data).inputRowMeta.size() : 0;
            }
            ((ExcelWriterTransformData)this.data).clearStyleCache(numOfFields);
            String buildFilename = !((ExcelWriterTransformMeta)this.meta).getFile().isFileNameInField() ? this.buildFilename(((ExcelWriterTransformData)this.data).splitnr) : this.buildFilename(((ExcelWriterTransformData)this.data).inputRowMeta, row);
            ((ExcelWriterTransformData)this.data).file = HopVfs.getFileObject((String)buildFilename);
            if (!HopVfs.getFileObject((String)buildFilename).getParent().exists() && ((ExcelWriterTransformMeta)this.meta).getFile().isCreateParentFolder()) {
                this.logDebug("Create parent directory for " + buildFilename + " because it does not exist.");
                this.createParentFolder(buildFilename);
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Log.OpeningFile", (String[])new String[]{buildFilename}));
            }
            if (((ExcelWriterTransformData)this.data).file.exists() && ((ExcelWriterTransformData)this.data).createNewFile && !((ExcelWriterTransformData)this.data).file.delete()) {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Log.CouldNotDeleteStaleFile", (String[])new String[]{buildFilename}));
                }
                this.setErrors(1L);
                throw new HopException("Could not delete stale file " + buildFilename);
            }
            if (((ExcelWriterTransformMeta)this.meta).isAddToResultFilenames()) {
                ResultFile resultFile = new ResultFile(0, ((ExcelWriterTransformData)this.data).file, this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment("This file was created with an Excel writer transform by Hop : The Hop Orchestration Platform");
                this.addResultFile(resultFile);
            }
            boolean appendingToSheet = true;
            if (!((ExcelWriterTransformData)this.data).file.exists()) {
                block35: {
                    if (((ExcelWriterTransformMeta)this.meta).getTemplate().isTemplateEnabled()) {
                        String templateExt = HopVfs.getFileObject((String)((ExcelWriterTransformData)this.data).realTemplateFileName).getName().getExtension();
                        if (!((ExcelWriterTransformMeta)this.meta).getFile().getExtension().equalsIgnoreCase(templateExt)) {
                            throw new HopException("Template Format Mismatch: Template has extension: " + templateExt + ", but output file has extension: " + ((ExcelWriterTransformMeta)this.meta).getFile().getExtension() + ". Template and output file must share the same format!");
                        }
                        if (HopVfs.getFileObject((String)((ExcelWriterTransformData)this.data).realTemplateFileName).exists()) {
                            ExcelWriterTransform.copyFile(HopVfs.getFileObject((String)((ExcelWriterTransformData)this.data).realTemplateFileName), ((ExcelWriterTransformData)this.data).file);
                            break block35;
                        } else {
                            if (this.log.isBasic()) {
                                this.logBasic(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Log.TemplateMissing", (String[])new String[]{((ExcelWriterTransformData)this.data).realTemplateFileName}));
                            }
                            this.setErrors(1L);
                            throw new HopException("Template file missing: " + ((ExcelWriterTransformData)this.data).realTemplateFileName);
                        }
                    }
                    XSSFWorkbook wb = ((ExcelWriterTransformMeta)this.meta).getFile().getExtension().equalsIgnoreCase("xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
                    BufferedOutputStreamWithCloseDetection out = new BufferedOutputStreamWithCloseDetection(HopVfs.getOutputStream((FileObject)((ExcelWriterTransformData)this.data).file, (boolean)false));
                    wb.createSheet(((ExcelWriterTransformData)this.data).realSheetname);
                    wb.write((OutputStream)out);
                    out.close();
                    wb.close();
                }
                appendingToSheet = false;
            }
            if (((ExcelWriterTransformMeta)this.meta).getFile().getExtension().equalsIgnoreCase("xlsx")) {
                XSSFWorkbook xssfWorkbook = new XSSFWorkbook(HopVfs.getInputStream((FileObject)((ExcelWriterTransformData)this.data).file));
                ((ExcelWriterTransformData)this.data).wb = ((ExcelWriterTransformMeta)this.meta).getFile().isStreamingData() && !((ExcelWriterTransformMeta)this.meta).getTemplate().isTemplateEnabled() ? new SXSSFWorkbook(xssfWorkbook, 100) : xssfWorkbook;
            } else {
                ((ExcelWriterTransformData)this.data).wb = new HSSFWorkbook(HopVfs.getInputStream((FileObject)((ExcelWriterTransformData)this.data).file));
            }
            int existingActiveSheetIndex = ((ExcelWriterTransformData)this.data).wb.getActiveSheetIndex();
            int replacingSheetAt = -1;
            if (((ExcelWriterTransformData)this.data).wb.getSheet(((ExcelWriterTransformData)this.data).realSheetname) != null && ((ExcelWriterTransformData)this.data).createNewSheet) {
                replacingSheetAt = ((ExcelWriterTransformData)this.data).wb.getSheetIndex(((ExcelWriterTransformData)this.data).wb.getSheet(((ExcelWriterTransformData)this.data).realSheetname));
                ((ExcelWriterTransformData)this.data).wb.removeSheetAt(replacingSheetAt);
            }
            if (((ExcelWriterTransformData)this.data).wb.getSheet(((ExcelWriterTransformData)this.data).realSheetname) == null) {
                if (((ExcelWriterTransformMeta)this.meta).getTemplate().isTemplateSheetEnabled()) {
                    Sheet ts = ((ExcelWriterTransformData)this.data).wb.getSheet(((ExcelWriterTransformData)this.data).realTemplateSheetName);
                    if (ts == null) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Exception.TemplateNotFound", (String[])new String[]{((ExcelWriterTransformData)this.data).realTemplateSheetName}));
                    }
                    ((ExcelWriterTransformData)this.data).sheet = ((ExcelWriterTransformData)this.data).wb.cloneSheet(((ExcelWriterTransformData)this.data).wb.getSheetIndex(ts));
                    ((ExcelWriterTransformData)this.data).wb.setSheetName(((ExcelWriterTransformData)this.data).wb.getSheetIndex(((ExcelWriterTransformData)this.data).sheet), ((ExcelWriterTransformData)this.data).realSheetname);
                    ((ExcelWriterTransformData)this.data).wb.setSheetHidden(((ExcelWriterTransformData)this.data).wb.getSheetIndex(((ExcelWriterTransformData)this.data).sheet), false);
                    if (((ExcelWriterTransformMeta)this.meta).getTemplate().isTemplateSheetHidden()) {
                        ((ExcelWriterTransformData)this.data).wb.setSheetHidden(((ExcelWriterTransformData)this.data).wb.getSheetIndex(ts), true);
                    }
                } else {
                    ((ExcelWriterTransformData)this.data).sheet = ((ExcelWriterTransformData)this.data).wb.createSheet(((ExcelWriterTransformData)this.data).realSheetname);
                }
                if (replacingSheetAt > -1) {
                    ((ExcelWriterTransformData)this.data).wb.setSheetOrder(((ExcelWriterTransformData)this.data).sheet.getSheetName(), replacingSheetAt);
                }
                ((ExcelWriterTransformData)this.data).wb.setActiveSheet(existingActiveSheetIndex);
                ((ExcelWriterTransformData)this.data).wb.setSelectedTab(existingActiveSheetIndex);
                appendingToSheet = false;
            } else {
                ((ExcelWriterTransformData)this.data).sheet = ((ExcelWriterTransformData)this.data).wb.getSheet(((ExcelWriterTransformData)this.data).realSheetname);
            }
            if (((ExcelWriterTransformMeta)this.meta).isMakeSheetActive()) {
                int sheetIndex = ((ExcelWriterTransformData)this.data).wb.getSheetIndex(((ExcelWriterTransformData)this.data).sheet);
                ((ExcelWriterTransformData)this.data).wb.setActiveSheet(sheetIndex);
                ((ExcelWriterTransformData)this.data).wb.setSelectedTab(sheetIndex);
            }
            if (((ExcelWriterTransformMeta)this.meta).getFile().isProtectsheet()) {
                this.protectSheet(((ExcelWriterTransformData)this.data).sheet, ((ExcelWriterTransformData)this.data).realPassword);
            }
            if (!Utils.isEmpty((CharSequence)((ExcelWriterTransformData)this.data).realStartingCell)) {
                CellReference cellRef = new CellReference(((ExcelWriterTransformData)this.data).realStartingCell);
                ((ExcelWriterTransformData)this.data).startingRow = cellRef.getRow();
                ((ExcelWriterTransformData)this.data).startingCol = cellRef.getCol();
            } else {
                ((ExcelWriterTransformData)this.data).startingRow = 0;
                ((ExcelWriterTransformData)this.data).startingCol = 0;
            }
            ((ExcelWriterTransformData)this.data).posX = ((ExcelWriterTransformData)this.data).startingCol;
            ((ExcelWriterTransformData)this.data).posY = ((ExcelWriterTransformData)this.data).startingRow;
            if (!((ExcelWriterTransformData)this.data).createNewSheet && ((ExcelWriterTransformMeta)this.meta).isAppendLines() && appendingToSheet) {
                ((ExcelWriterTransformData)this.data).posY = ((ExcelWriterTransformData)this.data).sheet.getPhysicalNumberOfRows() > 0 ? ((ExcelWriterTransformData)this.data).sheet.getLastRowNum() + 1 : 0;
            }
            if (!((ExcelWriterTransformData)this.data).createNewSheet && ((ExcelWriterTransformMeta)this.meta).getAppendOffset() != 0 && appendingToSheet) {
                ((ExcelWriterTransformData)this.data).posY += ((ExcelWriterTransformMeta)this.meta).getAppendOffset();
            }
            if (!((ExcelWriterTransformData)this.data).createNewSheet && ((ExcelWriterTransformMeta)this.meta).getAppendEmpty() > 0 && appendingToSheet) {
                for (int i = 0; i < ((ExcelWriterTransformMeta)this.meta).getAppendEmpty(); ++i) {
                    this.openLine();
                    if (((ExcelWriterTransformData)this.data).shiftExistingCells && !((ExcelWriterTransformMeta)this.meta).isAppendLines()) continue;
                    ++((ExcelWriterTransformData)this.data).posY;
                }
            }
            if (((ExcelWriterTransformMeta)this.meta).isHeaderEnabled() && (((ExcelWriterTransformData)this.data).createNewSheet || !((ExcelWriterTransformMeta)this.meta).isAppendOmitHeader() || !appendingToSheet)) {
                this.writeHeader();
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Log.FileOpened", (String[])new String[]{buildFilename}));
            }
            ++((ExcelWriterTransformData)this.data).splitnr;
            return;
        }
        catch (Exception e) {
            this.logError("Error opening new file", e);
            this.setErrors(1L);
            throw new HopException((Throwable)e);
        }
    }

    private void openLine() {
        if (((ExcelWriterTransformData)this.data).shiftExistingCells) {
            ((ExcelWriterTransformData)this.data).sheet.shiftRows(((ExcelWriterTransformData)this.data).posY, Math.max(((ExcelWriterTransformData)this.data).posY, ((ExcelWriterTransformData)this.data).sheet.getLastRowNum()), 1);
        }
    }

    private void writeHeader() throws HopException {
        try {
            this.openLine();
            Row xlsRow = ((ExcelWriterTransformData)this.data).sheet.getRow(((ExcelWriterTransformData)this.data).posY);
            if (xlsRow == null) {
                xlsRow = ((ExcelWriterTransformData)this.data).sheet.createRow(((ExcelWriterTransformData)this.data).posY);
            }
            int posX = ((ExcelWriterTransformData)this.data).posX;
            if (((ExcelWriterTransformMeta)this.meta).getOutputFields() != null && !((ExcelWriterTransformMeta)this.meta).getOutputFields().isEmpty()) {
                for (int i = 0; i < ((ExcelWriterTransformMeta)this.meta).getOutputFields().size(); ++i) {
                    ExcelWriterOutputField field = ((ExcelWriterTransformMeta)this.meta).getOutputFields().get(i);
                    String fieldName = !Utils.isEmpty((CharSequence)field.getTitle()) ? field.getTitle() : field.getName();
                    ValueMetaString vMeta = new ValueMetaString(fieldName);
                    this.writeField(fieldName, (IValueMeta)vMeta, field, xlsRow, posX++, null, -1, true);
                }
            } else if (((ExcelWriterTransformData)this.data).inputRowMeta != null) {
                for (int i = 0; i < ((ExcelWriterTransformData)this.data).inputRowMeta.size(); ++i) {
                    String fieldName = ((ExcelWriterTransformData)this.data).inputRowMeta.getFieldNames()[i];
                    ValueMetaString vMeta = new ValueMetaString(fieldName);
                    this.writeField(fieldName, (IValueMeta)vMeta, null, xlsRow, posX++, null, -1, true);
                }
            }
            ++((ExcelWriterTransformData)this.data).posY;
            this.incrementLinesOutput();
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public boolean init() {
        if (super.init()) {
            ((ExcelWriterTransformData)this.data).splitnr = 0;
            ((ExcelWriterTransformData)this.data).datalines = 0;
            ((ExcelWriterTransformData)this.data).realSheetname = this.resolve(((ExcelWriterTransformMeta)this.meta).getFile().getSheetname());
            ((ExcelWriterTransformData)this.data).realTemplateSheetName = this.resolve(((ExcelWriterTransformMeta)this.meta).getTemplate().getTemplateSheetName());
            ((ExcelWriterTransformData)this.data).realTemplateFileName = this.resolve(((ExcelWriterTransformMeta)this.meta).getTemplate().getTemplateFileName());
            ((ExcelWriterTransformData)this.data).realStartingCell = this.resolve(((ExcelWriterTransformMeta)this.meta).getStartingCell());
            ((ExcelWriterTransformData)this.data).realPassword = Utils.resolvePassword((IVariables)this.variables, (String)((ExcelWriterTransformMeta)this.meta).getFile().getPassword());
            ((ExcelWriterTransformData)this.data).realProtectedBy = this.resolve(((ExcelWriterTransformMeta)this.meta).getFile().getProtectedBy());
            ((ExcelWriterTransformData)this.data).shiftExistingCells = "push".equals(((ExcelWriterTransformMeta)this.meta).getRowWritingMethod());
            ((ExcelWriterTransformData)this.data).createNewSheet = "new".equals(((ExcelWriterTransformMeta)this.meta).getFile().getIfSheetExists());
            ((ExcelWriterTransformData)this.data).createNewFile = "new".equals(((ExcelWriterTransformMeta)this.meta).getFile().getIfFileExists());
            return true;
        }
        return false;
    }

    public void dispose() {
        this.clearWorkbookMem();
        super.dispose();
    }

    protected void protectSheet(Sheet sheet, String password) {
        if (sheet instanceof HSSFSheet) {
            sheet.protectSheet(password);
        }
    }
}

