/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.eventhubs.listen;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.row.value.ValueMetaTimestamp;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListener;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListenerData;
import org.w3c.dom.Node;

@Transform(id="AzureListener", name="i18n::AzureListenerMeta.name", description="i18n::AzureListenerMeta.description", image="event-hubs-listener.svg", categoryDescription="i18n::AzureListenerMeta.categoryDescription", keywords={"i18n::AzureListenerMeta.keyword"}, documentationUrl="/pipeline/transforms/azure-event-hubs-listener.html")
public class AzureListenerMeta
extends BaseTransformMeta<AzureListener, AzureListenerData> {
    public static final String NAMESPACE = "namespace";
    public static final String EVENT_HUB_NAME = "event_hub_name";
    public static final String SAS_KEY_NAME = "sas_key_name";
    public static final String SAS_KEY = "sas_key";
    public static final String BATCH_SIZE = "batch_size";
    public static final String PREFETCH_SIZE = "prefetch_size";
    public static final String OUTPUT_FIELD = "output_field";
    public static final String PARTITION_ID_FIELD = "partition_id_field";
    public static final String OFFSET_FIELD = "offset_field";
    public static final String SEQUENCE_NUMBER_FIELD = "sequence_number_field";
    public static final String HOST_FIELD = "host_field";
    public static final String ENQUEUED_TIME_FIELD = "enqueued_time_field";
    public static final String BATCH_TRANSFORMATION = "batch_transformation";
    public static final String BATCH_INPUT_Transform = "batch_input_Transform";
    public static final String BATCH_OUTPUT_Transform = "batch_output_Transform";
    public static final String BATCH_MAX_WAIT_TIME = "batch_max_wait_time";
    public static final String CONSUMER_GROUP_NAME = "consumer_group_name";
    public static final String EVENT_HUB_CONNECTION_STRING = "event_hub_connection_string";
    public static final String STORAGE_CONNECTION_STRING = "storage_connection_string";
    public static final String STORAGE_CONTAINER_NAME = "storage_container_name";
    private String namespace;
    private String eventHubName;
    private String sasKeyName;
    private String sasKey;
    private String consumerGroupName;
    private String storageConnectionString;
    private String storageContainerName;
    private String prefetchSize;
    private String batchSize;
    private String outputField;
    private String partitionIdField;
    private String offsetField;
    private String sequenceNumberField;
    private String hostField;
    private String enqueuedTimeField;
    private String batchPipeline;
    private String batchInputTransform;
    private String batchOutputTransform;
    private String batchMaxWaitTime;

    public void setDefault() {
        this.consumerGroupName = "$Default";
        this.outputField = "message";
        this.partitionIdField = "partitionId";
        this.offsetField = "offset";
        this.sequenceNumberField = "sequenceNumber";
        this.hostField = "host";
        this.enqueuedTimeField = "enqueuedTime";
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (StringUtils.isNotEmpty((String)this.batchPipeline) && StringUtils.isNotEmpty((String)this.batchInputTransform)) {
            try {
                PipelineMeta batchTransMeta = AzureListenerMeta.loadBatchPipelineMeta(this, metadataProvider, variables);
                IRowMeta transformFields = batchTransMeta.getTransformFields(variables, variables.resolve(this.batchOutputTransform));
                rowMeta.clear();
                rowMeta.addRowMeta(transformFields);
                return;
            }
            catch (Exception e) {
                throw new HopTransformException("Unable to get fields from batch pipeline Transform " + this.batchOutputTransform, (Throwable)e);
            }
        }
        this.getRegularRowMeta(rowMeta, variables);
    }

    public void getRegularRowMeta(IRowMeta rowMeta, IVariables variables) {
        String enqueuedTimeFieldName;
        String hostFieldName;
        String sequenceNumberFieldName;
        String offsetFieldName;
        String partitionIdFieldName;
        String outputFieldName = variables.resolve(this.outputField);
        if (StringUtils.isNotEmpty((String)outputFieldName)) {
            ValueMetaString outputValueMeta = new ValueMetaString(outputFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
        if (StringUtils.isNotEmpty((String)(partitionIdFieldName = variables.resolve(this.partitionIdField)))) {
            ValueMetaString outputValueMeta = new ValueMetaString(partitionIdFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
        if (StringUtils.isNotEmpty((String)(offsetFieldName = variables.resolve(this.offsetField)))) {
            ValueMetaString outputValueMeta = new ValueMetaString(offsetFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
        if (StringUtils.isNotEmpty((String)(sequenceNumberFieldName = variables.resolve(this.sequenceNumberField)))) {
            ValueMetaInteger outputValueMeta = new ValueMetaInteger(sequenceNumberFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
        if (StringUtils.isNotEmpty((String)(hostFieldName = variables.resolve(this.hostField)))) {
            ValueMetaString outputValueMeta = new ValueMetaString(hostFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
        if (StringUtils.isNotEmpty((String)(enqueuedTimeFieldName = variables.resolve(this.enqueuedTimeField)))) {
            ValueMetaTimestamp outputValueMeta = new ValueMetaTimestamp(enqueuedTimeFieldName);
            rowMeta.addValueMeta((IValueMeta)outputValueMeta);
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.addTagValue((String)NAMESPACE, (String)this.namespace));
        xml.append(XmlHandler.addTagValue((String)EVENT_HUB_NAME, (String)this.eventHubName));
        xml.append(XmlHandler.addTagValue((String)SAS_KEY_NAME, (String)this.sasKeyName));
        xml.append(XmlHandler.addTagValue((String)SAS_KEY, (String)Encr.encryptPasswordIfNotUsingVariables((String)this.sasKey)));
        xml.append(XmlHandler.addTagValue((String)BATCH_SIZE, (String)this.batchSize));
        xml.append(XmlHandler.addTagValue((String)PREFETCH_SIZE, (String)this.prefetchSize));
        xml.append(XmlHandler.addTagValue((String)OUTPUT_FIELD, (String)this.outputField));
        xml.append(XmlHandler.addTagValue((String)PARTITION_ID_FIELD, (String)this.partitionIdField));
        xml.append(XmlHandler.addTagValue((String)OFFSET_FIELD, (String)this.offsetField));
        xml.append(XmlHandler.addTagValue((String)SEQUENCE_NUMBER_FIELD, (String)this.sequenceNumberField));
        xml.append(XmlHandler.addTagValue((String)HOST_FIELD, (String)this.hostField));
        xml.append(XmlHandler.addTagValue((String)ENQUEUED_TIME_FIELD, (String)this.enqueuedTimeField));
        xml.append(XmlHandler.addTagValue((String)CONSUMER_GROUP_NAME, (String)this.consumerGroupName));
        xml.append(XmlHandler.addTagValue((String)STORAGE_CONNECTION_STRING, (String)this.storageConnectionString));
        xml.append(XmlHandler.addTagValue((String)STORAGE_CONTAINER_NAME, (String)this.storageContainerName));
        xml.append(XmlHandler.addTagValue((String)BATCH_TRANSFORMATION, (String)this.batchPipeline));
        xml.append(XmlHandler.addTagValue((String)BATCH_INPUT_Transform, (String)this.batchInputTransform));
        xml.append(XmlHandler.addTagValue((String)BATCH_OUTPUT_Transform, (String)this.batchOutputTransform));
        xml.append(XmlHandler.addTagValue((String)BATCH_MAX_WAIT_TIME, (String)this.batchMaxWaitTime));
        return xml.toString();
    }

    public void loadXml(Node Transformnode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.namespace = XmlHandler.getTagValue((Node)Transformnode, (String)NAMESPACE);
        this.eventHubName = XmlHandler.getTagValue((Node)Transformnode, (String)EVENT_HUB_NAME);
        this.sasKeyName = XmlHandler.getTagValue((Node)Transformnode, (String)SAS_KEY_NAME);
        this.sasKey = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)Transformnode, (String)SAS_KEY));
        this.batchSize = XmlHandler.getTagValue((Node)Transformnode, (String)BATCH_SIZE);
        this.prefetchSize = XmlHandler.getTagValue((Node)Transformnode, (String)PREFETCH_SIZE);
        this.outputField = XmlHandler.getTagValue((Node)Transformnode, (String)OUTPUT_FIELD);
        this.partitionIdField = XmlHandler.getTagValue((Node)Transformnode, (String)PARTITION_ID_FIELD);
        this.offsetField = XmlHandler.getTagValue((Node)Transformnode, (String)OFFSET_FIELD);
        this.sequenceNumberField = XmlHandler.getTagValue((Node)Transformnode, (String)SEQUENCE_NUMBER_FIELD);
        this.hostField = XmlHandler.getTagValue((Node)Transformnode, (String)HOST_FIELD);
        this.enqueuedTimeField = XmlHandler.getTagValue((Node)Transformnode, (String)ENQUEUED_TIME_FIELD);
        this.consumerGroupName = XmlHandler.getTagValue((Node)Transformnode, (String)CONSUMER_GROUP_NAME);
        this.storageConnectionString = XmlHandler.getTagValue((Node)Transformnode, (String)STORAGE_CONNECTION_STRING);
        this.storageContainerName = XmlHandler.getTagValue((Node)Transformnode, (String)STORAGE_CONTAINER_NAME);
        this.batchPipeline = XmlHandler.getTagValue((Node)Transformnode, (String)BATCH_TRANSFORMATION);
        this.batchInputTransform = XmlHandler.getTagValue((Node)Transformnode, (String)BATCH_INPUT_Transform);
        this.batchOutputTransform = XmlHandler.getTagValue((Node)Transformnode, (String)BATCH_OUTPUT_Transform);
        this.batchMaxWaitTime = XmlHandler.getTagValue((Node)Transformnode, (String)BATCH_MAX_WAIT_TIME);
        super.loadXml(Transformnode, metadataProvider);
    }

    public static final synchronized PipelineMeta loadBatchPipelineMeta(AzureListenerMeta azureListenerMeta, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        PipelineMeta batchPipelineMeta;
        String realFilename = variables.resolve(azureListenerMeta.getBatchPipeline());
        try {
            batchPipelineMeta = new PipelineMeta(realFilename, metadataProvider, false, variables);
        }
        catch (Exception e) {
            throw new HopException("Unable to load batch pipeline", (Throwable)e);
        }
        return batchPipelineMeta;
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{"Batch pipeline"};
    }

    private boolean isPipelineDefined() {
        return StringUtils.isNotEmpty((String)this.batchPipeline);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isPipelineDefined()};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return AzureListenerMeta.loadBatchPipelineMeta(this, metadataProvider, variables);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getEventHubName() {
        return this.eventHubName;
    }

    public void setEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
    }

    public String getSasKeyName() {
        return this.sasKeyName;
    }

    public void setSasKeyName(String sasKeyName) {
        this.sasKeyName = sasKeyName;
    }

    public String getSasKey() {
        return this.sasKey;
    }

    public void setSasKey(String sasKey) {
        this.sasKey = sasKey;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String outputField) {
        this.outputField = outputField;
    }

    public String getConsumerGroupName() {
        return this.consumerGroupName;
    }

    public void setConsumerGroupName(String consumerGroupName) {
        this.consumerGroupName = consumerGroupName;
    }

    public String getStorageConnectionString() {
        return this.storageConnectionString;
    }

    public void setStorageConnectionString(String storageConnectionString) {
        this.storageConnectionString = storageConnectionString;
    }

    public String getStorageContainerName() {
        return this.storageContainerName;
    }

    public void setStorageContainerName(String storageContainerName) {
        this.storageContainerName = storageContainerName;
    }

    public String getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(String prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public String getPartitionIdField() {
        return this.partitionIdField;
    }

    public void setPartitionIdField(String partitionIdField) {
        this.partitionIdField = partitionIdField;
    }

    public String getOffsetField() {
        return this.offsetField;
    }

    public void setOffsetField(String offsetField) {
        this.offsetField = offsetField;
    }

    public String getSequenceNumberField() {
        return this.sequenceNumberField;
    }

    public void setSequenceNumberField(String sequenceNumberField) {
        this.sequenceNumberField = sequenceNumberField;
    }

    public String getHostField() {
        return this.hostField;
    }

    public void setHostField(String hostField) {
        this.hostField = hostField;
    }

    public String getEnqueuedTimeField() {
        return this.enqueuedTimeField;
    }

    public void setEnqueuedTimeField(String enqueuedTimeField) {
        this.enqueuedTimeField = enqueuedTimeField;
    }

    public String getBatchPipeline() {
        return this.batchPipeline;
    }

    public void setBatchPipeline(String batchPipeline) {
        this.batchPipeline = batchPipeline;
    }

    public String getBatchInputTransform() {
        return this.batchInputTransform;
    }

    public void setBatchInputTransform(String batchInputTransform) {
        this.batchInputTransform = batchInputTransform;
    }

    public String getBatchOutputTransform() {
        return this.batchOutputTransform;
    }

    public void setBatchOutputTransform(String batchOutputTransform) {
        this.batchOutputTransform = batchOutputTransform;
    }

    public String getBatchMaxWaitTime() {
        return this.batchMaxWaitTime;
    }

    public void setBatchMaxWaitTime(String batchMaxWaitTime) {
        this.batchMaxWaitTime = batchMaxWaitTime;
    }
}

