/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.config;

import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;

@HopMetadata(key="workflow-run-configuration", name="Workflow Run Configuration", description="Describes how to execute a workflow", image="ui/images/workflow_run_config.svg", documentationUrl="/metadata-types/workflow-run-config.html")
public class WorkflowRunConfiguration
extends HopMetadataBase
implements Cloneable,
IHopMetadata {
    public static final String GUI_PLUGIN_ELEMENT_PARENT_ID = "WorkflowRunConfiguration-PluginSpecific-Options";
    @HopMetadataProperty
    private String description;
    @HopMetadataProperty
    private IWorkflowEngineRunConfiguration engineRunConfiguration;

    public WorkflowRunConfiguration() {
    }

    public WorkflowRunConfiguration(String name, String description, IWorkflowEngineRunConfiguration engineRunConfiguration) {
        this();
        this.name = name;
        this.description = description;
        this.engineRunConfiguration = engineRunConfiguration;
    }

    public WorkflowRunConfiguration(WorkflowRunConfiguration c) {
        this.name = c.name;
        this.description = c.description;
        if (c.engineRunConfiguration != null) {
            this.engineRunConfiguration = c.engineRunConfiguration.clone();
        }
    }

    protected WorkflowRunConfiguration clone() {
        return new WorkflowRunConfiguration(this);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IWorkflowEngineRunConfiguration getEngineRunConfiguration() {
        return this.engineRunConfiguration;
    }

    public void setEngineRunConfiguration(IWorkflowEngineRunConfiguration engineRunConfiguration) {
        this.engineRunConfiguration = engineRunConfiguration;
    }
}

