/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.SwingUniversalImage;
import org.apache.hop.core.SwingUniversalImageSvg;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.svg.SvgSupport;
import org.apache.hop.core.vfs.HopVfs;

public class SwingSvgImageUtil {
    private static FileObject base;
    private static final String NO_IMAGE = "ui/images/no_image.svg";

    private static SwingUniversalImageSvg getImageAsResourceInternal(String location) {
        SwingUniversalImageSvg result = null;
        if (result == null) {
            result = SwingSvgImageUtil.loadFromCurrentClasspath(location);
        }
        if (result == null) {
            result = SwingSvgImageUtil.loadFromBasedVFS(location);
        }
        if (result == null) {
            result = SwingSvgImageUtil.loadFromSimpleVFS(location);
        }
        return result;
    }

    public static SwingUniversalImageSvg getImageAsResource(String location) {
        SwingUniversalImageSvg result = null;
        if (result == null && SvgSupport.isSvgEnabled()) {
            result = SwingSvgImageUtil.getImageAsResourceInternal(SvgSupport.toSvgName((String)location));
        }
        if (result == null && !location.equals(NO_IMAGE)) {
            result = SwingSvgImageUtil.getImageAsResource(NO_IMAGE);
        }
        return result;
    }

    private static SwingUniversalImageSvg getUniversalImageInternal(ClassLoader classLoader, String filename) {
        SwingUniversalImageSvg result = SwingSvgImageUtil.loadFromClassLoader(classLoader, filename);
        if (result == null && (result = SwingSvgImageUtil.loadFromClassLoader(classLoader, "/" + filename)) == null && (result = SwingSvgImageUtil.loadFromClassLoader(classLoader, "ui/images/" + filename)) == null) {
            result = SwingSvgImageUtil.getImageAsResourceInternal(filename);
        }
        return result;
    }

    public static SwingUniversalImageSvg getUniversalImage(ClassLoader classLoader, String filename) {
        if (StringUtils.isBlank((String)filename)) {
            throw new RuntimeException("Filename not provided");
        }
        SwingUniversalImageSvg result = null;
        if (SvgSupport.isSvgEnabled()) {
            result = SwingSvgImageUtil.getUniversalImageInternal(classLoader, SvgSupport.toSvgName((String)filename));
        }
        if (result == null) {
            result = SwingSvgImageUtil.getUniversalImageInternal(classLoader, SvgSupport.toPngName((String)filename));
        }
        if (result == null) {
            result = SwingSvgImageUtil.getImageAsResource(NO_IMAGE);
        }
        return result;
    }

    public static SwingUniversalImage getImage(String location) {
        return SwingSvgImageUtil.getImageAsResource(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwingUniversalImageSvg loadFromClassLoader(ClassLoader classLoader, String location) {
        InputStream s = classLoader.getResourceAsStream(location);
        if (s == null) {
            return null;
        }
        try {
            SwingUniversalImageSvg swingUniversalImageSvg = SwingSvgImageUtil.loadImage(s, location);
            return swingUniversalImageSvg;
        }
        finally {
            IOUtils.closeQuietly((InputStream)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwingUniversalImageSvg loadFromCurrentClasspath(String location) {
        InputStream s;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL res = cl.getResource(location);
        if (res == null) {
            return null;
        }
        try {
            s = res.openStream();
        }
        catch (IOException ex) {
            return null;
        }
        if (s == null) {
            return null;
        }
        try {
            SwingUniversalImageSvg swingUniversalImageSvg = SwingSvgImageUtil.loadImage(s, location);
            return swingUniversalImageSvg;
        }
        finally {
            IOUtils.closeQuietly((InputStream)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwingUniversalImageSvg loadFromBasedVFS(String location) {
        SwingUniversalImageSvg swingUniversalImageSvg;
        FileObject imageFileObject = HopVfs.getFileSystemManager().resolveFile(base, location);
        InputStream s = HopVfs.getInputStream((FileObject)imageFileObject);
        if (s == null) {
            return null;
        }
        try {
            swingUniversalImageSvg = SwingSvgImageUtil.loadImage(s, location);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)s);
                throw throwable;
            }
            catch (FileSystemException ex) {
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)s);
        return swingUniversalImageSvg;
    }

    private static SwingUniversalImageSvg loadFromSimpleVFS(String location) {
        SwingUniversalImageSvg swingUniversalImageSvg;
        InputStream s = HopVfs.getInputStream((String)location);
        if (s == null) {
            return null;
        }
        try {
            swingUniversalImageSvg = SwingSvgImageUtil.loadImage(s, location);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)s);
                throw throwable;
            }
            catch (HopFileException hopFileException) {
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)s);
        return swingUniversalImageSvg;
    }

    private static SwingUniversalImageSvg loadImage(InputStream in, String filename) {
        if (!SvgSupport.isSvgName((String)filename)) {
            throw new RuntimeException("Only SVG images are supported, not : '" + filename + "'");
        }
        try {
            return new SwingUniversalImageSvg(SvgSupport.loadSvgImage((InputStream)in));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        try {
            base = HopVfs.getFileSystemManager().resolveFile(System.getProperty("user.dir"));
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            base = null;
        }
    }
}

