/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.actions.runtests;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.UnitTestResult;
import org.apache.hop.testing.util.UnitTestUtil;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.w3c.dom.Node;

@Action(id="RunPipelineTests", name="i18n::RunPipelineTests.Name", description="i18n::RunPipelineTests.Description", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.General", keywords={"i18n::RunPipelineTests.keyword"}, image="Test_tube_icon.svg", documentationUrl="/workflow/actions/runpipelinetests.html")
public class RunPipelineTests
extends ActionBase
implements IAction,
Cloneable {
    public static final String TEST_NAMES = "test_names";
    public static final String TEST_NAME = "test_name";
    private List<String> testNames = new ArrayList<String>();

    public RunPipelineTests(String name, String description) {
        super(name, description);
    }

    public RunPipelineTests() {
        this("", "");
    }

    public RunPipelineTests clone() {
        return (RunPipelineTests)super.clone();
    }

    public Result execute(Result prevResult, int nr) throws HopException {
        IHopMetadataSerializer testSerializer = this.getMetadataProvider().getSerializer(PipelineUnitTest.class);
        AtomicBoolean success = new AtomicBoolean(true);
        for (String testName : this.testNames) {
            PipelineUnitTest test = (PipelineUnitTest)testSerializer.load(testName);
            UnitTestUtil.executeUnitTest(test, (ILoggingObject)this, this.getLogLevel(), this.getMetadataProvider(), (IVariables)this, (pipeline, result) -> {
                if (result.getNrErrors() > 0L) {
                    this.logError("There was an error running the pipeline for unit test '" + test.getName() + "'");
                    success.set(false);
                }
            }, (pipeline, testResults) -> {
                int errorCount = 0;
                for (UnitTestResult testResult : testResults) {
                    if (!testResult.isError()) continue;
                    this.logError("Error in validating test data set '" + testResult.getDataSetName() + " : " + testResult.getComment());
                    ++errorCount;
                }
                if (errorCount > 0) {
                    this.logError("There were test result evaluation errors in pipeline unit test '" + test.getName());
                    success.set(false);
                }
            }, (test1, pipelineMeta, e) -> {
                this.logError("There was an exception executing pipeline unit test '" + test.getName(), e);
                success.set(false);
            });
        }
        if (success.get()) {
            prevResult.setNrErrors(0L);
            prevResult.setResult(true);
        } else {
            prevResult.setNrErrors(prevResult.getNrErrors() + 1L);
            prevResult.setResult(false);
        }
        return prevResult;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(super.getXml());
        xml.append(XmlHandler.openTag((String)TEST_NAMES));
        for (String testName : this.testNames) {
            xml.append(XmlHandler.openTag((String)TEST_NAME));
            xml.append(XmlHandler.addTagValue((String)"name", (String)testName));
            xml.append(XmlHandler.closeTag((String)TEST_NAME));
        }
        xml.append(XmlHandler.closeTag((String)TEST_NAMES));
        return xml.toString();
    }

    public void loadXml(Node entryNode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        super.loadXml(entryNode);
        Node testNamesNode = XmlHandler.getSubNode((Node)entryNode, (String)TEST_NAMES);
        List testNameNodes = XmlHandler.getNodes((Node)testNamesNode, (String)TEST_NAME);
        this.testNames = new ArrayList<String>();
        for (Node testNameNode : testNameNodes) {
            String name = XmlHandler.getTagValue((Node)testNameNode, (String)"name");
            this.testNames.add(name);
        }
    }

    public String[] getReferencedObjectDescriptions() {
        String[] descriptions = new String[this.testNames.size()];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = "Pipeline of unit test : " + this.testNames.get(i);
        }
        return descriptions;
    }

    public boolean[] isReferencedObjectEnabled() {
        boolean[] enabled = new boolean[this.testNames.size()];
        for (int i = 0; i < enabled.length; ++i) {
            enabled[i] = true;
        }
        return enabled;
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        String testName;
        IHopMetadataSerializer testSerializer = metadataProvider.getSerializer(PipelineUnitTest.class);
        PipelineUnitTest test = (PipelineUnitTest)testSerializer.load(testName = this.testNames.get(index));
        if (test == null) {
            throw new HopException("Unit test '" + testName + "' could not be found");
        }
        return UnitTestUtil.loadTestPipeline(test, metadataProvider, variables);
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public List<String> getTestNames() {
        return this.testNames;
    }

    public void setTestNames(List<String> testNames) {
        this.testNames = testNames;
    }
}

