/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.nio.CharBuffer;

class Mlog {
    static final char[] hexa = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static int loRange = 100;
    static int hiRange = 100;
    static int cnt = 1;
    static boolean logFlag;

    Mlog() {
    }

    public static boolean logEnable(boolean bl) {
        boolean bl2 = logFlag;
        logFlag = bl;
        return bl2;
    }

    public static void putLine(String string) {
        if (!logFlag) {
            return;
        }
        int n = string.length();
        if (n <= loRange + hiRange) {
            Trace.log(5, cnt++ + ": " + string);
        } else {
            Trace.log(5, cnt++ + ": " + string.substring(0, loRange));
            Trace.log(5, ". . . " + (n - loRange - hiRange) + " chars omitted . . .");
            Trace.log(5, string.substring(n - hiRange, n));
        }
    }

    public static String toHex(char[] cArray, boolean bl) {
        return Mlog.toHex(cArray, 0, cArray.length, bl);
    }

    public static String toHex(char[] cArray, int n, int n2, boolean bl) {
        if (n2 <= n) {
            return "";
        }
        int n3 = n2 - n;
        char[] cArray2 = new char[n3 * 5];
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (c < '\u0100') {
                if (!bl) {
                    cArray2[n4++] = 48;
                    cArray2[n4++] = 48;
                }
            } else {
                cArray2[n4++] = hexa[c >> 12];
                cArray2[n4++] = hexa[(c & 0xF00) >> 8];
            }
            cArray2[n4++] = hexa[(c & 0xF0) >> 4];
            cArray2[n4++] = hexa[c & 0xF];
            cArray2[n4++] = 32;
        }
        return new String(cArray2, 0, n4 - 1);
    }

    public static String toHex(String string, boolean bl) {
        return Mlog.toHex(string.toCharArray(), 0, string.length(), bl);
    }

    public static void putHexLine(char[] cArray, boolean bl) {
        if (logFlag) {
            Mlog.putHexLine(cArray, 0, cArray.length, bl);
        }
    }

    public static void putHexLine(char[] cArray, int n, int n2, boolean bl) {
        if (!logFlag) {
            return;
        }
        int n3 = n2 - n;
        if (n3 <= loRange + hiRange) {
            Trace.log(5, cnt + ": " + Mlog.toHex(cArray, n, n2, bl));
            Trace.log(5, cnt++ + ": " + new String(cArray, n, n2 - n));
        } else {
            Trace.log(5, cnt + ": " + Mlog.toHex(cArray, n, n + loRange, bl));
            Trace.log(5, ". . . " + (n3 - loRange - hiRange) + " chars omitted . . .");
            Trace.log(5, Mlog.toHex(cArray, n2 - hiRange, n2, bl));
            Trace.log(5, cnt++ + ": " + new String(cArray, n, loRange));
            Trace.log(5, ". . . " + (n3 - loRange - hiRange) + " chars omitted . . .");
            Trace.log(5, new String(cArray, n2 - hiRange, hiRange));
        }
    }

    public static void putHexLine(String string) {
        if (logFlag) {
            Mlog.putHexLine(string.toCharArray(), false);
        }
    }

    public static void putHexLine(String string, boolean bl) {
        if (logFlag) {
            Mlog.putHexLine(string.toCharArray(), bl);
        }
    }

    public static boolean logReturn(boolean bl) {
        if (logFlag) {
            Mlog.putLine("return flag = " + bl);
        }
        return bl;
    }

    public static char[] logReturn(char[] cArray) {
        if (logFlag) {
            Mlog.putLine("return chars = " + Mlog.toHex(cArray, true));
            --cnt;
            Mlog.putLine("return chars = " + new String(cArray));
        }
        return cArray;
    }

    public static String logReturn(String string) {
        if (logFlag) {
            Mlog.putLine("return string = " + Mlog.toHex(string, true));
            --cnt;
            Mlog.putLine("return string = " + string);
        }
        return string;
    }

    public static CharBuffer logReturn(CharBuffer charBuffer) {
        if (logFlag) {
            Mlog.putLine("return buffer = " + Mlog.toHex(charBuffer.toString(), true));
            --cnt;
            Mlog.putLine("return buffer = " + charBuffer.toString());
        }
        return charBuffer;
    }

    public static void printStackTrace(String string) {
        if (!logFlag) {
            return;
        }
        Exception exception = new Exception();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        Mlog.putLine("Entering:  " + string);
        for (int i = 1; i < stackTraceElementArray.length; ++i) {
            --cnt;
            Mlog.putLine("   " + stackTraceElementArray[i].toString());
        }
    }
}

