/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BaseDataQueueImpl;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DQClearDataStream;
import com.ibm.as400.access.DQCommonReplyDataStream;
import com.ibm.as400.access.DQCreateDataStream;
import com.ibm.as400.access.DQDeleteDataStream;
import com.ibm.as400.access.DQExchangeAttributesDataStream;
import com.ibm.as400.access.DQExchangeAttributesNormalReplyDataStream;
import com.ibm.as400.access.DQQueryRecord;
import com.ibm.as400.access.DQReadDataStream;
import com.ibm.as400.access.DQReadNormalReplyDataStream;
import com.ibm.as400.access.DQReceiveRecord;
import com.ibm.as400.access.DQRequestAttributesDataStream;
import com.ibm.as400.access.DQRequestAttributesNormalReplyDataStream;
import com.ibm.as400.access.DQWriteDataStream;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class BaseDataQueueImplRemote
implements BaseDataQueueImpl {
    AS400ImplRemote system_;
    private AS400Server server_ = null;
    String path_;
    ConverterImplRemote converter_;
    byte[] queueNameBytes_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    byte[] libraryBytes_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};

    BaseDataQueueImplRemote() {
    }

    public void setSystemAndPath(AS400Impl aS400Impl, String string, String string2, String string3) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting up implementation object: " + string);
        }
        this.system_ = (AS400ImplRemote)aS400Impl;
        this.path_ = string;
        this.converter_ = ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_);
        this.converter_.stringToByteArray(string2, this.queueNameBytes_);
        this.converter_.stringToByteArray(string3, this.libraryBytes_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        AS400Server aS400Server = this.server_ = this.system_.getConnection(3, false, false);
        synchronized (aS400Server) {
            DataStream dataStream = this.server_.getExchangeAttrReply();
            if (dataStream == null) {
                try {
                    dataStream = this.server_.sendExchangeAttrRequest(new DQExchangeAttributesDataStream());
                }
                catch (IOException iOException) {
                    Trace.log(2, "IOException during exchange attributes:", (Throwable)iOException);
                    this.system_.disconnectServer(this.server_);
                    throw iOException;
                }
                switch (dataStream.hashCode()) {
                    case 32768: {
                        return;
                    }
                    case 32770: {
                        Trace.log(2, "Unexpected reply datastream:", dataStream.data_);
                        this.system_.disconnectServer(this.server_);
                        DQCommonReplyDataStream dQCommonReplyDataStream = (DQCommonReplyDataStream)dataStream;
                        throw this.buildException(dQCommonReplyDataStream.getRC(), dQCommonReplyDataStream.getMessage());
                    }
                }
                Trace.log(2, "Unknown exchange attributes reply datastream:", dataStream.data_);
                this.system_.disconnectServer(this.server_);
                throw new InternalErrorException(2);
            }
        }
    }

    public void clear(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing clear: " + this.path_);
        }
        DQClearDataStream dQClearDataStream = new DQClearDataStream(this.queueNameBytes_, this.libraryBytes_, byArray);
        try {
            DataStream dataStream = this.server_.sendAndReceive(dQClearDataStream);
            switch (dataStream.hashCode()) {
                case 32770: {
                    DQCommonReplyDataStream dQCommonReplyDataStream = (DQCommonReplyDataStream)dataStream;
                    int n = dQCommonReplyDataStream.getRC();
                    if (n != 61440) {
                        throw this.buildException(byArray != null, n, dQCommonReplyDataStream.getMessage());
                    }
                    break;
                }
                default: {
                    Trace.log(2, "Unknown clear reply datastream:", dataStream.data_);
                    throw new InternalErrorException(2);
                }
            }
        }
        catch (IOException iOException) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)iOException);
            this.system_.disconnectServer(this.server_);
            throw iOException;
        }
    }

    public void create(int n, String string, boolean bl, boolean bl2, int n2, boolean bl3, String string2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing create: " + this.path_);
        }
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        this.converter_.stringToByteArray(string2, byArray);
        DQCreateDataStream dQCreateDataStream = new DQCreateDataStream(this.queueNameBytes_, this.libraryBytes_, n, string, bl, bl2, n2, bl3, byArray);
        try {
            DataStream dataStream = this.server_.sendAndReceive(dQCreateDataStream);
            switch (dataStream.hashCode()) {
                case 32770: {
                    DQCommonReplyDataStream dQCommonReplyDataStream = (DQCommonReplyDataStream)dataStream;
                    int n3 = dQCommonReplyDataStream.getRC();
                    if (n3 != 61440) {
                        if (n3 == 61441 && this.converter_.byteArrayToString(dQCommonReplyDataStream.getMessage(), 0, 7).equals("CPF9870")) {
                            Trace.log(2, "Data queue already exists: " + this.path_);
                            throw new ObjectAlreadyExistsException(this.path_, 1);
                        }
                        throw this.buildException(n3, dQCommonReplyDataStream.getMessage());
                    }
                    break;
                }
                default: {
                    Trace.log(2, "Unknown create reply datastream:", dataStream.data_);
                    throw new InternalErrorException(2);
                }
            }
        }
        catch (IOException iOException) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)iOException);
            this.system_.disconnectServer(this.server_);
            throw iOException;
        }
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing delete: " + this.path_);
        }
        DQDeleteDataStream dQDeleteDataStream = new DQDeleteDataStream(this.queueNameBytes_, this.libraryBytes_);
        try {
            DataStream dataStream = this.server_.sendAndReceive(dQDeleteDataStream);
            switch (dataStream.hashCode()) {
                case 32770: {
                    DQCommonReplyDataStream dQCommonReplyDataStream = (DQCommonReplyDataStream)dataStream;
                    int n = dQCommonReplyDataStream.getRC();
                    if (n != 61440) {
                        throw this.buildException(n, dQCommonReplyDataStream.getMessage());
                    }
                    break;
                }
                default: {
                    Trace.log(2, "Unknown delete reply datastream:", dataStream.data_);
                    throw new InternalErrorException(2);
                }
            }
        }
        catch (IOException iOException) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)iOException);
            this.system_.disconnectServer(this.server_);
            throw iOException;
        }
    }

    public DQReceiveRecord read(String string, int n, boolean bl, byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing read: " + this.path_);
        }
        byte[] byArray2 = byArray == null ? new byte[2] : this.converter_.stringToByteArray(string);
        DQReadDataStream dQReadDataStream = new DQReadDataStream(this.queueNameBytes_, this.libraryBytes_, byArray2, n, bl, byArray);
        try {
            DataStream dataStream = this.server_.sendAndReceive(dQReadDataStream);
            switch (dataStream.hashCode()) {
                case 32771: {
                    DQReadNormalReplyDataStream dQReadNormalReplyDataStream = (DQReadNormalReplyDataStream)dataStream;
                    byte[] byArray3 = dQReadNormalReplyDataStream.getSenderInformation();
                    return new DQReceiveRecord(byArray3[0] == 64 ? null : this.converter_.byteArrayToString(byArray3), dQReadNormalReplyDataStream.getEntry(), dQReadNormalReplyDataStream.getKey());
                }
                case 32770: {
                    DQCommonReplyDataStream dQCommonReplyDataStream = (DQCommonReplyDataStream)dataStream;
                    int n2 = dQCommonReplyDataStream.getRC();
                    if (n2 == 61446) {
                        Trace.log(3, "No entry on data queue.");
                        return null;
                    }
                    throw this.buildException(byArray != null, n2, dQCommonReplyDataStream.getMessage());
                }
            }
            Trace.log(2, "Unknown read reply datastream ", dataStream.data_);
            throw new InternalErrorException(2);
        }
        catch (IOException iOException) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)iOException);
            this.system_.disconnectServer(this.server_);
            throw iOException;
        }
    }

    public DQQueryRecord retrieveAttributes(boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing retrieve attributes: " + this.path_);
        }
        DQRequestAttributesDataStream dQRequestAttributesDataStream = new DQRequestAttributesDataStream(this.queueNameBytes_, this.libraryBytes_);
        try {
            DataStream dataStream = this.server_.sendAndReceive(dQRequestAttributesDataStream);
            switch (dataStream.hashCode()) {
                case 32769: {
                    DQRequestAttributesNormalReplyDataStream dQRequestAttributesNormalReplyDataStream = (DQRequestAttributesNormalReplyDataStream)dataStream;
                    int n = dQRequestAttributesNormalReplyDataStream.getType();
                    DQQueryRecord dQQueryRecord = new DQQueryRecord();
                    if (bl) {
                        if (n != 2) {
                            Trace.log(2, "Using KeyedDataQueue for non-keyed data queue: " + this.path_);
                            throw new IllegalObjectTypeException(this.path_, 2);
                        }
                        dQQueryRecord.FIFO_ = true;
                    } else if (n == 0) {
                        dQQueryRecord.FIFO_ = true;
                    } else if (n == 1) {
                        dQQueryRecord.FIFO_ = false;
                    } else {
                        Trace.log(2, "Using DataQueue for keyed data queue: " + this.path_);
                        throw new IllegalObjectTypeException(this.path_, 1);
                    }
                    dQQueryRecord.maxEntryLength_ = dQRequestAttributesNormalReplyDataStream.getMaxEntryLength();
                    dQQueryRecord.saveSenderInformation_ = dQRequestAttributesNormalReplyDataStream.getSaveSenderInformation();
                    dQQueryRecord.forceToAuxiliaryStorage_ = dQRequestAttributesNormalReplyDataStream.getForceToAuxiliaryStorage();
                    dQQueryRecord.description_ = this.converter_.byteArrayToString(dQRequestAttributesNormalReplyDataStream.getDescription());
                    dQQueryRecord.keyLength_ = dQRequestAttributesNormalReplyDataStream.getKeyLength();
                    return dQQueryRecord;
                }
                case 32770: {
                    DQCommonReplyDataStream dQCommonReplyDataStream = (DQCommonReplyDataStream)dataStream;
                    throw this.buildException(dQCommonReplyDataStream.getRC(), dQCommonReplyDataStream.getMessage());
                }
            }
            Trace.log(2, "Unknown retrieve attributes reply datastream:", dataStream.data_);
            throw new InternalErrorException(2);
        }
        catch (IOException iOException) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)iOException);
            this.system_.disconnectServer(this.server_);
            throw iOException;
        }
    }

    public void write(byte[] byArray, byte[] byArray2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing write: " + this.path_);
        }
        DQWriteDataStream dQWriteDataStream = new DQWriteDataStream(this.queueNameBytes_, this.libraryBytes_, byArray, byArray2);
        try {
            DataStream dataStream = this.server_.sendAndReceive(dQWriteDataStream);
            switch (dataStream.hashCode()) {
                case 32770: {
                    DQCommonReplyDataStream dQCommonReplyDataStream = (DQCommonReplyDataStream)dataStream;
                    int n = dQCommonReplyDataStream.getRC();
                    if (n != 61440) {
                        throw this.buildException(byArray != null, n, dQCommonReplyDataStream.getMessage());
                    }
                    break;
                }
                default: {
                    Trace.log(2, "Unknown write reply datastream:", dataStream.data_);
                    throw new InternalErrorException(2);
                }
            }
        }
        catch (IOException iOException) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)iOException);
            this.system_.disconnectServer(this.server_);
            throw iOException;
        }
    }

    private AS400Exception buildException(int n, byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ObjectDoesNotExistException {
        switch (n) {
            case 61441: {
                if (byArray == null) {
                    Trace.log(2, "Error completing data queue request, rc: 0xF001");
                    throw new ErrorCompletingRequestException(11, n + ":");
                }
                String string = this.converter_.byteArrayToString(byArray, 0, 7);
                String string2 = this.converter_.byteArrayToString(byArray);
                Trace.log(2, "Error completing data queue request: " + string2);
                if (string.equals("CPF9810")) {
                    Trace.log(2, "Library does not exist: '" + this.converter_.byteArrayToString(this.libraryBytes_) + "'");
                    throw new ObjectDoesNotExistException(this.path_, 1);
                }
                if (string.equals("CPF9801") || string.equals("CPF2105")) {
                    throw new ObjectDoesNotExistException(this.path_, 2);
                }
                if (string.equals("CPF9802") || string.equals("CPF2189")) {
                    throw new AS400SecurityException(this.path_, 4);
                }
                if (string.equals("CPF9820") || string.equals("CPF2182")) {
                    throw new AS400SecurityException(this.path_, 3);
                }
                return new AS400Exception(new AS400Message(string, string2.substring(9)));
            }
            case 61442: {
                Trace.log(2, "Data queue protocol error.");
                throw new InternalErrorException(4);
            }
            case 61443: {
                Trace.log(2, "Data queue syntax error.");
                throw new InternalErrorException(5);
            }
            case 61444: {
                Trace.log(2, "Data queue has been destroyed.");
                throw new ObjectDoesNotExistException(this.path_, 2);
            }
            case 61445: {
                Trace.log(2, "Unsupported length.");
                throw new ErrorCompletingRequestException(9);
            }
            case 61447: {
                Trace.log(2, "Data queue data stream level not valid.");
                throw new InternalErrorException(1);
            }
            case 61448: {
                Trace.log(2, "Data queue VRM not valid.");
                throw new InternalErrorException(7);
            }
            case 61449: {
                Trace.log(2, "Exit program rejected request.");
                throw new ErrorCompletingRequestException(4);
            }
            case 61450: {
                Trace.log(2, "Exit program not authorized.");
                throw new AS400SecurityException(2);
            }
            case 61451: {
                Trace.log(2, "Exit program not found.");
                throw new ErrorCompletingRequestException(6);
            }
            case 61453: {
                Trace.log(2, "Exit program error.");
                throw new ErrorCompletingRequestException(5);
            }
            case 61454: {
                Trace.log(2, "Exit program number not valid.");
                throw new ErrorCompletingRequestException(7);
            }
        }
        byte[] byArray2 = new byte[2];
        BinaryConverter.unsignedShortToByteArray(n, byArray2, 0);
        if (byArray == null) {
            Trace.log(2, "Error completing data queue request, rc:", byArray2);
            throw new ErrorCompletingRequestException(11, n + ":");
        }
        String string = this.converter_.byteArrayToString(byArray);
        Trace.log(2, "Error completing data queue request: " + string + ", rc:", byArray2);
        throw new ErrorCompletingRequestException(11, n + " : " + string);
    }

    private AS400Exception buildException(boolean bl, int n, byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, ObjectDoesNotExistException {
        if (n == 61441 && byArray != null) {
            String string = this.converter_.byteArrayToString(byArray, 0, 7);
            if (bl && string.equals("CPF9502")) {
                Trace.log(2, "Error completing data queue request: " + this.converter_.byteArrayToString(byArray));
                Trace.log(2, "Using KeyedDataQueue for non-keyed data queue: " + this.path_);
                throw new IllegalObjectTypeException(this.path_, 2);
            }
            if (!bl && string.equals("CPF9506")) {
                Trace.log(2, "Error completing data queue request: " + this.converter_.byteArrayToString(byArray));
                Trace.log(2, "Using DataQueue for keyed data queue: " + this.path_);
                throw new IllegalObjectTypeException(this.path_, 1);
            }
        }
        return this.buildException(n, byArray);
    }

    static {
        AS400Server.addReplyStream((DataStream)new DQExchangeAttributesNormalReplyDataStream(), 3);
        AS400Server.addReplyStream((DataStream)new DQRequestAttributesNormalReplyDataStream(), 3);
        AS400Server.addReplyStream((DataStream)new DQCommonReplyDataStream(), 3);
        AS400Server.addReplyStream((DataStream)new DQReadNormalReplyDataStream(), 3);
    }
}

