/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.combinationlookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.combinationlookup.CombinationLookupMeta;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CombinationLookupDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = CombinationLookupDialog.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private TextVar wTable;
    private Text wCommit;
    private Text wCachesize;
    private Button wPreloadCache;
    private Text wTk;
    private Label wlAutoinc;
    private Button wAutoinc;
    private Label wlTableMax;
    private Button wTableMax;
    private Label wlSeqButton;
    private Button wSeqButton;
    private Text wSeq;
    private Button wReplace;
    private Button wHashcode;
    private TableView wKey;
    private Label wlHashfield;
    private Text wHashfield;
    private Text wLastUpdateField;
    private ColumnInfo[] ciKey;
    private final CombinationLookupMeta input;
    private DatabaseMeta ci;
    private final Map<String, Integer> inputFields;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public CombinationLookupDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (CombinationLookupMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setTableFieldCombo();
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CombinationLookupDialog.this.input.setChanged();
                CombinationLookupDialog.this.setTableFieldCombo();
            }
        };
        this.backupChanged = this.input.hasChanged();
        this.ci = this.input.getDatabaseMeta();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getDatabaseMeta(), lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        this.wConnection.addModifyListener(e -> {
            this.ci = this.pipelineMeta.findDatabase(this.wConnection.getText());
            this.setAutoincUse();
            this.setSequence();
            this.input.setChanged();
        });
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label((Composite)this.shell, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Target.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.BrowseTable.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlCommit = new Label((Composite)this.shell, 131072);
        wlCommit.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Commitsize.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.right = new FormAttachment(middle, -margin);
        fdlCommit.top = new FormAttachment((Control)this.wTable, margin);
        wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        FormData fdCommit = new FormData();
        fdCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.right = new FormAttachment(middle + (100 - middle) / 3, -margin);
        this.wCommit.setLayoutData((Object)fdCommit);
        Label wlCachesize = new Label((Composite)this.shell, 131072);
        wlCachesize.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Cachesize.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCachesize);
        FormData fdlCachesize = new FormData();
        fdlCachesize.top = new FormAttachment((Control)this.wTable, margin);
        fdlCachesize.left = new FormAttachment((Control)this.wCommit, margin);
        fdlCachesize.right = new FormAttachment(middle + 2 * (100 - middle) / 3, -margin);
        wlCachesize.setLayoutData((Object)fdlCachesize);
        this.wCachesize = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCachesize);
        this.wCachesize.addModifyListener(lsMod);
        FormData fdCachesize = new FormData();
        fdCachesize.top = new FormAttachment((Control)this.wTable, margin);
        fdCachesize.left = new FormAttachment((Control)wlCachesize, margin);
        fdCachesize.right = new FormAttachment(100, 0);
        this.wCachesize.setLayoutData((Object)fdCachesize);
        this.wCachesize.setToolTipText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Cachesize.ToolTip", (String[])new String[0]));
        this.wPreloadCache = new Button((Composite)this.shell, 32);
        this.wPreloadCache.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.PreloadCache.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wPreloadCache);
        FormData fdPreloadCache = new FormData();
        fdPreloadCache.top = new FormAttachment((Control)this.wCachesize, margin);
        fdPreloadCache.left = new FormAttachment((Control)wlCachesize, margin);
        fdPreloadCache.right = new FormAttachment(100, 0);
        this.wPreloadCache.setLayoutData((Object)fdPreloadCache);
        Label wlKey = new Label((Composite)this.shell, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Keyfields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)this.wPreloadCache, margin);
        fdlKey.right = new FormAttachment(100, 0);
        wlKey.setLayoutData((Object)fdlKey);
        int nrKeyCols = 2;
        int nrKeyRows = this.input.getKeyField() != null ? this.input.getKeyField().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.ColumnInfo.DimensionField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.ColumnInfo.FieldInStream", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciKey[0]);
        this.wKey = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wGet = new Button((Composite)this.shell, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.GetFields.Button", (String[])new String[0]));
        Button wCreate = new Button((Composite)this.shell, 8);
        wCreate.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, wGet, wCreate, this.wCancel}, margin, null);
        Label wlLastUpdateField = new Label((Composite)this.shell, 131072);
        wlLastUpdateField.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.LastUpdateField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLastUpdateField);
        FormData fdlLastUpdateField = new FormData();
        fdlLastUpdateField.left = new FormAttachment(0, 0);
        fdlLastUpdateField.right = new FormAttachment(middle, -margin);
        fdlLastUpdateField.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wlLastUpdateField.setLayoutData((Object)fdlLastUpdateField);
        this.wLastUpdateField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLastUpdateField);
        this.wLastUpdateField.addModifyListener(lsMod);
        FormData fdLastUpdateField = new FormData();
        fdLastUpdateField.left = new FormAttachment(middle, 0);
        fdLastUpdateField.right = new FormAttachment(100, 0);
        fdLastUpdateField.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wLastUpdateField.setLayoutData((Object)fdLastUpdateField);
        this.wlHashfield = new Label((Composite)this.shell, 131072);
        this.wlHashfield.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Hashfield.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHashfield);
        FormData fdlHashfield = new FormData();
        fdlHashfield.left = new FormAttachment(0, 0);
        fdlHashfield.right = new FormAttachment(middle, -margin);
        fdlHashfield.bottom = new FormAttachment((Control)this.wLastUpdateField, -margin);
        this.wlHashfield.setLayoutData((Object)fdlHashfield);
        this.wHashfield = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wHashfield);
        this.wHashfield.addModifyListener(lsMod);
        FormData fdHashfield = new FormData();
        fdHashfield.left = new FormAttachment(middle, 0);
        fdHashfield.right = new FormAttachment(100, 0);
        fdHashfield.bottom = new FormAttachment((Control)this.wLastUpdateField, -margin);
        this.wHashfield.setLayoutData((Object)fdHashfield);
        Label wlHashcode = new Label((Composite)this.shell, 131072);
        wlHashcode.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Hashcode.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHashcode);
        FormData fdlHashcode = new FormData();
        fdlHashcode.left = new FormAttachment(0, 0);
        fdlHashcode.right = new FormAttachment(middle, -margin);
        fdlHashcode.bottom = new FormAttachment((Control)this.wHashfield, -margin);
        wlHashcode.setLayoutData((Object)fdlHashcode);
        this.wHashcode = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wHashcode);
        FormData fdHashcode = new FormData();
        fdHashcode.left = new FormAttachment(middle, 0);
        fdHashcode.right = new FormAttachment(100, 0);
        fdHashcode.bottom = new FormAttachment((Control)wlHashcode, 0, 0x1000000);
        this.wHashcode.setLayoutData((Object)fdHashcode);
        this.wHashcode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CombinationLookupDialog.this.enableFields();
            }
        });
        Label wlReplace = new Label((Composite)this.shell, 131072);
        wlReplace.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Replace.Label", (String[])new String[0]));
        this.props.setLook((Control)wlReplace);
        FormData fdlReplace = new FormData();
        fdlReplace.left = new FormAttachment(0, 0);
        fdlReplace.right = new FormAttachment(middle, -margin);
        fdlReplace.bottom = new FormAttachment((Control)this.wHashcode, -margin);
        wlReplace.setLayoutData((Object)fdlReplace);
        this.wReplace = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wReplace);
        FormData fdReplace = new FormData();
        fdReplace.left = new FormAttachment(middle, 0);
        fdReplace.bottom = new FormAttachment((Control)wlReplace, 0, 0x1000000);
        fdReplace.right = new FormAttachment(100, 0);
        this.wReplace.setLayoutData((Object)fdReplace);
        this.wReplace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CombinationLookupDialog.this.enableFields();
            }
        });
        Label wlTechGroup = new Label((Composite)this.shell, 131072);
        wlTechGroup.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TechGroup.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTechGroup);
        FormData fdlTechGroup = new FormData();
        fdlTechGroup.left = new FormAttachment(0, 0);
        fdlTechGroup.right = new FormAttachment(middle, -margin);
        wlTechGroup.setLayoutData((Object)fdlTechGroup);
        Composite gTechGroup = new Composite((Composite)this.shell, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gTechGroup.setLayout((Layout)gridLayout);
        this.props.setLook((Control)gTechGroup);
        FormData fdTechGroup = new FormData();
        fdTechGroup.left = new FormAttachment(middle, 0);
        fdTechGroup.bottom = new FormAttachment((Control)this.wReplace, -margin);
        fdTechGroup.right = new FormAttachment(100, 0);
        gTechGroup.setLayoutData((Object)fdTechGroup);
        fdlTechGroup.top = new FormAttachment((Control)gTechGroup, margin, 128);
        this.wTableMax = new Button(gTechGroup, 16);
        this.props.setLook((Control)this.wTableMax);
        this.wTableMax.setSelection(false);
        GridData gdTableMax = new GridData();
        this.wTableMax.setLayoutData((Object)gdTableMax);
        this.wTableMax.setToolTipText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TableMaximum.Tooltip", (String[])new String[]{Const.CR}));
        this.wlTableMax = new Label(gTechGroup, 16384);
        this.wlTableMax.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TableMaximum.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTableMax);
        GridData gdlTableMax = new GridData(1808);
        gdlTableMax.horizontalSpan = 2;
        gdlTableMax.verticalSpan = 1;
        this.wlTableMax.setLayoutData((Object)gdlTableMax);
        this.wSeqButton = new Button(gTechGroup, 16);
        this.props.setLook((Control)this.wSeqButton);
        this.wSeqButton.setSelection(false);
        GridData gdSeqButton = new GridData();
        this.wSeqButton.setLayoutData((Object)gdSeqButton);
        this.wSeqButton.setToolTipText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Sequence.Tooltip", (String[])new String[]{Const.CR}));
        this.wlSeqButton = new Label(gTechGroup, 16384);
        this.wlSeqButton.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Sequence.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSeqButton);
        GridData gdlSeqButton = new GridData();
        this.wlSeqButton.setLayoutData((Object)gdlSeqButton);
        this.wSeq = new Text(gTechGroup, 18436);
        this.props.setLook((Control)this.wSeq);
        this.wSeq.addModifyListener(lsMod);
        GridData gdSeq = new GridData(768);
        this.wSeq.setLayoutData((Object)gdSeq);
        this.wSeq.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                CombinationLookupDialog.this.input.setTechKeyCreation("sequence");
                CombinationLookupDialog.this.wSeqButton.setSelection(true);
                CombinationLookupDialog.this.wAutoinc.setSelection(false);
                CombinationLookupDialog.this.wTableMax.setSelection(false);
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        this.wAutoinc = new Button(gTechGroup, 16);
        this.props.setLook((Control)this.wAutoinc);
        this.wAutoinc.setSelection(false);
        GridData gdAutoinc = new GridData();
        this.wAutoinc.setLayoutData((Object)gdAutoinc);
        this.wAutoinc.setToolTipText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.AutoincButton.Tooltip", (String[])new String[]{Const.CR}));
        this.wlAutoinc = new Label(gTechGroup, 16384);
        this.wlAutoinc.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Autoincrement.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAutoinc);
        GridData gdlAutoinc = new GridData();
        this.wlAutoinc.setLayoutData((Object)gdlAutoinc);
        this.setTableMax();
        this.setSequence();
        this.setAutoincUse();
        Label wlTk = new Label((Composite)this.shell, 131072);
        wlTk.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TechnicalKey.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTk);
        FormData fdlTk = new FormData();
        fdlTk.left = new FormAttachment(0, 0);
        fdlTk.right = new FormAttachment(middle, -margin);
        fdlTk.bottom = new FormAttachment((Control)gTechGroup, -margin);
        wlTk.setLayoutData((Object)fdlTk);
        this.wTk = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTk);
        FormData fdTk = new FormData();
        fdTk.left = new FormAttachment(middle, 0);
        fdTk.bottom = new FormAttachment((Control)gTechGroup, -margin);
        fdTk.right = new FormAttachment(100, 0);
        this.wTk.setLayoutData((Object)fdTk);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment(100, 0);
        fdKey.bottom = new FormAttachment((Control)this.wTk, -margin);
        this.wKey.setLayoutData((Object)fdKey);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wOk.addListener(13, e -> this.ok());
        wGet.addListener(13, e -> this.get());
        wCreate.addListener(13, e -> this.create());
        this.wCancel.addListener(13, e -> this.cancel());
        wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CombinationLookupDialog.this.getSchemaNames();
            }
        });
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CombinationLookupDialog.this.getTableName();
            }
        });
        this.getData();
        this.setTableFieldCombo();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[1].setComboValues(fieldNames);
    }

    public void enableFields() {
        this.wHashfield.setEnabled(this.wHashcode.getSelection());
        this.wlHashfield.setEnabled(this.wHashcode.getSelection());
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                DatabaseMeta ci;
                String tableName = this.wTable.getText();
                String connectionName = this.wConnection.getText();
                String schemaName = this.wSchema.getText();
                for (ColumnInfo colInfo : this.tableFieldColumns) {
                    colInfo.setComboValues(new String[0]);
                }
                if (!Utils.isEmpty((CharSequence)tableName) && (ci = this.pipelineMeta.findDatabase(connectionName)) != null) {
                    Database db = new Database(loggingObject, this.variables, ci);
                    try {
                        String[] fieldNames;
                        db.connect();
                        String schemaTable = ci.getQuotedSchemaTableCombination(this.variables, schemaName, tableName);
                        IRowMeta r = db.getTableFields(schemaTable);
                        if (null != r && null != (fieldNames = r.getFieldNames())) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                    }
                    catch (Exception e) {
                        for (ColumnInfo colInfo : this.tableFieldColumns) {
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                    finally {
                        try {
                            if (db != null) {
                                db.disconnect();
                            }
                        }
                        catch (Exception ignored) {
                            db = null;
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void setAutoincUse() {
        boolean enable = this.ci == null || this.ci.supportsAutoinc() && this.ci.supportsAutoGeneratedKeys();
        this.wlAutoinc.setEnabled(enable);
        this.wAutoinc.setEnabled(enable);
        if (!enable && this.wAutoinc.getSelection()) {
            this.wAutoinc.setSelection(false);
            this.wSeqButton.setSelection(false);
            this.wTableMax.setSelection(true);
        }
    }

    public void setTableMax() {
        this.wlTableMax.setEnabled(true);
        this.wTableMax.setEnabled(true);
    }

    public void setSequence() {
        boolean seq = this.ci == null || this.ci.supportsSequences();
        this.wSeq.setEnabled(seq);
        this.wlSeqButton.setEnabled(seq);
        this.wSeqButton.setEnabled(seq);
        if (!seq && this.wSeqButton.getSelection()) {
            this.wAutoinc.setSelection(false);
            this.wSeqButton.setSelection(false);
            this.wTableMax.setSelection(true);
        }
    }

    public void getData() {
        this.logDebug(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Log.GettingKeyInfo", (String[])new String[0]));
        if (this.input.getKeyField() != null) {
            for (int i = 0; i < this.input.getKeyField().length; ++i) {
                TableItem item = this.wKey.table.getItem(i);
                if (this.input.getKeyLookup()[i] != null) {
                    item.setText(1, this.input.getKeyLookup()[i]);
                }
                if (this.input.getKeyField()[i] == null) continue;
                item.setText(2, this.input.getKeyField()[i]);
            }
        }
        this.wPreloadCache.setSelection(this.input.getPreloadCache());
        this.wReplace.setSelection(this.input.replaceFields());
        this.wHashcode.setSelection(this.input.useHash());
        this.wHashfield.setEnabled(this.input.useHash());
        this.wlHashfield.setEnabled(this.input.useHash());
        String techKeyCreation = this.input.getTechKeyCreation();
        if (techKeyCreation == null) {
            DatabaseMeta database = this.input.getDatabaseMeta();
            if (database == null || !database.supportsAutoinc()) {
                this.input.setUseAutoinc(false);
            }
            this.wAutoinc.setSelection(this.input.isUseAutoinc());
            this.wSeqButton.setSelection(this.input.getSequenceFrom() != null && this.input.getSequenceFrom().length() > 0);
            if (!(this.input.isUseAutoinc() || this.input.getSequenceFrom() != null && this.input.getSequenceFrom().length() > 0)) {
                this.wTableMax.setSelection(true);
            }
            if (database != null && database.supportsSequences() && this.input.getSequenceFrom() != null) {
                this.wSeq.setText(this.input.getSequenceFrom());
                this.input.setUseAutoinc(false);
                this.wTableMax.setSelection(false);
            }
        } else {
            if ("autoinc".equals(techKeyCreation)) {
                this.wAutoinc.setSelection(true);
            } else if ("sequence".equals(techKeyCreation)) {
                this.wSeqButton.setSelection(true);
            } else {
                this.wTableMax.setSelection(true);
                this.input.setTechKeyCreation("tablemax");
            }
            if (this.input.getSequenceFrom() != null) {
                this.wSeq.setText(this.input.getSequenceFrom());
            }
        }
        this.setAutoincUse();
        this.setSequence();
        this.setTableMax();
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getTechnicalKeyField() != null) {
            this.wTk.setText(this.input.getTechnicalKeyField());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        if (this.input.getHashField() != null) {
            this.wHashfield.setText(this.input.getHashField());
        }
        this.wCommit.setText("" + this.input.getCommitSize());
        this.wCachesize.setText("" + this.input.getCacheSize());
        this.wLastUpdateField.setText(Const.NVL((String)this.input.getLastUpdateField(), (String)""));
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        CombinationLookupMeta oldMetaState = (CombinationLookupMeta)((Object)this.input.clone());
        this.getInfo(this.input);
        this.transformName = this.wTransformName.getText();
        if (this.pipelineMeta.findDatabase(this.wConnection.getText()) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.NoValidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.NoValidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        if (!this.input.equals((Object)oldMetaState)) {
            this.input.setChanged();
        }
        this.dispose();
    }

    private void getInfo(CombinationLookupMeta in) {
        int nrkeys = this.wKey.nrNonEmpty();
        in.allocate(nrkeys);
        this.logDebug(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Log.SomeKeysFound", (String[])new String[]{String.valueOf(nrkeys)}));
        for (int i = 0; i < nrkeys; ++i) {
            TableItem item = this.wKey.getNonEmpty(i);
            in.getKeyLookup()[i] = item.getText(1);
            in.getKeyField()[i] = item.getText(2);
        }
        in.setPreloadCache(this.wPreloadCache.getSelection());
        in.setUseAutoinc(this.wAutoinc.getSelection() && this.wAutoinc.isEnabled());
        in.setReplaceFields(this.wReplace.getSelection());
        in.setUseHash(this.wHashcode.getSelection());
        in.setHashField(this.wHashfield.getText());
        in.setSchemaName(this.wSchema.getText());
        in.setTablename(this.wTable.getText());
        in.setTechnicalKeyField(this.wTk.getText());
        if (this.wAutoinc.getSelection()) {
            in.setTechKeyCreation("autoinc");
            in.setUseAutoinc(true);
            in.setSequenceFrom(null);
        } else if (this.wSeqButton.getSelection()) {
            in.setTechKeyCreation("sequence");
            in.setUseAutoinc(false);
            in.setSequenceFrom(this.wSeq.getText());
        } else {
            in.setTechKeyCreation("tablemax");
            in.setUseAutoinc(false);
            in.setSequenceFrom(null);
        }
        in.setDatabaseMeta(this.pipelineMeta.findDatabase(this.wConnection.getText()));
        in.setCommitSize(Const.toInt((String)this.wCommit.getText(), (int)0));
        in.setCacheSize(Const.toInt((String)this.wCachesize.getText(), (int)0));
        in.setLastUpdateField(this.wLastUpdateField.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"CombinationLookupDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"CombinationLookupDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CombinationLookupDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName);
        if (databaseMeta != null) {
            this.logDebug(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.Log.LookingAtConnection", (String[])new String[]{databaseMeta.toString()}));
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wKey, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (tableItem, v) -> {
                    tableItem.setText(3, "N");
                    return true;
                });
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CombinationLookupDialog.UnableToGetFieldsError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CombinationLookupDialog.UnableToGetFieldsError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            CombinationLookupMeta info = new CombinationLookupMeta();
            this.getInfo(info);
            String name = this.transformName;
            TransformMeta transformMeta = new TransformMeta(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.TransformMeta.Title", (String[])new String[0]), name, (ITransformMeta)info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider);
            if (!sql.hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, info.getDatabaseMeta(), DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"CombinationLookupDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CombinationLookupDialog.UnableToCreateSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CombinationLookupDialog.UnableToCreateSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

