/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.MigratableResolver;
import org.apache.spark.shuffle.ShuffleBlockInfo;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h!B\u000e\u001d\u0001y!\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y\u0002!\u00111A\u0005\u0002}B\u0001B\u0012\u0001\u0003\u0002\u0004%\ta\u0012\u0005\t\u001b\u0002\u0011\t\u0011)Q\u0005\u0001\")a\n\u0001C\u0001\u001f\"A1\u000b\u0001EC\u0002\u0013%q\bC\u0004U\u0001\t\u0007I\u0011B+\t\ry\u0003\u0001\u0015!\u0003W\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u0019y\u0006\u0001\"\u0001\u0002\n!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002\"CA\u001d\u0001E\u0005I\u0011AA\u001e\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002l\u0001!\t%!\u001c\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0006bBAc\u0001\u0011\u0005\u0013q\u0019\u0005\b\u0003\u001b\u0004A\u0011IAh\u000f!\t\t\u000e\bE\u0001=\u0005MgaB\u000e\u001d\u0011\u0003q\u0012Q\u001b\u0005\u0007\u001dZ!\t!a6\t\u0013\u0005egC1A\u0005\u0002\u0005m\u0007bBAo-\u0001\u0006Ia\u001b\u0005\n\u0003?4\u0012\u0013!C\u0001\u0003C\u0014\u0011$\u00138eKb\u001c\u0006.\u001e4gY\u0016\u0014En\\2l%\u0016\u001cx\u000e\u001c<fe*\u0011QDH\u0001\bg\",hM\u001a7f\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7#\u0002\u0001&W=*\u0004C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g\r\u0005\u0002-[5\tA$\u0003\u0002/9\t!2\u000b[;gM2,'\t\\8dWJ+7o\u001c7wKJ\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0010\u0002\u0011%tG/\u001a:oC2L!\u0001N\u0019\u0003\u000f1{wmZ5oOB\u0011AFN\u0005\u0003oq\u0011!#T5he\u0006$\u0018M\u00197f%\u0016\u001cx\u000e\u001c<fe\u0006!1m\u001c8g\u0007\u0001\u0001\"a\u000f\u001f\u000e\u0003yI!!\u0010\u0010\u0003\u0013M\u0003\u0018M]6D_:4\u0017!D0cY>\u001c7.T1oC\u001e,'/F\u0001A!\t\tE)D\u0001C\u0015\t\u0019e$A\u0004ti>\u0014\u0018mZ3\n\u0005\u0015\u0013%\u0001\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018!E0cY>\u001c7.T1oC\u001e,'o\u0018\u0013fcR\u0011\u0001j\u0013\t\u0003M%K!AS\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u0019\u000e\t\t\u00111\u0001A\u0003\rAH%M\u0001\u000f?\ndwnY6NC:\fw-\u001a:!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001+\u0015*\u0011\u00051\u0002\u0001\"\u0002\u001d\u0006\u0001\u0004Q\u0004b\u0002 \u0006!\u0003\u0005\r\u0001Q\u0001\rE2|7m['b]\u0006<WM]\u0001\u000eiJ\fgn\u001d9peR\u001cuN\u001c4\u0016\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\tU$\u0018\u000e\u001c\u0006\u00037z\tqA\\3uo>\u00148.\u0003\u0002^1\niAK]1ogB|'\u000f^\"p]\u001a\fa\u0002\u001e:b]N\u0004xN\u001d;D_:4\u0007%A\u0006hKR$\u0015\r^1GS2,GcA1j]B\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0003S>T\u0011AZ\u0001\u0005U\u00064\u0018-\u0003\u0002iG\n!a)\u001b7f\u0011\u0015Q\u0017\u00021\u0001l\u0003%\u0019\b.\u001e4gY\u0016LE\r\u0005\u0002'Y&\u0011Qn\n\u0002\u0004\u0013:$\b\"B8\n\u0001\u0004\u0001\u0018!B7ba&#\u0007C\u0001\u0014r\u0013\t\u0011xE\u0001\u0003M_:<\u0017!E4fiN#xN]3e'\",hM\u001a7fgR\tQ\u000f\u0005\u0003w}\u0006\raBA<}\u001d\tA80D\u0001z\u0015\tQ\u0018(\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011QpJ\u0001\ba\u0006\u001c7.Y4f\u0013\ry\u0018\u0011\u0001\u0002\u0004'\u0016\f(BA?(!\ra\u0013QA\u0005\u0004\u0003\u000fa\"\u0001E*ik\u001a4G.\u001a\"m_\u000e\\\u0017J\u001c4p)\u001d\t\u00171BA\u0007\u0003\u001fAQA[\u0006A\u0002-DQa\\\u0006A\u0002ADq!!\u0005\f\u0001\u0004\t\u0019\"\u0001\u0003eSJ\u001c\b#\u0002\u0014\u0002\u0016\u0005e\u0011bAA\fO\t1q\n\u001d;j_:\u0004RAJA\u000e\u0003?I1!!\b(\u0005\u0015\t%O]1z!\u0011\t\t#!\u000b\u000f\t\u0005\r\u0012Q\u0005\t\u0003q\u001eJ1!a\n(\u0003\u0019\u0001&/\u001a3fM&!\u00111FA\u0017\u0005\u0019\u0019FO]5oO*\u0019\u0011qE\u0014\u0002\u0019\u001d,G/\u00138eKb4\u0015\u000e\\3\u0015\u000f\u0005\f\u0019$!\u000e\u00028!)!\u000e\u0004a\u0001W\")q\u000e\u0004a\u0001a\"I\u0011\u0011\u0003\u0007\u0011\u0002\u0003\u0007\u00111C\u0001\u0017O\u0016$\u0018J\u001c3fq\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\b\u0016\u0005\u0003'\tyd\u000b\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013!C;oG\",7m[3e\u0015\r\tYeJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA(\u0003\u000b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003=\u0011X-\\8wK\u0012\u000bG/\u0019\"z\u001b\u0006\u0004H#\u0002%\u0002V\u0005]\u0003\"\u00026\u000f\u0001\u0004Y\u0007\"B8\u000f\u0001\u0004\u0001\u0018!F2iK\u000e\\\u0017J\u001c3fq\u0006sG\rR1uC\u001aKG.\u001a\u000b\t\u0003;\ny&a\u0019\u0002hA!a%a\u0007q\u0011\u0019\t\tg\u0004a\u0001C\u0006)\u0011N\u001c3fq\"1\u0011QM\bA\u0002\u0005\fA\u0001Z1uC\"1\u0011\u0011N\bA\u0002-\faA\u00197pG.\u001c\u0018a\u00069viNCWO\u001a4mK\ncwnY6BgN#(/Z1n)\u0019\ty'a\u001f\u0002\u0006B!\u0011\u0011OA<\u001b\t\t\u0019HC\u0002\u0002vi\u000baa\u00197jK:$\u0018\u0002BA=\u0003g\u0012Ac\u0015;sK\u0006l7)\u00197mE\u0006\u001c7nV5uQ&#\u0005bBA?!\u0001\u0007\u0011qP\u0001\bE2|7m[%e!\r\t\u0015\u0011Q\u0005\u0004\u0003\u0007\u0013%a\u0002\"m_\u000e\\\u0017\n\u001a\u0005\b\u0003\u000f\u0003\u0002\u0019AAE\u0003E\u0019XM]5bY&TXM]'b]\u0006<WM\u001d\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011q\u0012\u0010\u0002\u0015M,'/[1mSj,'/\u0003\u0003\u0002\u0014\u00065%!E*fe&\fG.\u001b>fe6\u000bg.Y4fe\u0006\u0011r-\u001a;NS\u001e\u0014\u0018\r^5p]\ncwnY6t)\u0011\tI*!-\u0011\u000bY\fY*a(\n\t\u0005u\u0015\u0011\u0001\u0002\u0005\u0019&\u001cH\u000fE\u0004'\u0003C\u000by(!*\n\u0007\u0005\rvE\u0001\u0004UkBdWM\r\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**\u0019\u00111\u0016.\u0002\r\t,hMZ3s\u0013\u0011\ty+!+\u0003\u001b5\u000bg.Y4fI\n+hMZ3s\u0011\u001d\t\u0019,\u0005a\u0001\u0003\u0007\t\u0001c\u001d5vM\u001adWM\u00117pG.LeNZ8\u0002/]\u0014\u0018\u000e^3J]\u0012,\u0007PR5mK\u0006sGmQ8n[&$H#\u0003%\u0002:\u0006m\u0016QXAa\u0011\u0015Q'\u00031\u0001l\u0011\u0015y'\u00031\u0001q\u0011\u001d\tyL\u0005a\u0001\u0003;\nq\u0001\\3oORD7\u000f\u0003\u0004\u0002DJ\u0001\r!Y\u0001\bI\u0006$\u0018\rV7q\u000319W\r\u001e\"m_\u000e\\G)\u0019;b)\u0019\t)+!3\u0002L\"9\u0011QP\nA\u0002\u0005}\u0004\"CA\t'A\u0005\t\u0019AA\n\u0003\u0011\u0019Ho\u001c9\u0015\u0003!\u000b\u0011$\u00138eKb\u001c\u0006.\u001e4gY\u0016\u0014En\\2l%\u0016\u001cx\u000e\u001c<feB\u0011AFF\n\u0003-\u0015\"\"!a5\u0002\u001d9{u\nU0S\u000b\u0012+6)R0J\tV\t1.A\bO\u001f>\u0003vLU#E+\u000e+u,\u0013#!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001d\u0016\u0004\u0001\u0006}\u0002")
public class IndexShuffleBlockResolver
implements ShuffleBlockResolver,
Logging,
MigratableResolver {
    private BlockManager org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    private BlockManager _blockManager;
    private final TransportConf transportConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static BlockManager $lessinit$greater$default$2() {
        return IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$2();
    }

    public static int NOOP_REDUCE_ID() {
        return IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Option<String[]> getBlockData$default$2() {
        return ShuffleBlockResolver.getBlockData$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BlockManager _blockManager() {
        return this._blockManager;
    }

    public void _blockManager_$eq(BlockManager x$1) {
        this._blockManager = x$1;
    }

    private BlockManager blockManager$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if (!this.bitmap$0) {
                this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager = (BlockManager)Option$.MODULE$.apply((Object)this._blockManager()).getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkEnv$.MODULE$.get().blockManager());
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    }

    public BlockManager org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager() {
        return !this.bitmap$0 ? this.blockManager$lzycompute() : this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    public File getDataFile(int shuffleId, long mapId) {
        return this.getDataFile(shuffleId, mapId, (Option<String[]>)None$.MODULE$);
    }

    @Override
    public Seq<ShuffleBlockInfo> getStoredShuffles() {
        Seq<BlockId> allBlocks = this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getAllBlocks();
        return (Seq)allBlocks.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            BlockId blockId = x0$1;
            if (blockId instanceof ShuffleIndexBlockId) {
                ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId;
                int shuffleId = shuffleIndexBlockId.shuffleId();
                long mapId = shuffleIndexBlockId.mapId();
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new ShuffleBlockInfo(shuffleId, mapId)));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public File getDataFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleDataBlockId blockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable & scala.Serializable)x$1 -> ExecutorDiskUtils.getFile((String[])x$1, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)blockId.name())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(blockId));
    }

    public File getIndexFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleIndexBlockId blockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable & scala.Serializable)x$2 -> ExecutorDiskUtils.getFile((String[])x$2, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)blockId.name())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(blockId));
    }

    public Option<String[]> getIndexFile$default$3() {
        return None$.MODULE$;
    }

    public void removeDataByMap(int shuffleId, long mapId) {
        block1: {
            ObjectRef file = ObjectRef.create((Object)this.getDataFile(shuffleId, mapId));
            if (((File)file.elem).exists() && !((File)file.elem).delete()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Error deleting data ").append(((File)file$1.elem).getPath()).toString());
            }
            file.elem = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
            if (!((File)file.elem).exists() || ((File)file.elem).delete()) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Error deleting index ").append(((File)file$1.elem).getPath()).toString());
        }
    }

    private long[] checkIndexAndDataFile(File index, File data, int blocks) {
        long[] lengths;
        block11: {
            long[] lArray;
            block10: {
                DataInputStream dataInputStream;
                if (index.length() != (long)(blocks + 1) * 8L) {
                    return null;
                }
                lengths = new long[blocks];
                try {
                    dataInputStream = new DataInputStream(new NioBufferedFileInputStream(index));
                }
                catch (IOException e) {
                    return null;
                }
                try (DataInputStream in = dataInputStream;){
                    try {
                        long offset = in.readLong();
                        if (offset != 0L) {
                            lArray = null;
                            break block10;
                        }
                        for (int i = 0; i < blocks; ++i) {
                            long off = in.readLong();
                            lengths[i] = off - offset;
                            offset = off;
                        }
                        break block11;
                    }
                    catch (IOException e) {
                        lArray = null;
                    }
                }
            }
            return lArray;
        }
        return (long[])(data.length() == BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) ? lengths : null);
    }

    @Override
    public StreamCallbackWithID putShuffleBlockAsStream(BlockId blockId, SerializerManager serializerManager) {
        File file;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleIndexBlockId) {
            ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId2;
            int shuffleId = shuffleIndexBlockId.shuffleId();
            long mapId = shuffleIndexBlockId.mapId();
            file = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        } else if (blockId2 instanceof ShuffleDataBlockId) {
            ShuffleDataBlockId shuffleDataBlockId = (ShuffleDataBlockId)blockId2;
            int shuffleId = shuffleDataBlockId.shuffleId();
            long mapId = shuffleDataBlockId.mapId();
            file = this.getDataFile(shuffleId, mapId);
        } else {
            throw new IllegalStateException(new StringBuilder(38).append("Unexpected shuffle block transfer ").append(blockId).append(" as ").append(blockId.getClass().getSimpleName()).toString());
        }
        File file2 = file;
        File fileTmp = Utils$.MODULE$.tempFileWith(file2);
        WritableByteChannel channel = Channels.newChannel(serializerManager.wrapStream(blockId, new FileOutputStream(fileTmp)));
        return new StreamCallbackWithID(this, blockId, channel, fileTmp, file2){
            private final /* synthetic */ IndexShuffleBlockResolver $outer;
            private final BlockId blockId$3;
            private final WritableByteChannel channel$1;
            private final File fileTmp$1;
            private final File file$2;

            public String getID() {
                return this.blockId$3.name();
            }

            public void onData(String streamId, ByteBuffer buf) {
                while (buf.hasRemaining()) {
                    this.channel$1.write(buf);
                }
            }

            public void onComplete(String streamId) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Done receiving shuffle block ").append($this.blockId$3).append(", now storing on local disk.").toString());
                this.channel$1.close();
                long diskSize = this.fileTmp$1.length();
                $anon$1 var4_3 = this;
                synchronized (var4_3) {
                    Object object = this.file$2.exists() ? BoxesRunTime.boxToBoolean((boolean)this.file$2.delete()) : BoxedUnit.UNIT;
                    if (!this.fileTmp$1.renameTo(this.file$2)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(this.fileTmp$1).append(" to ").append(this.file$2).toString());
                    }
                }
                this.$outer.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().reportBlockStatus(this.blockId$3, new BlockStatus(StorageLevel$.MODULE$.DISK_ONLY(), 0L, diskSize), this.$outer.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().reportBlockStatus$default$3());
            }

            public void onFailure(String streamId, Throwable cause) {
                this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error while uploading ").append($this.blockId$3).toString(), cause);
                this.channel$1.close();
                this.fileTmp$1.delete();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$3 = blockId$3;
                this.channel$1 = channel$1;
                this.fileTmp$1 = fileTmp$1;
                this.file$2 = file$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.spark.shuffle.IndexShuffleBlockResolver$$anon$1 ), $anonfun$onFailure$1(org.apache.spark.shuffle.IndexShuffleBlockResolver$$anon$1 )}, serializedLambda);
            }
        };
    }

    @Override
    public List<Tuple2<BlockId, ManagedBuffer>> getMigrationBlocks(ShuffleBlockInfo shuffleBlockInfo) {
        List list;
        block4: {
            try {
                int shuffleId = shuffleBlockInfo.shuffleId();
                long mapId = shuffleBlockInfo.mapId();
                File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
                ShuffleIndexBlockId indexBlockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
                long indexFileSize = indexFile.length();
                FileSegmentManagedBuffer indexBlockData = new FileSegmentManagedBuffer(this.transportConf(), indexFile, 0L, indexFileSize);
                File dataFile = this.getDataFile(shuffleId, mapId);
                ShuffleDataBlockId dataBlockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
                FileSegmentManagedBuffer dataBlockData = new FileSegmentManagedBuffer(this.transportConf(), dataFile, 0L, dataFile.length());
                if (!indexFile.exists()) {
                    throw new FileNotFoundException("Index file is deleted already.");
                }
                if (dataFile.exists()) {
                    list = new .colon.colon((Object)new Tuple2((Object)dataBlockId, (Object)dataBlockData), (List)new .colon.colon((Object)new Tuple2((Object)indexBlockId, (Object)indexBlockData), (List)Nil$.MODULE$));
                    break block4;
                }
                list = new .colon.colon((Object)new Tuple2((Object)indexBlockId, (Object)indexBlockData), (List)Nil$.MODULE$);
            }
            catch (Exception exception) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Failed to resolve shuffle block ").append(shuffleBlockInfo).append(". ").append("This is expected to occur if a block is removed after decommissioning has started.").toString());
                list = List$.MODULE$.empty();
            }
        }
        return list;
    }

    public void writeIndexFileAndCommit(int shuffleId, long mapId, long[] lengths, File dataTmp) {
        File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        File indexTmp = Utils$.MODULE$.tempFileWith(indexFile);
        try {
            File dataFile = this.getDataFile(shuffleId, mapId);
            IndexShuffleBlockResolver indexShuffleBlockResolver = this;
            synchronized (indexShuffleBlockResolver) {
                Object object;
                long[] existingLengths = this.checkIndexAndDataFile(indexFile, dataFile, lengths.length);
                if (existingLengths != null) {
                    System.arraycopy(existingLengths, 0, lengths, 0, lengths.length);
                    object = dataTmp != null && dataTmp.exists() ? BoxesRunTime.boxToBoolean((boolean)dataTmp.delete()) : BoxedUnit.UNIT;
                } else {
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexTmp)));
                    Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        LongRef offset = LongRef.create((long)0L);
                        out.writeLong(offset.elem);
                        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)length -> {
                            offset$1.elem += length;
                            out.writeLong(offset$1.elem);
                        });
                    }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
                    Object object2 = indexFile.exists() ? BoxesRunTime.boxToBoolean((boolean)indexFile.delete()) : BoxedUnit.UNIT;
                    Object object3 = dataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)dataFile.delete()) : BoxedUnit.UNIT;
                    if (!indexTmp.renameTo(indexFile)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(indexTmp).append(" to ").append(indexFile).toString());
                    }
                    if (dataTmp != null && dataTmp.exists() && !dataTmp.renameTo(dataFile)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(dataTmp).append(" to ").append(dataFile).toString());
                    }
                    object = BoxedUnit.UNIT;
                }
            }
        }
        finally {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Shuffle index for mapId ").append(mapId).append(": ").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).mkString("[", ",", "]")).toString());
            if (indexTmp.exists() && !indexTmp.delete()) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to delete temporary index file at ").append(indexTmp.getAbsolutePath()).toString());
            }
        }
    }

    @Override
    public ManagedBuffer getBlockData(BlockId blockId, Option<String[]> dirs) {
        FileSegmentManagedBuffer fileSegmentManagedBuffer;
        Tuple4 tuple4;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleBlockId) {
            ShuffleBlockId shuffleBlockId = (ShuffleBlockId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.reduceId()), (Object)BoxesRunTime.boxToInteger((int)(shuffleBlockId.reduceId() + 1)));
        } else if (blockId2 instanceof ShuffleBlockBatchId) {
            ShuffleBlockBatchId shuffleBlockBatchId = (ShuffleBlockBatchId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockBatchId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.startReduceId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.endReduceId()));
        } else {
            throw new IllegalArgumentException(new StringBuilder(36).append("unexpected shuffle block id format: ").append(blockId).toString());
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        int shuffleId = BoxesRunTime.unboxToInt((Object)tuple42._1());
        long mapId = BoxesRunTime.unboxToLong((Object)tuple42._2());
        int startReduceId = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int endReduceId = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)BoxesRunTime.boxToLong((long)mapId), (Object)BoxesRunTime.boxToInteger((int)startReduceId), (Object)BoxesRunTime.boxToInteger((int)endReduceId));
        Tuple4 tuple44 = tuple43;
        int shuffleId2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
        long mapId2 = BoxesRunTime.unboxToLong((Object)tuple44._2());
        int startReduceId2 = BoxesRunTime.unboxToInt((Object)tuple44._3());
        int endReduceId2 = BoxesRunTime.unboxToInt((Object)tuple44._4());
        File indexFile = this.getIndexFile(shuffleId2, mapId2, dirs);
        SeekableByteChannel channel = Files.newByteChannel(indexFile.toPath(), new OpenOption[0]);
        channel.position((long)startReduceId2 * 8L);
        try (DataInputStream in = new DataInputStream(Channels.newInputStream(channel));){
            long startOffset = in.readLong();
            channel.position((long)endReduceId2 * 8L);
            long endOffset = in.readLong();
            long actualPosition = channel.position();
            long expectedPosition = (long)endReduceId2 * 8L + 8L;
            if (actualPosition != expectedPosition) {
                throw new Exception(new StringBuilder(99).append("SPARK-22982: Incorrect channel position after index file reads: ").append("expected ").append(expectedPosition).append(" but actual position was ").append(actualPosition).append(".").toString());
            }
            fileSegmentManagedBuffer = new FileSegmentManagedBuffer(this.transportConf(), this.getDataFile(shuffleId2, mapId2, dirs), startOffset, endOffset - startOffset);
        }
        return fileSegmentManagedBuffer;
    }

    @Override
    public void stop() {
    }

    public IndexShuffleBlockResolver(SparkConf conf, BlockManager _blockManager) {
        this._blockManager = _blockManager;
        Logging.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3(), SparkTransportConf$.MODULE$.fromSparkConf$default$4());
    }
}

