/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001I3Aa\u0003\u0007\u0001+!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\t\r9\u0002\u0001\u0015!\u0003,\u0011\u001dy\u0003A1A\u0005\n)Ba\u0001\r\u0001!\u0002\u0013Y\u0003\"B\u0019\u0001\t\u0003\u0012\u0004B\u0002\u001f\u0001\t\u0003rQ\bC\u0003C\u0001\u0011\u00053\tC\u0003I\u0001\u0011\u0005\u0013J\u0001\u000b['R$7i\\7qe\u0016\u001c8/[8o\u0007>$Wm\u0019\u0006\u0003\u001b9\t!![8\u000b\u0005=\u0001\u0012!B:qCJ\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f\u001f\u001b\u0005a\u0011BA\u0010\r\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7-\u0001\u0003d_:4\u0007C\u0001\u0012$\u001b\u0005q\u0011B\u0001\u0013\u000f\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0003O!\u0002\"!\b\u0001\t\u000b\u0001\u0012\u0001\u0019A\u0011\u0002\u0015\t,hMZ3s'&TX-F\u0001,!\t9B&\u0003\u0002.1\t\u0019\u0011J\u001c;\u0002\u0017\t,hMZ3s'&TX\rI\u0001\u0006Y\u00164X\r\\\u0001\u0007Y\u00164X\r\u001c\u0011\u0002-\r|W\u000e\u001d:fgN,GmT;uaV$8\u000b\u001e:fC6$\"a\r\u001e\u0011\u0005QBT\"A\u001b\u000b\u000551$\"A\u001c\u0002\t)\fg/Y\u0005\u0003sU\u0012AbT;uaV$8\u000b\u001e:fC6DQaO\u0004A\u0002M\n\u0011a]\u0001!G>l\u0007O]3tg\u0016$7i\u001c8uS:,x.^:PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0006\u0002?\u0003B\u0011AgP\u0005\u0003\u0001V\u0012ACQ;gM\u0016\u0014X\rZ(viB,Ho\u0015;sK\u0006l\u0007\"B\u001e\t\u0001\u0004\u0019\u0014!F2p[B\u0014Xm]:fI&s\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0003\t\u001e\u0003\"\u0001N#\n\u0005\u0019+$aC%oaV$8\u000b\u001e:fC6DQaO\u0005A\u0002\u0011\u000bqdY8naJ,7o]3e\u0007>tG/\u001b8v_V\u001c\u0018J\u001c9viN#(/Z1n)\t!%\nC\u0003<\u0015\u0001\u0007A\t\u000b\u0002\u0001\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011qJD\u0001\u000bC:tw\u000e^1uS>t\u0017BA)O\u00051!UM^3m_B,'/\u00119j\u0001")
public class ZStdCompressionCodec
implements CompressionCodec {
    private final int bufferSize;
    private final int level;

    private int bufferSize() {
        return this.bufferSize;
    }

    private int level() {
        return this.level;
    }

    @Override
    public OutputStream compressedOutputStream(OutputStream s) {
        return new BufferedOutputStream((OutputStream)new ZstdOutputStream(s, this.level()), this.bufferSize());
    }

    @Override
    public BufferedOutputStream compressedContinuousOutputStream(OutputStream s) {
        return new BufferedOutputStream((OutputStream)new ZstdOutputStream(s, this.level()).setCloseFrameOnFlush(true), this.bufferSize());
    }

    @Override
    public InputStream compressedInputStream(InputStream s) {
        return new BufferedInputStream((InputStream)new ZstdInputStream(s), this.bufferSize());
    }

    @Override
    public InputStream compressedContinuousInputStream(InputStream s) {
        return new BufferedInputStream((InputStream)new ZstdInputStream(s).setContinuous(true), this.bufferSize());
    }

    public ZStdCompressionCodec(SparkConf conf) {
        CompressionCodec.$init$(this);
        this.bufferSize = (int)BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.IO_COMPRESSION_ZSTD_BUFFERSIZE()));
        this.level = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.IO_COMPRESSION_ZSTD_LEVEL()));
    }
}

