/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.executor.ExecutorMetrics$;
import org.apache.spark.executor.ExecutorMetricsPoller$TCMP$;
import org.apache.spark.executor.ExecutorMetricsSource;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.metrics.ExecutorMetricType$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEa!\u0002\u0016,\u00015\u001a\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006)\u0002!\t!V\u0003\u00055\u0002\u00011L\u0002\u0003b\u0001\u0011\u0013\u0007\u0002C5\u0007\u0005+\u0007I\u0011\u00016\t\u0011]4!\u0011#Q\u0001\n-D\u0001\u0002\u001f\u0004\u0003\u0016\u0004%\t!\u001f\u0005\t{\u001a\u0011\t\u0012)A\u0005u\")AK\u0002C\u0001}\"I\u0011q\u0001\u0004\u0002\u0002\u0013\u0005\u0011\u0011\u0002\u0005\n\u0003\u001f1\u0011\u0013!C\u0001\u0003#A\u0011\"a\n\u0007#\u0003%\t!!\u000b\t\u0013\u00055b!!A\u0005B\u0005=\u0002\"CA\u001f\r\u0005\u0005I\u0011AA \u0011%\t\tEBA\u0001\n\u0003\t\u0019\u0005C\u0005\u0002P\u0019\t\t\u0011\"\u0011\u0002R!I\u0011q\f\u0004\u0002\u0002\u0013\u0005\u0011\u0011\r\u0005\n\u0003W2\u0011\u0011!C!\u0003[B\u0011\"a\u001c\u0007\u0003\u0003%\t%!\u001d\t\u0013\u0005Md!!A\u0005B\u0005Ut!CA=\u0001\u0005\u0005\t\u0012BA>\r!\t\u0007!!A\t\n\u0005u\u0004B\u0002+\u0019\t\u0003\tY\tC\u0005\u0002pa\t\t\u0011\"\u0012\u0002r!I\u0011Q\u0012\r\u0002\u0002\u0013\u0005\u0015q\u0012\u0005\n\u0003+C\u0012\u0011!CA\u0003/C\u0011\"!)\u0001\u0005\u0004%I!a)\t\u0011\u0005=\u0006\u0001)A\u0005\u0003KC\u0011\"!-\u0001\u0005\u0004%I!a-\t\u0011\u0005]\u0006\u0001)A\u0005\u0003kC\u0011\"!/\u0001\u0005\u0004%I!a/\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003{Cq!a2\u0001\t\u0003\tI\rC\u0004\u0002R\u0002!\t!!3\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\"9\u00111\u001d\u0001\u0005\u0002\u0005\u0015\bbBAw\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0003s\u0004A\u0011AA~\u0011\u001d\u0011y\u0001\u0001C\u0001\u0003\u0013\u0014Q#\u0012=fGV$xN]'fiJL7m\u001d)pY2,'O\u0003\u0002-[\u0005AQ\r_3dkR|'O\u0003\u0002/_\u0005)1\u000f]1sW*\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h'\r\u0001AG\u000f\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005mrT\"\u0001\u001f\u000b\u0005uj\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005}b$a\u0002'pO\u001eLgnZ\u0001\u000e[\u0016lwN]=NC:\fw-\u001a:\u0004\u0001A\u00111IR\u0007\u0002\t*\u0011Q)L\u0001\u0007[\u0016lwN]=\n\u0005\u001d#%!D'f[>\u0014\u00180T1oC\u001e,'/A\bq_2d\u0017N\\4J]R,'O^1m!\t)$*\u0003\u0002Lm\t!Aj\u001c8h\u0003U)\u00070Z2vi>\u0014X*\u001a;sS\u000e\u001c8k\\;sG\u0016\u00042!\u000e(Q\u0013\tyeG\u0001\u0004PaRLwN\u001c\t\u0003#Jk\u0011aK\u0005\u0003'.\u0012Q#\u0012=fGV$xN]'fiJL7m]*pkJ\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005-^C\u0016\f\u0005\u0002R\u0001!)\u0001\t\u0002a\u0001\u0005\")\u0001\n\u0002a\u0001\u0013\")A\n\u0002a\u0001\u001b\nA1\u000b^1hK.+\u0017\u0010\u0005\u000369zs\u0016BA/7\u0005\u0019!V\u000f\u001d7feA\u0011QgX\u0005\u0003AZ\u00121!\u00138u\u0005\u0011!6)\u0014)\u0014\t\u0019!4M\u001a\t\u0003k\u0011L!!\u001a\u001c\u0003\u000fA\u0013x\u000eZ;diB\u0011QgZ\u0005\u0003QZ\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQaY8v]R,\u0012a\u001b\t\u0003YVl\u0011!\u001c\u0006\u0003]>\fa!\u0019;p[&\u001c'B\u00019r\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003eN\fA!\u001e;jY*\tA/\u0001\u0003kCZ\f\u0017B\u0001<n\u0005)\tEo\\7jG2{gnZ\u0001\u0007G>,h\u000e\u001e\u0011\u0002\u000bA,\u0017m[:\u0016\u0003i\u0004\"\u0001\\>\n\u0005ql'aD!u_6L7\rT8oO\u0006\u0013(/Y=\u0002\rA,\u0017m[:!)\u0015y\u00181AA\u0003!\r\t\tAB\u0007\u0002\u0001!)\u0011n\u0003a\u0001W\")\u0001p\u0003a\u0001u\u0006!1m\u001c9z)\u0015y\u00181BA\u0007\u0011\u001dIG\u0002%AA\u0002-Dq\u0001\u001f\u0007\u0011\u0002\u0003\u0007!0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M!fA6\u0002\u0016-\u0012\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003%)hn\u00195fG.,GMC\u0002\u0002\"Y\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)#a\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-\"f\u0001>\u0002\u0016\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\r\u0011\t\u0005M\u0012\u0011H\u0007\u0003\u0003kQ1!a\u000et\u0003\u0011a\u0017M\\4\n\t\u0005m\u0012Q\u0007\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003y\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002F\u0005-\u0003cA\u001b\u0002H%\u0019\u0011\u0011\n\u001c\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002NE\t\t\u00111\u0001_\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000b\t\u0007\u0003+\nY&!\u0012\u000e\u0005\u0005]#bAA-m\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0013q\u000b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002d\u0005%\u0004cA\u001b\u0002f%\u0019\u0011q\r\u001c\u0003\u000f\t{w\u000e\\3b]\"I\u0011QJ\n\u0002\u0002\u0003\u0007\u0011QI\u0001\tQ\u0006\u001c\bnQ8eKR\ta,\u0001\u0005u_N#(/\u001b8h)\t\t\t$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003G\n9\bC\u0005\u0002NY\t\t\u00111\u0001\u0002F\u0005!AkQ'Q!\r\t\t\u0001G\n\u00051\u0005}d\rE\u0004\u0002\u0002\u0006\u001d5N_@\u000e\u0005\u0005\r%bAACm\u00059!/\u001e8uS6,\u0017\u0002BAE\u0003\u0007\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\tY(A\u0003baBd\u0017\u0010F\u0003\u0000\u0003#\u000b\u0019\nC\u0003j7\u0001\u00071\u000eC\u0003y7\u0001\u0007!0A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0015Q\u0014\t\u0005k9\u000bY\n\u0005\u000369.T\b\u0002CAP9\u0005\u0005\t\u0019A@\u0002\u0007a$\u0003'A\u0005ti\u0006<W\rV\"N!V\u0011\u0011Q\u0015\t\b\u0003O\u000bI+!,\u0000\u001b\u0005y\u0017bAAV_\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0007\u0005\u0005Q!\u0001\u0006ti\u0006<W\rV\"N!\u0002\nq\u0002^1tW6+GO]5d!\u0016\f7n]\u000b\u0003\u0003k\u0003b!a*\u0002*&S\u0018\u0001\u0005;bg.lU\r\u001e:jGB+\u0017m[:!\u0003\u0019\u0001x\u000e\u001c7feV\u0011\u0011Q\u0018\t\u0005k9\u000by\f\u0005\u0003\u0002(\u0006\u0005\u0017bAAb_\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u000fA|G\u000e\\3sA\u0005!\u0001o\u001c7m)\t\tY\rE\u00026\u0003\u001bL1!a47\u0005\u0011)f.\u001b;\u0002\u000bM$\u0018M\u001d;\u0002\u0017=tG+Y:l'R\f'\u000f\u001e\u000b\t\u0003\u0017\f9.a7\u0002`\"1\u0011\u0011\\\u0013A\u0002%\u000ba\u0001^1tW&#\u0007BBAoK\u0001\u0007a,A\u0004ti\u0006<W-\u00133\t\r\u0005\u0005X\u00051\u0001_\u00039\u0019H/Y4f\u0003R$X-\u001c9u\u0013\u0012\f\u0001c\u001c8UCN\\7i\\7qY\u0016$\u0018n\u001c8\u0015\u0011\u0005-\u0017q]Au\u0003WDa!!7'\u0001\u0004I\u0005BBAoM\u0001\u0007a\f\u0003\u0004\u0002b\u001a\u0002\rAX\u0001\u0013O\u0016$H+Y:l\u001b\u0016$(/[2QK\u0006\\7\u000f\u0006\u0003\u0002r\u0006]\b\u0003B\u001b\u0002t&K1!!>7\u0005\u0015\t%O]1z\u0011\u0019\tIn\na\u0001\u0013\u0006\u0011r-\u001a;Fq\u0016\u001cW\u000f^8s+B$\u0017\r^3t)\t\ti\u0010\u0005\u0005\u0002\u0000\n\u0015\u0011Q\u0016B\u0005\u001b\t\u0011\tA\u0003\u0003\u0003\u0004\u0005]\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u0005\u000f\u0011\tAA\u0004ICNDW*\u00199\u0011\u0007E\u0013Y!C\u0002\u0003\u000e-\u0012q\"\u0012=fGV$xN]'fiJL7m]\u0001\u0005gR|\u0007\u000f")
public class ExecutorMetricsPoller
implements Logging {
    private volatile ExecutorMetricsPoller$TCMP$ TCMP$module;
    private final MemoryManager memoryManager;
    private final long pollingInterval;
    private final Option<ExecutorMetricsSource> executorMetricsSource;
    private final ConcurrentHashMap<Tuple2<Object, Object>, TCMP> stageTCMP;
    private final ConcurrentHashMap<Object, AtomicLongArray> taskMetricPeaks;
    private final Option<ScheduledExecutorService> poller;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    private ExecutorMetricsPoller$TCMP$ TCMP() {
        if (this.TCMP$module == null) {
            this.TCMP$lzycompute$1();
        }
        return this.TCMP$module;
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<Tuple2<Object, Object>, TCMP> stageTCMP() {
        return this.stageTCMP;
    }

    private ConcurrentHashMap<Object, AtomicLongArray> taskMetricPeaks() {
        return this.taskMetricPeaks;
    }

    private Option<ScheduledExecutorService> poller() {
        return this.poller;
    }

    public void poll() {
        long[] latestMetrics = ExecutorMetrics$.MODULE$.getCurrentMetrics(this.memoryManager);
        this.executorMetricsSource.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.updateMetricsSnapshot(latestMetrics);
            return BoxedUnit.UNIT;
        });
        this.stageTCMP().forEachValue(Long.MAX_VALUE, v -> ExecutorMetricsPoller.updatePeaks$1(v.peaks(), latestMetrics));
        this.taskMetricPeaks().forEachValue(Long.MAX_VALUE, metrics -> ExecutorMetricsPoller.updatePeaks$1(metrics, latestMetrics));
    }

    public void start() {
        this.poller().foreach((Function1 & Serializable & scala.Serializable)exec -> {
            Runnable pollingTask = () -> Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.poll());
            return exec.scheduleAtFixedRate(pollingTask, 0L, $this.pollingInterval, TimeUnit.MILLISECONDS);
        });
    }

    public void onTaskStart(long taskId, int stageId, int stageAttemptId) {
        this.taskMetricPeaks().put(BoxesRunTime.boxToLong((long)taskId), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
        TCMP countAndPeaks = this.stageTCMP().computeIfAbsent((Tuple2<Object, Object>)new Tuple2.mcII.sp(stageId, stageAttemptId), x$2 -> new TCMP(this, new AtomicLong(0L), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics())));
        long stageCount = countAndPeaks.count().incrementAndGet();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("stageTCMP: (").append(stageId).append(", ").append(stageAttemptId).append(") -> ").append(stageCount).toString());
    }

    public void onTaskCompletion(long taskId, int stageId, int stageAttemptId) {
        this.stageTCMP().computeIfPresent((Tuple2<Object, Object>)new Tuple2.mcII.sp(stageId, stageAttemptId), (stage, countAndPeaks) -> this.decrementCount$1((Tuple2)stage, (TCMP)countAndPeaks));
        this.taskMetricPeaks().remove(BoxesRunTime.boxToLong((long)taskId));
    }

    public long[] getTaskMetricPeaks(long taskId) {
        long[] metricPeaks;
        block0: {
            AtomicLongArray currentPeaks = this.taskMetricPeaks().get(BoxesRunTime.boxToLong((long)taskId));
            metricPeaks = new long[ExecutorMetricType$.MODULE$.numMetrics()];
            if (currentPeaks == null) break block0;
            ExecutorMetricType$.MODULE$.metricToOffset().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExecutorMetricsPoller.$anonfun$getTaskMetricPeaks$1(metricPeaks, currentPeaks, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return metricPeaks;
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<Tuple2<Object, Object>, ExecutorMetrics> getExecutorUpdates() {
        void var1_1;
        HashMap executorUpdates = new HashMap();
        this.stageTCMP().replaceAll((k, v) -> this.getUpdateAndResetPeaks$1((Tuple2)k, (TCMP)v, executorUpdates));
        return var1_1;
    }

    public void stop() {
        this.poller().foreach((Function1 & Serializable & scala.Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)ExecutorMetricsPoller.$anonfun$stop$1(exec)));
    }

    private final void TCMP$lzycompute$1() {
        ExecutorMetricsPoller executorMetricsPoller = this;
        synchronized (executorMetricsPoller) {
            if (this.TCMP$module == null) {
                this.TCMP$module = new ExecutorMetricsPoller$TCMP$(this);
            }
        }
    }

    private static final void updatePeaks$1(AtomicLongArray metrics, long[] latestMetrics$1) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), metrics.length()).foreach((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> metrics.getAndAccumulate(i, latestMetrics$1[i], (x, y) -> package$.MODULE$.max(x, y)));
    }

    private final TCMP decrementCount$1(Tuple2 stage, TCMP countAndPeaks) {
        TCMP tCMP;
        long countValue = countAndPeaks.count().decrementAndGet();
        if (countValue == 0L) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("removing (").append(stage._1$mcI$sp()).append(", ").append(stage._2$mcI$sp()).append(") from stageTCMP").toString());
            tCMP = null;
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("stageTCMP: (").append(stage._1$mcI$sp()).append(", ").append(stage._2$mcI$sp()).append(") -> ").append(countValue).toString());
            tCMP = countAndPeaks;
        }
        return tCMP;
    }

    public static final /* synthetic */ void $anonfun$getTaskMetricPeaks$1(long[] metricPeaks$1, AtomicLongArray currentPeaks$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int i = tuple2._2$mcI$sp();
        metricPeaks$1[i] = currentPeaks$1.get(i);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final TCMP getUpdateAndResetPeaks$1(Tuple2 k, TCMP v, HashMap executorUpdates$1) {
        executorUpdates$1.put((Object)k, (Object)new ExecutorMetrics(v.peaks()));
        return new TCMP(this, v.count(), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
    }

    public static final /* synthetic */ boolean $anonfun$stop$1(ScheduledExecutorService exec) {
        exec.shutdown();
        return exec.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public ExecutorMetricsPoller(MemoryManager memoryManager, long pollingInterval, Option<ExecutorMetricsSource> executorMetricsSource) {
        this.memoryManager = memoryManager;
        this.pollingInterval = pollingInterval;
        this.executorMetricsSource = executorMetricsSource;
        Logging.$init$(this);
        this.stageTCMP = new ConcurrentHashMap();
        this.taskMetricPeaks = new ConcurrentHashMap();
        this.poller = pollingInterval > 0L ? new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("executor-metrics-poller")) : None$.MODULE$;
    }

    public class TCMP
    implements Product,
    scala.Serializable {
        private final AtomicLong count;
        private final AtomicLongArray peaks;
        public final /* synthetic */ ExecutorMetricsPoller $outer;

        public AtomicLong count() {
            return this.count;
        }

        public AtomicLongArray peaks() {
            return this.peaks;
        }

        public TCMP copy(AtomicLong count, AtomicLongArray peaks) {
            return new TCMP(this.org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer(), count, peaks);
        }

        public AtomicLong copy$default$1() {
            return this.count();
        }

        public AtomicLongArray copy$default$2() {
            return this.peaks();
        }

        public String productPrefix() {
            return "TCMP";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Serializable serializable;
            int n = x$1;
            switch (n) {
                case 0: {
                    serializable = this.count();
                    break;
                }
                case 1: {
                    serializable = this.peaks();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return serializable;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TCMP;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TCMP)) return false;
            if (((TCMP)object).org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer() != this.org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TCMP tCMP = (TCMP)x$1;
            if (!BoxesRunTime.equalsNumNum((Number)this.count(), (Number)tCMP.count())) return false;
            AtomicLongArray atomicLongArray = this.peaks();
            AtomicLongArray atomicLongArray2 = tCMP.peaks();
            if (atomicLongArray == null) {
                if (atomicLongArray2 != null) {
                    return false;
                }
            } else if (!atomicLongArray.equals(atomicLongArray2)) return false;
            if (!tCMP.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ExecutorMetricsPoller org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer() {
            return this.$outer;
        }

        public TCMP(ExecutorMetricsPoller $outer, AtomicLong count, AtomicLongArray peaks) {
            this.count = count;
            this.peaks = peaks;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

