/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandrainput;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.databases.cassandra.metadata.CassandraConnection;
import org.apache.hop.databases.cassandra.spi.Connection;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.databases.cassandra.util.CqlUtils;
import org.apache.hop.databases.cassandra.util.Selector;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cassandrainput.CassandraInput;
import org.apache.hop.pipeline.transforms.cassandrainput.CassandraInputData;
import org.apache.hop.pipeline.transforms.cassandrainput.CassandraInputDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;

@Transform(id="CassandraInput", image="Cassandrain.svg", name="Cassandra input", description="Reads data from a Cassandra table", documentationUrl="/pipeline/transforms/cassandra-input.html", keywords={"i18n::CassandraInputMeta.keyword"}, categoryDescription="Cassandra")
@InjectionSupported(localizationPrefix="CassandraInput.Injection.")
public class CassandraInputMeta
extends BaseTransformMeta<CassandraInput, CassandraInputData> {
    protected static final Class<?> PKG = CassandraInputMeta.class;
    @Injection(name="CONNECTION")
    protected String connectionName;
    @Injection(name="CQL_QUERY")
    protected String cqlSelectQuery = "SELECT <fields> FROM <table> WHERE <condition>;";
    @Injection(name="EXECUTE_FOR_EACH_ROW")
    protected boolean executeForEachIncomingRow;
    @Injection(name="TRANSPORT_MAX_LENGTH")
    protected String maxLength = "";
    protected boolean isSelectStarQuery = false;
    protected int rowLimit = -1;
    protected int colLimit = -1;
    protected int rowBatchSize = 100;
    protected int colBatchSize = 100;
    protected List<String> specificCols;
    private boolean useDriver = true;

    public String getXml() {
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHandler.addTagValue((String)"connection", (String)this.connectionName));
        xml.append(XmlHandler.addTagValue((String)"cql_select_query", (String)this.cqlSelectQuery));
        xml.append(XmlHandler.addTagValue((String)"max_length", (String)this.maxLength));
        xml.append(XmlHandler.addTagValue((String)"execute_for_each_row", (boolean)this.executeForEachIncomingRow));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.connectionName = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
        this.cqlSelectQuery = XmlHandler.getTagValue((Node)transformNode, (String)"cql_select_query");
        this.executeForEachIncomingRow = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"execute_for_each_row"));
        this.maxLength = XmlHandler.getTagValue((Node)transformNode, (String)"max_length");
    }

    public void setDefault() {
        this.cqlSelectQuery = "SELECT <fields> FROM <table> WHERE <condition>;";
        this.maxLength = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        this.specificCols = null;
        this.rowLimit = -1;
        this.colLimit = -1;
        rowMeta.clear();
        if (Utils.isEmpty((CharSequence)this.connectionName)) {
            throw new HopTransformException("Please specify a Cassandra connection name to use");
        }
        String tableName = null;
        if (!Utils.isEmpty((CharSequence)this.cqlSelectQuery)) {
            Keyspace kSpace;
            String subQ = variables.resolve(this.cqlSelectQuery);
            if (!subQ.toLowerCase().startsWith("select")) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.NoSelectInQuery", (String[])new String[0]));
            }
            if (subQ.indexOf(59) < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.QueryTermination", (String[])new String[0]));
            }
            if (subQ.toLowerCase().indexOf("limit") > 0) {
                String limitS = subQ.toLowerCase().substring(subQ.toLowerCase().indexOf("limit") + 5, subQ.length()).trim();
                limitS = limitS.replaceAll(";", "");
                try {
                    this.rowLimit = Integer.parseInt(limitS);
                }
                catch (NumberFormatException ex) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.UnableToParseLimitClause", (String[])new String[]{this.cqlSelectQuery}));
                }
            }
            if (subQ.toLowerCase().lastIndexOf("where") > 0) {
                subQ = subQ.substring(0, subQ.toLowerCase().lastIndexOf("where"));
            }
            int fromIndex = subQ.toLowerCase().indexOf("from");
            String tempS = subQ.toLowerCase();
            int offset = fromIndex;
            while (fromIndex > 0 && tempS.charAt(fromIndex - 1) != ' ' && fromIndex + 4 < tempS.length() && tempS.charAt(fromIndex + 4) != ' ') {
                tempS = tempS.substring(fromIndex + 4, tempS.length());
                fromIndex = tempS.indexOf("from");
                offset += 4 + fromIndex;
            }
            fromIndex = offset;
            if (fromIndex < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.MustSpecifyATable", (String[])new String[0]));
            }
            tableName = subQ.substring(fromIndex + 4, subQ.length()).trim();
            tableName = tableName.indexOf(32) > 0 ? tableName.substring(0, tableName.indexOf(32)) : tableName.replace(";", "");
            if (tableName.length() == 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.MustSpecifyATable", (String[])new String[0]));
            }
            tableName = tableName.replaceFirst("^\\s+", "").replaceFirst("\\s+$", "");
            if (subQ.toLowerCase().indexOf("first ") > 0) {
                String firstS = subQ.substring(subQ.toLowerCase().indexOf("first") + 5, subQ.length()).trim();
                subQ = firstS.substring(firstS.indexOf(32) + 1, firstS.length());
                firstS = firstS.substring(0, firstS.indexOf(32));
                try {
                    this.colLimit = Integer.parseInt(firstS);
                }
                catch (NumberFormatException ex) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"CassandraInput.Error.UnableToParseFirstClause", (String[])new String[]{this.cqlSelectQuery}));
                }
            } else {
                subQ = subQ.substring(subQ.toLowerCase().indexOf("select") + 6, subQ.length());
            }
            fromIndex = subQ.toLowerCase().indexOf("from");
            Selector[] cols = null;
            if (subQ.contains("*") && !subQ.toLowerCase().contains("count(*)")) {
                this.isSelectStarQuery = true;
            } else {
                this.isSelectStarQuery = false;
                String colsS = subQ.substring(0, fromIndex);
                cols = CqlUtils.getColumnsInSelect(colsS, true);
            }
            Connection conn = null;
            try {
                CassandraConnection cassandraConnection = (CassandraConnection)metadataProvider.getSerializer(CassandraConnection.class).load(variables.resolve(this.connectionName));
                conn = cassandraConnection.createConnection(variables, false);
                kSpace = cassandraConnection.lookupKeyspace(conn, variables);
            }
            catch (Exception e) {
                throw new HopTransformException("Unable to connect to Cassandra with '" + this.connectionName + "' or look up the keyspace", (Throwable)e);
            }
            try {
                ITableMetaData colMeta = kSpace.getTableMetaData(tableName);
                if (cols == null) {
                    List<IValueMeta> vms = colMeta.getValueMetasForSchema();
                    for (IValueMeta vm : vms) {
                        rowMeta.addValueMeta(vm);
                    }
                } else {
                    this.specificCols = new ArrayList<String>();
                    for (Selector col : cols) {
                        if (!col.isFunction() && !colMeta.columnExistsInSchema(col.getColumnName())) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"CassandraInput.Info.DefaultColumnValidator", (Object[])new Object[]{col}));
                        }
                        IValueMeta vm = colMeta.getValueMeta(col);
                        rowMeta.addValueMeta(vm);
                    }
                }
            }
            catch (Exception ex) {
                this.logBasic(BaseMessages.getString(PKG, (String)"CassandraInput.Info.UnableToRetrieveColumnMetaData", (String[])new String[]{tableName}), new Object[]{ex});
            }
            finally {
                try {
                    conn.closeConnection();
                }
                catch (Exception e) {
                    throw new HopTransformException((Throwable)e);
                }
            }
        }
    }

    public boolean isUseDriver() {
        return this.useDriver;
    }

    public ITransformDialog getDialog(Shell shell, IVariables variables, ITransformMeta meta, PipelineMeta pipelineMeta, String name) {
        return new CassandraInputDialog(shell, variables, meta, pipelineMeta, name);
    }

    public String getCqlSelectQuery() {
        return this.cqlSelectQuery;
    }

    public void setCqlSelectQuery(String cqlSelectQuery) {
        this.cqlSelectQuery = cqlSelectQuery;
    }

    public boolean isExecuteForEachIncomingRow() {
        return this.executeForEachIncomingRow;
    }

    public void setExecuteForEachIncomingRow(boolean executeForEachIncomingRow) {
        this.executeForEachIncomingRow = executeForEachIncomingRow;
    }

    public String getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(String maxLength) {
        this.maxLength = maxLength;
    }

    public boolean isSelectStarQuery() {
        return this.isSelectStarQuery;
    }

    public void setSelectStarQuery(boolean selectStarQuery) {
        this.isSelectStarQuery = selectStarQuery;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getColLimit() {
        return this.colLimit;
    }

    public void setColLimit(int colLimit) {
        this.colLimit = colLimit;
    }

    public int getRowBatchSize() {
        return this.rowBatchSize;
    }

    public void setRowBatchSize(int rowBatchSize) {
        this.rowBatchSize = rowBatchSize;
    }

    public int getColBatchSize() {
        return this.colBatchSize;
    }

    public void setColBatchSize(int colBatchSize) {
        this.colBatchSize = colBatchSize;
    }

    public List<String> getSpecificCols() {
        return this.specificCols;
    }

    public void setSpecificCols(List<String> specificCols) {
        this.specificCols = specificCols;
    }

    public void setUseDriver(boolean useDriver) {
        this.useDriver = useDriver;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }
}

