/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.gui;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hop.beam.pipeline.fatjar.FatJarBuilder;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

@GuiPlugin
public class HopBeamGuiPlugin {
    public static final Class<?> PKG = HopBeamGuiPlugin.class;
    public static final String ID_MAIN_MENU_TOOLS_FAT_JAR = "40200-menu-tools-fat-jar";
    public static final String ID_MAIN_MENU_TOOLS_EXPORT_METADATA = "40210-menu-tools-export-metadata";
    private static HopBeamGuiPlugin instance;

    public static HopBeamGuiPlugin getInstance() {
        if (instance == null) {
            instance = new HopBeamGuiPlugin();
        }
        return instance;
    }

    @GuiMenuElement(root="HopGui-Menu", id="40200-menu-tools-fat-jar", label="i18n::BeamGuiPlugin.Menu.GenerateFatJar.Text", parentId="40000-menu-tools", separator=true)
    public void menuToolsFatJar() {
        HopGui hopGui = HopGui.getInstance();
        Shell shell = hopGui.getShell();
        MessageBox box = new MessageBox(shell, 290);
        box.setText(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.GenerateFatJar.Dialog.Header", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.GenerateFatJar.Dialog.Message1", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"BeamGuiPlugin.GenerateFatJar.Dialog.Message2", (String[])new String[0]));
        int answer = box.open();
        if ((answer & 0x100) != 0) {
            return;
        }
        String filename = BaseDialog.presentFileDialog((boolean)true, (Shell)shell, (String[])new String[]{"*.jar", "*.*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FileTypes.Jars.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FileTypes.All.Label", (String[])new String[0])}, (boolean)true);
        if (filename == null) {
            return;
        }
        try {
            List<String> jarFilenames = HopBeamGuiPlugin.findInstalledJarFilenames();
            IRunnableWithProgress op = monitor -> {
                try {
                    monitor.setTaskName(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.GenerateFatJar.Progress.Message", (String[])new String[0]));
                    FatJarBuilder fatJarBuilder = new FatJarBuilder(hopGui.getLog(), hopGui.getVariables(), filename, jarFilenames);
                    fatJarBuilder.setExtraTransformPluginClasses(null);
                    fatJarBuilder.setExtraXpPluginClasses(null);
                    fatJarBuilder.buildTargetJar();
                    monitor.done();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "Error building fat jar: " + e.getMessage());
                }
            };
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
            pmd.run(false, op);
            GuiResource.getInstance().toClipboard(filename);
            box = new MessageBox(shell, 66);
            box.setText(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FatJarCreated.Dialog.Header", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FatJarCreated.Dialog.Message1", (String[])new String[]{filename}) + Const.CR + BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FatJarCreated.Dialog.Message2", (String[])new String[0]));
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(shell, "Error", "Error creating fat jar", e);
        }
    }

    @GuiMenuElement(root="HopGui-Menu", id="40210-menu-tools-export-metadata", label="i18n::BeamGuiPlugin.Menu.ExportMetadata.Text", parentId="40000-menu-tools", separator=true)
    public void menuToolsExportMetadata() {
        HopGui hopGui = HopGui.getInstance();
        Shell shell = hopGui.getShell();
        MessageBox box = new MessageBox(shell, 290);
        box.setText(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.ExportMetadata.Dialog.Header", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"BeamGuiPlugin.ExportMetadata.Dialog.Message", (String[])new String[0]));
        int answer = box.open();
        if ((answer & 0x100) != 0) {
            return;
        }
        String filename = BaseDialog.presentFileDialog((boolean)true, (Shell)shell, (String[])new String[]{"*.json", "*.*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FileTypes.Json.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BeamGuiPlugin.FileTypes.All.Label", (String[])new String[0])}, (boolean)true);
        if (filename == null) {
            return;
        }
        try {
            SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider((IHopMetadataProvider)hopGui.getMetadataProvider());
            String jsonString = metadataProvider.toJson();
            String realFilename = hopGui.getVariables().resolve(filename);
            try (OutputStream outputStream = HopVfs.getOutputStream((String)realFilename, (boolean)false);){
                outputStream.write(jsonString.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            new ErrorDialog(shell, "Error", "Error saving metadata to JSON file : " + filename, e);
        }
    }

    public static final List<String> findInstalledJarFilenames() {
        HashSet jarFiles = new HashSet();
        jarFiles.addAll(FileUtils.listFiles((File)new File("lib"), (String[])new String[]{"jar"}, (boolean)true));
        jarFiles.addAll(FileUtils.listFiles((File)new File("libswt/linux/x86_64"), (String[])new String[]{"jar"}, (boolean)true));
        jarFiles.addAll(FileUtils.listFiles((File)new File("plugins"), (String[])new String[]{"jar"}, (boolean)true));
        ArrayList<String> jarFilenames = new ArrayList<String>();
        jarFiles.forEach(file -> jarFilenames.add(file.toString()));
        return jarFilenames;
    }
}

