/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.RateLimiter;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.Rebufferer;

public class LimitingRebufferer
implements Rebufferer,
Rebufferer.BufferHolder {
    private final Rebufferer wrapped;
    private final RateLimiter limiter;
    private final int limitQuant;
    private Rebufferer.BufferHolder bufferHolder;
    private ByteBuffer buffer;
    private long offset;

    public LimitingRebufferer(Rebufferer wrapped, RateLimiter limiter, int limitQuant) {
        this.wrapped = wrapped;
        this.limiter = limiter;
        this.limitQuant = limitQuant;
    }

    @Override
    public Rebufferer.BufferHolder rebuffer(long position) {
        this.bufferHolder = this.wrapped.rebuffer(position);
        this.buffer = this.bufferHolder.buffer();
        this.offset = this.bufferHolder.offset();
        int posInBuffer = Ints.checkedCast((long)(position - this.offset));
        int remaining = this.buffer.limit() - posInBuffer;
        if (remaining == 0) {
            return this;
        }
        if (remaining > this.limitQuant) {
            this.buffer.limit(posInBuffer + this.limitQuant);
            remaining = this.limitQuant;
        }
        this.limiter.acquire(remaining);
        return this;
    }

    @Override
    public ChannelProxy channel() {
        return this.wrapped.channel();
    }

    @Override
    public long fileLength() {
        return this.wrapped.fileLength();
    }

    @Override
    public double getCrcCheckChance() {
        return this.wrapped.getCrcCheckChance();
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    @Override
    public void closeReader() {
        this.wrapped.closeReader();
    }

    public String toString() {
        return "LimitingRebufferer[" + this.limiter.toString() + "]:" + this.wrapped.toString();
    }

    @Override
    public ByteBuffer buffer() {
        return this.buffer;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public void release() {
        this.bufferHolder.release();
    }
}

