/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.DiskBoundaries;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionLogger;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledGenerations;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableDeletingNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.cassandra.notifications.SSTableRepairStatusChanged;
import org.apache.cassandra.schema.CompactionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionStrategyManager
implements INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(CompactionStrategyManager.class);
    public final CompactionLogger compactionLogger;
    private final ColumnFamilyStore cfs;
    private final boolean partitionSSTablesByTokenRange;
    private final Supplier<DiskBoundaries> boundariesSupplier;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final List<AbstractCompactionStrategy> repaired = new ArrayList<AbstractCompactionStrategy>();
    private final List<AbstractCompactionStrategy> unrepaired = new ArrayList<AbstractCompactionStrategy>();
    private volatile CompactionParams params;
    private DiskBoundaries currentBoundaries;
    private volatile boolean enabled = true;
    private volatile boolean isActive = true;
    private volatile CompactionParams schemaCompactionParams;
    private volatile boolean supportsEarlyOpen;
    private volatile int fanout;
    private volatile long maxSSTableSizeBytes;
    private volatile String name;

    public CompactionStrategyManager(ColumnFamilyStore cfs) {
        this(cfs, cfs::getDiskBoundaries, cfs.getPartitioner().splitter().isPresent());
    }

    @VisibleForTesting
    public CompactionStrategyManager(ColumnFamilyStore cfs, Supplier<DiskBoundaries> boundariesSupplier, boolean partitionSSTablesByTokenRange) {
        cfs.getTracker().subscribe(this);
        logger.trace("{} subscribed to the data tracker.", (Object)this);
        this.cfs = cfs;
        this.compactionLogger = new CompactionLogger(cfs, this);
        this.boundariesSupplier = boundariesSupplier;
        this.partitionSSTablesByTokenRange = partitionSSTablesByTokenRange;
        this.params = cfs.metadata.params.compaction;
        this.enabled = this.params.isEnabled();
        this.reload(cfs.metadata.params.compaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCompactionTask getNextBackgroundTask(int gcBefore) {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            if (!this.isEnabled()) {
                AbstractCompactionTask abstractCompactionTask = null;
                return abstractCompactionTask;
            }
            ArrayList<AbstractCompactionStrategy> strategies = new ArrayList<AbstractCompactionStrategy>();
            strategies.addAll(this.repaired);
            strategies.addAll(this.unrepaired);
            Collections.sort(strategies, (o1, o2) -> Ints.compare((int)o2.getEstimatedRemainingTasks(), (int)o1.getEstimatedRemainingTasks()));
            for (AbstractCompactionStrategy strategy : strategies) {
                AbstractCompactionTask task = strategy.getNextBackgroundTask(gcBefore);
                if (task == null) continue;
                AbstractCompactionTask abstractCompactionTask = task;
                return abstractCompactionTask;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled && this.isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void resume() {
        this.writeLock.lock();
        try {
            this.isActive = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void pause() {
        this.writeLock.lock();
        try {
            this.isActive = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void startup() {
        this.writeLock.lock();
        try {
            for (SSTableReader sstable : this.cfs.getSSTables(SSTableSet.CANONICAL)) {
                if (sstable.openReason == SSTableReader.OpenReason.EARLY) continue;
                this.compactionStrategyFor(sstable).addSSTable(sstable);
            }
            this.repaired.forEach(AbstractCompactionStrategy::startup);
            this.unrepaired.forEach(AbstractCompactionStrategy::startup);
            this.supportsEarlyOpen = this.repaired.get(0).supportsEarlyOpen();
            this.fanout = this.repaired.get(0) instanceof LeveledCompactionStrategy ? ((LeveledCompactionStrategy)this.repaired.get(0)).getLevelFanoutSize() : 10;
            this.name = this.repaired.get(0).getName();
            this.maxSSTableSizeBytes = this.repaired.get(0).getMaxSSTableBytes();
        }
        finally {
            this.writeLock.unlock();
        }
        this.repaired.forEach(AbstractCompactionStrategy::startup);
        this.unrepaired.forEach(AbstractCompactionStrategy::startup);
        if (Stream.concat(this.repaired.stream(), this.unrepaired.stream()).anyMatch(cs -> cs.logAll)) {
            this.compactionLogger.enable();
        }
    }

    protected AbstractCompactionStrategy getCompactionStrategyFor(SSTableReader sstable) {
        this.maybeReloadDiskBoundaries();
        return this.compactionStrategyFor(sstable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected AbstractCompactionStrategy compactionStrategyFor(SSTableReader sstable) {
        this.readLock.lock();
        try {
            int index = this.compactionStrategyIndexFor(sstable);
            if (sstable.isRepaired()) {
                AbstractCompactionStrategy abstractCompactionStrategy = this.repaired.get(index);
                return abstractCompactionStrategy;
            }
            AbstractCompactionStrategy abstractCompactionStrategy = this.unrepaired.get(index);
            return abstractCompactionStrategy;
        }
        finally {
            this.readLock.unlock();
        }
    }

    int compactionStrategyIndexFor(SSTableReader sstable) {
        this.readLock.lock();
        try {
            if (!this.partitionSSTablesByTokenRange) {
                int n = 0;
                return n;
            }
            int n = this.currentBoundaries.getDiskIndex(sstable);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void shutdown() {
        this.writeLock.lock();
        try {
            this.isActive = false;
            this.repaired.forEach(AbstractCompactionStrategy::shutdown);
            this.unrepaired.forEach(AbstractCompactionStrategy::shutdown);
            this.compactionLogger.disable();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void maybeReload(CFMetaData metadata) {
        if (metadata.params.compaction.equals(this.schemaCompactionParams)) {
            return;
        }
        this.writeLock.lock();
        try {
            if (metadata.params.compaction.equals(this.schemaCompactionParams)) {
                return;
            }
            this.reload(metadata.params.compaction);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    protected void maybeReloadDiskBoundaries() {
        if (!this.currentBoundaries.isOutOfDate()) {
            return;
        }
        this.writeLock.lock();
        try {
            if (!this.currentBoundaries.isOutOfDate()) {
                return;
            }
            this.reload(this.params);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void reload(CompactionParams newCompactionParams) {
        boolean disabledWithJMX;
        boolean enabledWithJMX = this.enabled && !this.shouldBeEnabled();
        boolean bl = disabledWithJMX = !this.enabled && this.shouldBeEnabled();
        if (this.currentBoundaries != null) {
            if (!newCompactionParams.equals(this.schemaCompactionParams)) {
                logger.debug("Recreating compaction strategy - compaction parameters changed for {}.{}", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.getTableName());
            } else if (this.currentBoundaries.isOutOfDate()) {
                logger.debug("Recreating compaction strategy - disk boundaries are out of date for {}.{}.", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.getTableName());
            }
        }
        if (this.currentBoundaries == null || this.currentBoundaries.isOutOfDate()) {
            this.currentBoundaries = this.boundariesSupplier.get();
        }
        this.setStrategy(newCompactionParams);
        this.schemaCompactionParams = this.cfs.metadata.params.compaction;
        if (disabledWithJMX || !this.shouldBeEnabled() && !enabledWithJMX) {
            this.disable();
        } else {
            this.enable();
        }
        this.startup();
    }

    public void replaceFlushed(Memtable memtable, Collection<SSTableReader> sstables) {
        this.cfs.getTracker().replaceFlushed(memtable, sstables);
        if (sstables != null && !sstables.isEmpty()) {
            CompactionManager.instance.submitBackground(this.cfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnleveledSSTables() {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            if (this.repaired.get(0) instanceof LeveledCompactionStrategy && this.unrepaired.get(0) instanceof LeveledCompactionStrategy) {
                int count = 0;
                for (AbstractCompactionStrategy strategy : this.repaired) {
                    count += ((LeveledCompactionStrategy)strategy).getLevelSize(0);
                }
                for (AbstractCompactionStrategy strategy : this.unrepaired) {
                    count += ((LeveledCompactionStrategy)strategy).getLevelSize(0);
                }
                int n = count;
                return n;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return 0;
    }

    public int getLevelFanoutSize() {
        return this.fanout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getSSTableCountPerLevel() {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            if (this.repaired.get(0) instanceof LeveledCompactionStrategy && this.unrepaired.get(0) instanceof LeveledCompactionStrategy) {
                int[] res = new int[LeveledGenerations.MAX_LEVEL_COUNT];
                for (AbstractCompactionStrategy strategy : this.repaired) {
                    int[] repairedCountPerLevel = ((LeveledCompactionStrategy)strategy).getAllLevelSize();
                    res = CompactionStrategyManager.sumArrays(res, repairedCountPerLevel);
                }
                for (AbstractCompactionStrategy strategy : this.unrepaired) {
                    int[] unrepairedCountPerLevel = ((LeveledCompactionStrategy)strategy).getAllLevelSize();
                    res = CompactionStrategyManager.sumArrays(res, unrepairedCountPerLevel);
                }
                Object object = res;
                return object;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    private static int[] sumArrays(int[] a, int[] b) {
        int[] res = new int[Math.max(a.length, b.length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < a.length && i < b.length ? a[i] + b[i] : (i < a.length ? a[i] : b[i]);
        }
        return res;
    }

    public Directories getDirectories() {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            assert (this.repaired.get(0).getClass().equals(this.unrepaired.get(0).getClass()));
            Directories directories = this.repaired.get(0).getDirectories();
            return directories;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void handleFlushNotification(Iterable<SSTableReader> added) {
        for (SSTableReader sstable : added) {
            this.compactionStrategyFor(sstable).addSSTable(sstable);
        }
    }

    private void handleListChangedNotification(Iterable<SSTableReader> added, Iterable<SSTableReader> removed) {
        int i;
        int locationSize = this.partitionSSTablesByTokenRange ? this.currentBoundaries.directories.size() : 1;
        ArrayList repairedRemoved = new ArrayList(locationSize);
        ArrayList repairedAdded = new ArrayList(locationSize);
        ArrayList unrepairedRemoved = new ArrayList(locationSize);
        ArrayList unrepairedAdded = new ArrayList(locationSize);
        for (int i2 = 0; i2 < locationSize; ++i2) {
            repairedRemoved.add(new HashSet());
            repairedAdded.add(new HashSet());
            unrepairedRemoved.add(new HashSet());
            unrepairedAdded.add(new HashSet());
        }
        for (SSTableReader sstable : removed) {
            i = this.compactionStrategyIndexFor(sstable);
            if (sstable.isRepaired()) {
                ((Set)repairedRemoved.get(i)).add(sstable);
                continue;
            }
            ((Set)unrepairedRemoved.get(i)).add(sstable);
        }
        for (SSTableReader sstable : added) {
            i = this.compactionStrategyIndexFor(sstable);
            if (sstable.isRepaired()) {
                ((Set)repairedAdded.get(i)).add(sstable);
                continue;
            }
            ((Set)unrepairedAdded.get(i)).add(sstable);
        }
        for (int i3 = 0; i3 < locationSize; ++i3) {
            if (!((Set)repairedRemoved.get(i3)).isEmpty()) {
                this.repaired.get(i3).replaceSSTables((Collection)repairedRemoved.get(i3), (Collection)repairedAdded.get(i3));
            } else {
                this.repaired.get(i3).addSSTables((Iterable)repairedAdded.get(i3));
            }
            if (!((Set)unrepairedRemoved.get(i3)).isEmpty()) {
                this.unrepaired.get(i3).replaceSSTables((Collection)unrepairedRemoved.get(i3), (Collection)unrepairedAdded.get(i3));
                continue;
            }
            this.unrepaired.get(i3).addSSTables((Iterable)unrepairedAdded.get(i3));
        }
    }

    private void handleRepairStatusChangedNotification(Iterable<SSTableReader> sstables) {
        for (SSTableReader sstable : sstables) {
            int index = this.compactionStrategyIndexFor(sstable);
            if (sstable.isRepaired()) {
                this.unrepaired.get(index).removeSSTable(sstable);
                this.repaired.get(index).addSSTable(sstable);
                continue;
            }
            this.repaired.get(index).removeSSTable(sstable);
            this.unrepaired.get(index).addSSTable(sstable);
        }
    }

    private void handleDeletingNotification(SSTableReader deleted) {
        this.compactionStrategyFor(deleted).removeSSTable(deleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(INotification notification, Object sender) {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            if (notification instanceof SSTableAddedNotification) {
                this.handleFlushNotification(((SSTableAddedNotification)notification).added);
            } else if (notification instanceof SSTableListChangedNotification) {
                SSTableListChangedNotification listChangedNotification = (SSTableListChangedNotification)notification;
                this.handleListChangedNotification(listChangedNotification.added, listChangedNotification.removed);
            } else if (notification instanceof SSTableRepairStatusChanged) {
                this.handleRepairStatusChangedNotification(((SSTableRepairStatusChanged)notification).sstables);
            } else if (notification instanceof SSTableDeletingNotification) {
                this.handleDeletingNotification(((SSTableDeletingNotification)notification).deleting);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enable() {
        this.writeLock.lock();
        try {
            if (this.repaired != null) {
                this.repaired.forEach(AbstractCompactionStrategy::enable);
            }
            if (this.unrepaired != null) {
                this.unrepaired.forEach(AbstractCompactionStrategy::enable);
            }
            this.enabled = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void disable() {
        this.writeLock.lock();
        try {
            this.enabled = false;
            if (this.repaired != null) {
                this.repaired.forEach(AbstractCompactionStrategy::disable);
            }
            if (this.unrepaired != null) {
                this.unrepaired.forEach(AbstractCompactionStrategy::disable);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCompactionStrategy.ScannerList getScanners(Collection<SSTableReader> sstables, Collection<Range<Token>> ranges) {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            int i;
            assert (this.repaired.size() == this.unrepaired.size());
            ArrayList repairedSSTables = new ArrayList();
            ArrayList unrepairedSSTables = new ArrayList();
            for (int i2 = 0; i2 < this.repaired.size(); ++i2) {
                repairedSSTables.add(new HashSet());
                unrepairedSSTables.add(new HashSet());
            }
            for (SSTableReader sstable : sstables) {
                if (sstable.isRepaired()) {
                    ((Set)repairedSSTables.get(this.compactionStrategyIndexFor(sstable))).add(sstable);
                    continue;
                }
                ((Set)unrepairedSSTables.get(this.compactionStrategyIndexFor(sstable))).add(sstable);
            }
            ArrayList<ISSTableScanner> scanners = new ArrayList<ISSTableScanner>(sstables.size());
            for (i = 0; i < repairedSSTables.size(); ++i) {
                if (((Set)repairedSSTables.get(i)).isEmpty()) continue;
                scanners.addAll(this.repaired.get((int)i).getScanners((Collection<SSTableReader>)((Collection)repairedSSTables.get((int)i)), ranges).scanners);
            }
            for (i = 0; i < unrepairedSSTables.size(); ++i) {
                if (((Set)unrepairedSSTables.get(i)).isEmpty()) continue;
                scanners.addAll(this.unrepaired.get((int)i).getScanners((Collection<SSTableReader>)((Collection)unrepairedSSTables.get((int)i)), ranges).scanners);
            }
            AbstractCompactionStrategy.ScannerList scannerList = new AbstractCompactionStrategy.ScannerList(scanners);
            return scannerList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public AbstractCompactionStrategy.ScannerList getScanners(Collection<SSTableReader> sstables) {
        return this.getScanners(sstables, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Collection<SSTableReader>> groupSSTablesForAntiCompaction(Collection<SSTableReader> sstablesToGroup) {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            Map<Integer, List<SSTableReader>> groups = sstablesToGroup.stream().collect(Collectors.groupingBy(s -> this.compactionStrategyIndexFor((SSTableReader)s)));
            ArrayList<Collection<SSTableReader>> anticompactionGroups = new ArrayList<Collection<SSTableReader>>();
            for (Map.Entry<Integer, List<SSTableReader>> group : groups.entrySet()) {
                anticompactionGroups.addAll(this.unrepaired.get(group.getKey()).groupSSTablesForAntiCompaction((Collection<SSTableReader>)group.getValue()));
            }
            ArrayList<Collection<SSTableReader>> arrayList = anticompactionGroups;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getMaxSSTableBytes() {
        return this.maxSSTableSizeBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCompactionTask getCompactionTask(LifecycleTransaction txn, int gcBefore, long maxSSTableBytes) {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            this.validateForCompaction(txn.originals());
            AbstractCompactionTask abstractCompactionTask = this.compactionStrategyFor(txn.originals().iterator().next()).getCompactionTask(txn, gcBefore, maxSSTableBytes);
            return abstractCompactionTask;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateForCompaction(Iterable<SSTableReader> input) {
        this.readLock.lock();
        try {
            SSTableReader firstSSTable = (SSTableReader)Iterables.getFirst(input, null);
            assert (firstSSTable != null);
            boolean repaired = firstSSTable.isRepaired();
            int firstIndex = this.compactionStrategyIndexFor(firstSSTable);
            for (SSTableReader sstable : input) {
                if (sstable.isRepaired() != repaired) {
                    throw new UnsupportedOperationException("You can't mix repaired and unrepaired data in a compaction");
                }
                if (firstIndex == this.compactionStrategyIndexFor(sstable)) continue;
                throw new UnsupportedOperationException("You can't mix sstables from different directories in a compaction");
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<AbstractCompactionTask> getMaximalTasks(final int gcBefore, final boolean splitOutput) {
        this.maybeReloadDiskBoundaries();
        return this.cfs.runWithCompactionsDisabled(new Callable<Collection<AbstractCompactionTask>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<AbstractCompactionTask> call() {
                ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>();
                CompactionStrategyManager.this.readLock.lock();
                try {
                    Collection<AbstractCompactionTask> task;
                    for (AbstractCompactionStrategy strategy : CompactionStrategyManager.this.repaired) {
                        task = strategy.getMaximalTask(gcBefore, splitOutput);
                        if (task == null) continue;
                        tasks.addAll(task);
                    }
                    for (AbstractCompactionStrategy strategy : CompactionStrategyManager.this.unrepaired) {
                        task = strategy.getMaximalTask(gcBefore, splitOutput);
                        if (task == null) continue;
                        tasks.addAll(task);
                    }
                }
                finally {
                    CompactionStrategyManager.this.readLock.unlock();
                }
                if (tasks.isEmpty()) {
                    return null;
                }
                return tasks;
            }
        }, false, false);
    }

    public List<AbstractCompactionTask> getUserDefinedTasks(Collection<SSTableReader> sstables, int gcBefore) {
        return this.getUserDefinedTasks(sstables, gcBefore, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractCompactionTask> getUserDefinedTasks(Collection<SSTableReader> sstables, int gcBefore, boolean validateForCompaction) {
        this.maybeReloadDiskBoundaries();
        ArrayList<AbstractCompactionTask> ret = new ArrayList<AbstractCompactionTask>();
        this.readLock.lock();
        try {
            if (validateForCompaction) {
                this.validateForCompaction(sstables);
            }
            Map<Integer, List<SSTableReader>> repairedSSTables = sstables.stream().filter(s -> !s.isMarkedSuspect() && s.isRepaired()).collect(Collectors.groupingBy(s -> this.compactionStrategyIndexFor((SSTableReader)s)));
            Map<Integer, List<SSTableReader>> unrepairedSSTables = sstables.stream().filter(s -> !s.isMarkedSuspect() && !s.isRepaired()).collect(Collectors.groupingBy(s -> this.compactionStrategyIndexFor((SSTableReader)s)));
            for (Map.Entry<Integer, List<SSTableReader>> group : repairedSSTables.entrySet()) {
                ret.add(this.repaired.get(group.getKey()).getUserDefinedTask((Collection<SSTableReader>)group.getValue(), gcBefore));
            }
            for (Map.Entry<Integer, List<SSTableReader>> group : unrepairedSSTables.entrySet()) {
                ret.add(this.unrepaired.get(group.getKey()).getUserDefinedTask((Collection<SSTableReader>)group.getValue(), gcBefore));
            }
            ArrayList<AbstractCompactionTask> arrayList = ret;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    public AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> sstables, int gcBefore) {
        List<AbstractCompactionTask> tasks = this.getUserDefinedTasks(sstables, gcBefore, true);
        assert (tasks.size() == 1);
        return tasks.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEstimatedRemainingTasks() {
        this.maybeReloadDiskBoundaries();
        int tasks = 0;
        this.readLock.lock();
        try {
            for (AbstractCompactionStrategy strategy : this.repaired) {
                tasks += strategy.getEstimatedRemainingTasks();
            }
            for (AbstractCompactionStrategy strategy : this.unrepaired) {
                tasks += strategy.getEstimatedRemainingTasks();
            }
        }
        finally {
            this.readLock.unlock();
        }
        return tasks;
    }

    public boolean shouldBeEnabled() {
        return this.params.isEnabled();
    }

    public String getName() {
        return this.name;
    }

    public List<List<AbstractCompactionStrategy>> getStrategies() {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            List<List<AbstractCompactionStrategy>> list = Arrays.asList(this.repaired, this.unrepaired);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setNewLocalCompactionStrategy(CompactionParams params) {
        logger.info("Switching local compaction strategy from {} to {}}", (Object)this.params, (Object)params);
        this.writeLock.lock();
        try {
            this.setStrategy(params);
            if (this.shouldBeEnabled()) {
                this.enable();
            } else {
                this.disable();
            }
            this.startup();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void setStrategy(CompactionParams params) {
        this.repaired.forEach(AbstractCompactionStrategy::shutdown);
        this.unrepaired.forEach(AbstractCompactionStrategy::shutdown);
        this.repaired.clear();
        this.unrepaired.clear();
        if (this.partitionSSTablesByTokenRange) {
            for (int i = 0; i < this.currentBoundaries.directories.size(); ++i) {
                this.repaired.add(CFMetaData.createCompactionStrategyInstance(this.cfs, params));
                this.unrepaired.add(CFMetaData.createCompactionStrategyInstance(this.cfs, params));
            }
        } else {
            this.repaired.add(CFMetaData.createCompactionStrategyInstance(this.cfs, params));
            this.unrepaired.add(CFMetaData.createCompactionStrategyInstance(this.cfs, params));
        }
        this.params = params;
    }

    public CompactionParams getCompactionParams() {
        return this.params;
    }

    public boolean onlyPurgeRepairedTombstones() {
        return Boolean.parseBoolean(this.params.options().get("only_purge_repaired_tombstones"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, MetadataCollector collector, SerializationHeader header, Collection<Index> indexes, LifecycleNewTracker lifecycleNewTracker) {
        this.maybeReloadDiskBoundaries();
        this.readLock.lock();
        try {
            if (repairedAt == 0L) {
                SSTableMultiWriter sSTableMultiWriter = this.unrepaired.get(0).createSSTableMultiWriter(descriptor, keyCount, repairedAt, collector, header, indexes, lifecycleNewTracker);
                return sSTableMultiWriter;
            }
            SSTableMultiWriter sSTableMultiWriter = this.repaired.get(0).createSSTableMultiWriter(descriptor, keyCount, repairedAt, collector, header, indexes, lifecycleNewTracker);
            return sSTableMultiWriter;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isRepaired(AbstractCompactionStrategy strategy) {
        this.readLock.lock();
        try {
            boolean bl = this.repaired.contains(strategy);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStrategyFolders(AbstractCompactionStrategy strategy) {
        this.readLock.lock();
        try {
            List<Directories.DataDirectory> locations = this.currentBoundaries.directories;
            if (this.partitionSSTablesByTokenRange) {
                int unrepairedIndex = this.unrepaired.indexOf(strategy);
                if (unrepairedIndex > 0) {
                    List<String> list = Collections.singletonList(locations.get((int)unrepairedIndex).location.getAbsolutePath());
                    return list;
                }
                int repairedIndex = this.repaired.indexOf(strategy);
                if (repairedIndex > 0) {
                    List<String> list = Collections.singletonList(locations.get((int)repairedIndex).location.getAbsolutePath());
                    return list;
                }
            }
            ArrayList<String> folders = new ArrayList<String>(locations.size());
            for (Directories.DataDirectory location : locations) {
                folders.add(location.location.getAbsolutePath());
            }
            ArrayList<String> arrayList = folders;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean supportsEarlyOpen() {
        return this.supportsEarlyOpen;
    }
}

