/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds.internal.sds.trust;

import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CertificateUtils {
    private static final Logger logger = Logger.getLogger(CertificateUtils.class.getName());
    private static CertificateFactory factory;
    private static final Pattern KEY_PATTERN;

    private static synchronized void initInstance() throws CertificateException {
        if (factory == null) {
            factory = CertificateFactory.getInstance("X.509");
        }
    }

    /*
     * Exception decompiling
     */
    static X509Certificate[] toX509Certificates(File file) throws CertificateException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized X509Certificate[] toX509Certificates(InputStream inputStream) throws CertificateException, IOException {
        CertificateUtils.initInstance();
        Collection<? extends Certificate> certs = factory.generateCertificates(inputStream);
        return certs.toArray(new X509Certificate[0]);
    }

    public static synchronized X509Certificate toX509Certificate(InputStream inputStream) throws CertificateException, IOException {
        CertificateUtils.initInstance();
        Certificate cert = factory.generateCertificate(inputStream);
        return (X509Certificate)cert;
    }

    public static PrivateKey getPrivateKey(InputStream inputStream) throws Exception {
        ByteBuf encodedKeyBuf = CertificateUtils.readPrivateKey(inputStream);
        byte[] encodedKey = new byte[encodedKeyBuf.readableBytes()];
        encodedKeyBuf.readBytes(encodedKey).release();
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(encodedKey);
        return KeyFactory.getInstance("RSA").generatePrivate(spec);
    }

    private static ByteBuf readPrivateKey(InputStream in) throws KeyException {
        String content;
        try {
            content = CertificateUtils.readContent(in);
        }
        catch (IOException e) {
            throw new KeyException("failed to read key input stream", e);
        }
        Matcher m = KEY_PATTERN.matcher(content);
        if (!m.find()) {
            throw new KeyException("could not find a PKCS #8 private key in input stream");
        }
        ByteBuf base64 = Unpooled.copiedBuffer(m.group(1), CharsetUtil.US_ASCII);
        ByteBuf der = Base64.decode(base64);
        base64.release();
        return der;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readContent(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int ret;
            byte[] buf = new byte[8192];
            while ((ret = in.read(buf)) >= 0) {
                out.write(buf, 0, ret);
            }
            String string = out.toString(CharsetUtil.US_ASCII.name());
            return string;
        }
        finally {
            CertificateUtils.safeClose(out);
        }
    }

    private static void safeClose(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to close a stream.", e);
        }
    }

    private CertificateUtils() {
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    static {
        KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);
    }
}

