/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sqlfileoutput;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sqlfileoutput.SQLFileOutputMeta;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SQLFileOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SQLFileOutputMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private TextVar wTable;
    private Label wlTruncate;
    private Button wTruncate;
    private Button wStartNewLine;
    private Button wAddToResult;
    private Button wAddCreate;
    private TextVar wFilename;
    private TextVar wExtension;
    private Button wAddTransformNr;
    private Button wAddDate;
    private Button wAddTime;
    private Button wAppend;
    private Text wSplitEvery;
    private CCombo wEncoding;
    private CCombo wFormat;
    private boolean gotEncodings = false;
    private Button wCreateParentFolder;
    private Button wDoNotOpenNewFileInit;
    private final SQLFileOutputMeta input;

    public SQLFileOutputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (SQLFileOutputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.DialogTitle", (String[])new String[0]));
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString(PKG, (String)"System.Button.SQL", (String[])new String[0]));
        this.wCreate.addListener(13, e -> this.sql());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCreate, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.GeneralTab.TabTitle", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wGConnection = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wGConnection);
        wGConnection.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Group.ConnectionInfos.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wGConnection.setLayout((Layout)groupLayout);
        this.wConnection = this.addConnectionLine((Composite)wGConnection, (Control)this.wTransformName, this.input.getDatabaseMeta(), lsMod);
        Label wlSchema = new Label((Composite)wGConnection, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin);
        wlSchema.setLayoutData((Object)fdlSchema);
        this.wSchema = new TextVar(this.variables, (Composite)wGConnection, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TargetSchema.Tooltip", (String[])new String[0]));
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin);
        fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label((Composite)wGConnection, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)wGConnection, 0x1000008);
        this.props.setLook((Control)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)wGConnection, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TargetTable.Tooltip", (String[])new String[0]));
        this.wTable.addModifyListener(lsMod);
        FormData fdTable = new FormData();
        fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        FormData fdGConnection = new FormData();
        fdGConnection.left = new FormAttachment(0, margin);
        fdGConnection.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGConnection.right = new FormAttachment(100, -margin);
        wGConnection.setLayoutData((Object)fdGConnection);
        Group wFileName = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wFileName);
        wFileName.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Group.File.Label", (String[])new String[0]));
        FormLayout groupFileLayout = new FormLayout();
        groupFileLayout.marginWidth = 10;
        groupFileLayout.marginHeight = 10;
        wFileName.setLayout((Layout)groupFileLayout);
        Label wlAddCreate = new Label((Composite)wFileName, 131072);
        wlAddCreate.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.CreateTable.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddCreate);
        FormData fdlAddCreate = new FormData();
        fdlAddCreate.left = new FormAttachment(0, 0);
        fdlAddCreate.top = new FormAttachment((Control)wGConnection, margin);
        fdlAddCreate.right = new FormAttachment(middle, -margin);
        wlAddCreate.setLayoutData((Object)fdlAddCreate);
        this.wAddCreate = new Button((Composite)wFileName, 32);
        this.wAddCreate.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.CreateTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddCreate);
        FormData fdAddCreate = new FormData();
        fdAddCreate.left = new FormAttachment(middle, 0);
        fdAddCreate.top = new FormAttachment((Control)wlAddCreate, 0, 0x1000000);
        fdAddCreate.right = new FormAttachment(100, 0);
        this.wAddCreate.setLayoutData((Object)fdAddCreate);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SQLFileOutputDialog.this.activateTruncate();
                SQLFileOutputDialog.this.input.setChanged();
            }
        };
        this.wAddCreate.addSelectionListener((SelectionListener)lsSelMod);
        this.wlTruncate = new Label((Composite)wFileName, 131072);
        this.wlTruncate.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TruncateTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTruncate);
        FormData fdlTruncate = new FormData();
        fdlTruncate.left = new FormAttachment(0, 0);
        fdlTruncate.top = new FormAttachment((Control)this.wAddCreate, margin);
        fdlTruncate.right = new FormAttachment(middle, -margin);
        this.wlTruncate.setLayoutData((Object)fdlTruncate);
        this.wTruncate = new Button((Composite)wFileName, 32);
        this.wTruncate.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.TruncateTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTruncate);
        FormData fdTruncate = new FormData();
        fdTruncate.left = new FormAttachment(middle, 0);
        fdTruncate.top = new FormAttachment((Control)this.wlTruncate, 0, 0x1000000);
        fdTruncate.right = new FormAttachment(100, 0);
        this.wTruncate.setLayoutData((Object)fdTruncate);
        SelectionAdapter lsSelTMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        };
        this.wTruncate.addSelectionListener((SelectionListener)lsSelTMod);
        Label wlStartNewLine = new Label((Composite)wFileName, 131072);
        wlStartNewLine.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.StartNewLine.Label", (String[])new String[0]));
        this.props.setLook((Control)wlStartNewLine);
        FormData fdlStartNewLine = new FormData();
        fdlStartNewLine.left = new FormAttachment(0, 0);
        fdlStartNewLine.top = new FormAttachment((Control)this.wTruncate, margin);
        fdlStartNewLine.right = new FormAttachment(middle, -margin);
        wlStartNewLine.setLayoutData((Object)fdlStartNewLine);
        this.wStartNewLine = new Button((Composite)wFileName, 32);
        this.wStartNewLine.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.StartNewLine.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wStartNewLine);
        FormData fdStartNewLine = new FormData();
        fdStartNewLine.left = new FormAttachment(middle, 0);
        fdStartNewLine.top = new FormAttachment((Control)wlStartNewLine, 0, 0x1000000);
        fdStartNewLine.right = new FormAttachment(100, 0);
        this.wStartNewLine.setLayoutData((Object)fdStartNewLine);
        SelectionAdapter lsSelSMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        };
        this.wStartNewLine.addSelectionListener((SelectionListener)lsSelSMod);
        Label wlFilename = new Label((Composite)wFileName, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wStartNewLine, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button((Composite)wFileName, 0x1000008);
        this.props.setLook((Control)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wStartNewLine, 0);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)wFileName, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wStartNewLine, margin);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        Label wlCreateParentFolder = new Label((Composite)wFileName, 131072);
        wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.CreateParentFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateParentFolder);
        FormData fdlCreateParentFolder = new FormData();
        fdlCreateParentFolder.left = new FormAttachment(0, 0);
        fdlCreateParentFolder.top = new FormAttachment((Control)this.wFilename, margin);
        fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        wlCreateParentFolder.setLayoutData((Object)fdlCreateParentFolder);
        this.wCreateParentFolder = new Button((Composite)wFileName, 32);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.CreateParentFolder.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateParentFolder);
        FormData fdCreateParentFolder = new FormData();
        fdCreateParentFolder.left = new FormAttachment(middle, 0);
        fdCreateParentFolder.top = new FormAttachment((Control)wlCreateParentFolder, 0, 0x1000000);
        fdCreateParentFolder.right = new FormAttachment(100, 0);
        this.wCreateParentFolder.setLayoutData((Object)fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        Label wlDoNotOpenNewFileInit = new Label((Composite)wFileName, 131072);
        wlDoNotOpenNewFileInit.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.DoNotOpenNewFileInit.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDoNotOpenNewFileInit);
        FormData fdlDoNotOpenNewFileInit = new FormData();
        fdlDoNotOpenNewFileInit.left = new FormAttachment(0, 0);
        fdlDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        fdlDoNotOpenNewFileInit.right = new FormAttachment(middle, -margin);
        wlDoNotOpenNewFileInit.setLayoutData((Object)fdlDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit = new Button((Composite)wFileName, 32);
        this.wDoNotOpenNewFileInit.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.DoNotOpenNewFileInit.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDoNotOpenNewFileInit);
        FormData fdDoNotOpenNewFileInit = new FormData();
        fdDoNotOpenNewFileInit.left = new FormAttachment(middle, 0);
        fdDoNotOpenNewFileInit.top = new FormAttachment((Control)wlDoNotOpenNewFileInit, 0, 0x1000000);
        fdDoNotOpenNewFileInit.right = new FormAttachment(100, 0);
        this.wDoNotOpenNewFileInit.setLayoutData((Object)fdDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        Label wlExtension = new Label((Composite)wFileName, 131072);
        wlExtension.setText(BaseMessages.getString(PKG, (String)"System.Label.Extension", (String[])new String[0]));
        this.props.setLook((Control)wlExtension);
        FormData fdlExtension = new FormData();
        fdlExtension.left = new FormAttachment(0, 0);
        fdlExtension.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        fdlExtension.right = new FormAttachment(middle, -margin);
        wlExtension.setLayoutData((Object)fdlExtension);
        this.wExtension = new TextVar(this.variables, (Composite)wFileName, 18436);
        this.props.setLook((Control)this.wExtension);
        this.wExtension.addModifyListener(lsMod);
        FormData fdExtension = new FormData();
        fdExtension.left = new FormAttachment(middle, 0);
        fdExtension.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        fdExtension.right = new FormAttachment(100, -margin);
        this.wExtension.setLayoutData((Object)fdExtension);
        Label wlAddTransformNr = new Label((Composite)wFileName, 131072);
        wlAddTransformNr.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.AddTransformnr.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddTransformNr);
        FormData fdlAddTransformNr = new FormData();
        fdlAddTransformNr.left = new FormAttachment(0, 0);
        fdlAddTransformNr.top = new FormAttachment((Control)this.wExtension, 2 * margin);
        fdlAddTransformNr.right = new FormAttachment(middle, -margin);
        wlAddTransformNr.setLayoutData((Object)fdlAddTransformNr);
        this.wAddTransformNr = new Button((Composite)wFileName, 32);
        this.props.setLook((Control)this.wAddTransformNr);
        FormData fdAddTransformNr = new FormData();
        fdAddTransformNr.left = new FormAttachment(middle, 0);
        fdAddTransformNr.top = new FormAttachment((Control)wlAddTransformNr, 0, 0x1000000);
        fdAddTransformNr.right = new FormAttachment(100, 0);
        this.wAddTransformNr.setLayoutData((Object)fdAddTransformNr);
        this.wAddTransformNr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        Label wlAddDate = new Label((Composite)wFileName, 131072);
        wlAddDate.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.AddDate.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddDate);
        FormData fdlAddDate = new FormData();
        fdlAddDate.left = new FormAttachment(0, 0);
        fdlAddDate.top = new FormAttachment((Control)this.wAddTransformNr, margin);
        fdlAddDate.right = new FormAttachment(middle, -margin);
        wlAddDate.setLayoutData((Object)fdlAddDate);
        this.wAddDate = new Button((Composite)wFileName, 32);
        this.props.setLook((Control)this.wAddDate);
        FormData fdAddDate = new FormData();
        fdAddDate.left = new FormAttachment(middle, 0);
        fdAddDate.top = new FormAttachment((Control)wlAddDate, 0, 0x1000000);
        fdAddDate.right = new FormAttachment(100, 0);
        this.wAddDate.setLayoutData((Object)fdAddDate);
        this.wAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        Label wlAddTime = new Label((Composite)wFileName, 131072);
        wlAddTime.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.AddTime.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddTime);
        FormData fdlAddTime = new FormData();
        fdlAddTime.left = new FormAttachment(0, 0);
        fdlAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        fdlAddTime.right = new FormAttachment(middle, -margin);
        wlAddTime.setLayoutData((Object)fdlAddTime);
        this.wAddTime = new Button((Composite)wFileName, 32);
        this.props.setLook((Control)this.wAddTime);
        FormData fdAddTime = new FormData();
        fdAddTime.left = new FormAttachment(middle, 0);
        fdAddTime.top = new FormAttachment((Control)wlAddTime, 0, 0x1000000);
        fdAddTime.right = new FormAttachment(100, 0);
        this.wAddTime.setLayoutData((Object)fdAddTime);
        this.wAddTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        Label wlAppend = new Label((Composite)wFileName, 131072);
        wlAppend.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Append.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAppend);
        FormData fdlAppend = new FormData();
        fdlAppend.left = new FormAttachment(0, 0);
        fdlAppend.top = new FormAttachment((Control)this.wAddTime, margin);
        fdlAppend.right = new FormAttachment(middle, -margin);
        wlAppend.setLayoutData((Object)fdlAppend);
        this.wAppend = new Button((Composite)wFileName, 32);
        this.wAppend.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Append.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAppend);
        FormData fdAppend = new FormData();
        fdAppend.left = new FormAttachment(middle, 0);
        fdAppend.top = new FormAttachment((Control)wlAppend, 0, 0x1000000);
        fdAppend.right = new FormAttachment(100, 0);
        this.wAppend.setLayoutData((Object)fdAppend);
        this.wAppend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        });
        Label wlSplitEvery = new Label((Composite)wFileName, 131072);
        wlSplitEvery.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.SplitEvery.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSplitEvery);
        FormData fdlSplitEvery = new FormData();
        fdlSplitEvery.left = new FormAttachment(0, 0);
        fdlSplitEvery.top = new FormAttachment((Control)this.wAppend, margin);
        fdlSplitEvery.right = new FormAttachment(middle, -margin);
        wlSplitEvery.setLayoutData((Object)fdlSplitEvery);
        this.wSplitEvery = new Text((Composite)wFileName, 18436);
        this.props.setLook((Control)this.wSplitEvery);
        this.wSplitEvery.addModifyListener(lsMod);
        FormData fdSplitEvery = new FormData();
        fdSplitEvery.left = new FormAttachment(middle, 0);
        fdSplitEvery.top = new FormAttachment((Control)this.wAppend, margin);
        fdSplitEvery.right = new FormAttachment(100, 0);
        this.wSplitEvery.setLayoutData((Object)fdSplitEvery);
        Button wbShowFiles = new Button((Composite)wFileName, 0x1000008);
        this.props.setLook((Control)wbShowFiles);
        wbShowFiles.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(middle, 0);
        fdbShowFiles.top = new FormAttachment((Control)this.wSplitEvery, margin * 2);
        wbShowFiles.setLayoutData((Object)fdbShowFiles);
        wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputMeta tfoi = new SQLFileOutputMeta();
                SQLFileOutputDialog.this.getInfo(tfoi);
                String[] files = tfoi.getFiles(SQLFileOutputDialog.this.variables, SQLFileOutputDialog.this.variables.resolve(SQLFileOutputDialog.this.wFilename.getText()));
                if (files != null && files.length > 0) {
                    EnterSelectionDialog esd = new EnterSelectionDialog(SQLFileOutputDialog.this.shell, files, BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.SelectOutputFiles.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.SelectOutputFiles.DialogMessage", (String[])new String[0]));
                    esd.setViewOnly();
                    esd.open();
                } else {
                    MessageBox mb = new MessageBox(SQLFileOutputDialog.this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.NoFilesFound.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.DialogTitle.Error", (String[])new String[0]));
                    mb.open();
                }
            }
        });
        Label wlAddToResult = new Label((Composite)wFileName, 131072);
        wlAddToResult.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.AddFileToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddToResult);
        FormData fdlAddToResult = new FormData();
        fdlAddToResult.left = new FormAttachment(0, 0);
        fdlAddToResult.top = new FormAttachment((Control)wbShowFiles, margin);
        fdlAddToResult.right = new FormAttachment(middle, -margin);
        wlAddToResult.setLayoutData((Object)fdlAddToResult);
        this.wAddToResult = new Button((Composite)wFileName, 32);
        this.wAddToResult.setToolTipText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.AddFileToResult.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddToResult);
        FormData fdAddToResult = new FormData();
        fdAddToResult.left = new FormAttachment(middle, 0);
        fdAddToResult.top = new FormAttachment((Control)wlAddToResult, 0, 0x1000000);
        fdAddToResult.right = new FormAttachment(100, 0);
        this.wAddToResult.setLayoutData((Object)fdAddToResult);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SQLFileOutputDialog.this.input.setChanged();
            }
        };
        this.wAddToResult.addSelectionListener((SelectionListener)lsSelR);
        FormData fdFileName = new FormData();
        fdFileName.left = new FormAttachment(0, margin);
        fdFileName.top = new FormAttachment((Control)wGConnection, 2 * margin);
        fdFileName.right = new FormAttachment(100, -margin);
        wFileName.setLayoutData((Object)fdFileName);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.props.setLook((Control)wGeneralComp);
        CTabItem wContentTab = new CTabItem(wTabFolder, 0);
        wContentTab.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        String[] dats = Const.getDateFormats();
        Label wlFormat = new Label(wContentComp, 131072);
        wlFormat.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.DateFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFormat);
        FormData fdlFormat = new FormData();
        fdlFormat.left = new FormAttachment(0, 0);
        fdlFormat.top = new FormAttachment(0, margin);
        fdlFormat.right = new FormAttachment(middle, -margin);
        wlFormat.setLayoutData((Object)fdlFormat);
        this.wFormat = new CCombo(wContentComp, 2056);
        this.wFormat.setEditable(true);
        this.props.setLook((Control)this.wFormat);
        this.wFormat.addModifyListener(lsMod);
        FormData fdFormat = new FormData();
        fdFormat.left = new FormAttachment(middle, 0);
        fdFormat.top = new FormAttachment(0, margin);
        fdFormat.right = new FormAttachment(100, 0);
        this.wFormat.setLayoutData((Object)fdFormat);
        for (String dat : dats) {
            this.wFormat.add(dat);
        }
        Label wlEncoding = new Label(wContentComp, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment((Control)this.wFormat, margin);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new CCombo(wContentComp, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.top = new FormAttachment((Control)this.wFormat, margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)SQLFileOutputDialog.this.shell.getDisplay(), 1);
                SQLFileOutputDialog.this.shell.setCursor(busy);
                SQLFileOutputDialog.this.setEncodings();
                SQLFileOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)wContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLFileOutputDialog.this.getTableName();
            }
        });
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((boolean)true, (Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.sql", "*"}, (String[])new String[]{"SQL File", BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        wTabFolder.setSelection(0);
        this.getData();
        this.activateTruncate();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void activateTruncate() {
        this.wlTruncate.setEnabled(!this.wAddCreate.getSelection());
        this.wTruncate.setEnabled(!this.wAddCreate.getSelection());
        if (this.wAddCreate.getSelection()) {
            this.wTruncate.setSelection(false);
        }
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    public void getData() {
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTablename() != null) {
            this.wTable.setText(this.input.getTablename());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        if (this.input.getFileName() != null) {
            this.wFilename.setText(this.input.getFileName());
        }
        this.wCreateParentFolder.setSelection(this.input.isCreateParentFolder());
        if (this.input.getExtension() != null) {
            this.wExtension.setText(this.input.getExtension());
        } else {
            this.wExtension.setText("sql");
        }
        if (this.input.getDateFormat() != null) {
            this.wFormat.setText(this.input.getDateFormat());
        }
        this.wSplitEvery.setText("" + this.input.getSplitEvery());
        this.wAddDate.setSelection(this.input.isDateInFilename());
        this.wAddTime.setSelection(this.input.isTimeInFilename());
        this.wAppend.setSelection(this.input.isFileAppended());
        this.wAddTransformNr.setSelection(this.input.isTransformNrInFilename());
        this.wTruncate.setSelection(this.input.truncateTable());
        this.wAddCreate.setSelection(this.input.createTable());
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        this.wAddToResult.setSelection(this.input.AddToResult());
        this.wStartNewLine.setSelection(this.input.StartNewLine());
        this.wDoNotOpenNewFileInit.setSelection(this.input.isDoNotOpenNewFileInit());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(SQLFileOutputMeta info) {
        info.setSchemaName(this.wSchema.getText());
        info.setTablename(this.wTable.getText());
        info.setDatabaseMeta(this.pipelineMeta.findDatabase(this.wConnection.getText()));
        info.setTruncateTable(this.wTruncate.getSelection());
        info.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        info.setCreateTable(this.wAddCreate.getSelection());
        info.setFileName(this.wFilename.getText());
        info.setExtension(this.wExtension.getText());
        info.setDateFormat(this.wFormat.getText());
        info.setSplitEvery(Const.toInt((String)this.wSplitEvery.getText(), (int)0));
        info.setFileAppended(this.wAppend.getSelection());
        info.setTransformNrInFilename(this.wAddTransformNr.getSelection());
        info.setDateInFilename(this.wAddDate.getSelection());
        info.setTimeInFilename(this.wAddTime.getSelection());
        info.setEncoding(this.wEncoding.getText());
        info.setAddToResult(this.wAddToResult.getSelection());
        info.setStartNewLine(this.wStartNewLine.getSelection());
        info.setDoNotOpenNewFileInit(this.wDoNotOpenNewFileInit.getSelection());
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.ConnectionError.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        this.dispose();
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName);
        if (databaseMeta != null) {
            this.logDebug(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.Log.LookingAtConnection", (String[])new String[]{databaseMeta.toString()}));
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void sql() {
        try {
            SQLFileOutputMeta info = new SQLFileOutputMeta();
            this.getInfo(info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider);
            if (!sql.hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, info.getDatabaseMeta(), DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.NoSQL.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.NoSQL.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.BuildSQLError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SQLFileOutputDialog.BuildSQLError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

