/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class FlinkKeyUtils {
    public static <K> ByteBuffer encodeKey(K key, Coder<K> keyCoder) {
        byte[] keyBytes;
        Preconditions.checkNotNull(keyCoder, (Object)"Provided coder must not be null");
        try {
            keyBytes = CoderUtils.encodeToByteArray(keyCoder, key, (Coder.Context)Coder.Context.NESTED);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to encode key: %s", key), e);
        }
        return ByteBuffer.wrap(keyBytes);
    }

    public static <K> K decodeKey(ByteBuffer byteBuffer, Coder<K> keyCoder) {
        Preconditions.checkNotNull((Object)byteBuffer, (Object)"Provided ByteBuffer must not be null");
        Preconditions.checkNotNull(keyCoder, (Object)"Provided coder must not be null");
        Preconditions.checkState((boolean)byteBuffer.hasArray(), (Object)"ByteBuffer key must contain an array.");
        byte[] keyBytes = byteBuffer.array();
        try {
            return (K)CoderUtils.decodeFromByteArray(keyCoder, (byte[])keyBytes, (Coder.Context)Coder.Context.NESTED);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to decode encoded key: %s", Arrays.toString(keyBytes)), e);
        }
    }

    static ByteBuffer fromEncodedKey(ByteString encodedKey) {
        return ByteBuffer.wrap(encodedKey.toByteArray());
    }

    static class ByteBufferCoder
    extends StructuredCoder<ByteBuffer> {
        private static final ByteBufferCoder INSTANCE = new ByteBufferCoder();

        public static ByteBufferCoder of() {
            return INSTANCE;
        }

        private ByteBufferCoder() {
        }

        public void encode(ByteBuffer value, OutputStream outStream) throws IOException {
            byte[] array = value.array();
            ByteArrayCoder.of().encode(array, outStream);
        }

        public ByteBuffer decode(InputStream inStream) throws IOException {
            byte[] decode = ByteArrayCoder.of().decode(inStream);
            return ByteBuffer.wrap(decode);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Collections.emptyList();
        }

        public void verifyDeterministic() {
        }
    }
}

