/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;

public class GroupByKey<K, V>
extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
    private final boolean fewKeys;

    private GroupByKey(boolean fewKeys) {
        this.fewKeys = fewKeys;
    }

    public static <K, V> GroupByKey<K, V> create() {
        return new GroupByKey<K, V>(false);
    }

    static <K, V> GroupByKey<K, V> createWithFewKeys() {
        return new GroupByKey<K, V>(true);
    }

    public boolean fewKeys() {
        return this.fewKeys;
    }

    public static void applicableTo(PCollection<?> input) {
        WindowingStrategy<?, ?> windowingStrategy = input.getWindowingStrategy();
        if (windowingStrategy.getWindowFn() instanceof GlobalWindows && windowingStrategy.getTrigger() instanceof DefaultTrigger && input.isBounded() != PCollection.IsBounded.BOUNDED) {
            throw new IllegalStateException("GroupByKey cannot be applied to non-bounded PCollection in the GlobalWindow without a trigger. Use a Window.into or Window.triggering transform prior to GroupByKey.");
        }
        if (!GroupByKey.triggerIsSafe(windowingStrategy)) {
            throw new IllegalArgumentException(String.format("Unsafe trigger '%s' may lose data, did you mean to wrap it in`Repeatedly.forever(...)`?%nSee https://s.apache.org/finishing-triggers-drop-data for details.", windowingStrategy.getTrigger()));
        }
    }

    private static boolean triggerIsSafe(WindowingStrategy<?, ?> windowingStrategy) {
        if (!windowingStrategy.getTrigger().mayFinish()) {
            return true;
        }
        if (windowingStrategy.getTrigger() instanceof Never.NeverTrigger) {
            return true;
        }
        if (windowingStrategy.getTrigger() instanceof AfterWatermark.FromEndOfWindow && windowingStrategy.getAllowedLateness().getMillis() == 0L) {
            return true;
        }
        if (windowingStrategy.getTrigger() instanceof AfterWatermark.AfterWatermarkEarlyAndLate && windowingStrategy.getAllowedLateness().getMillis() == 0L) {
            return true;
        }
        return windowingStrategy.getTrigger() instanceof AfterWatermark.AfterWatermarkEarlyAndLate && ((AfterWatermark.AfterWatermarkEarlyAndLate)windowingStrategy.getTrigger()).getLateTrigger() != null;
    }

    public WindowingStrategy<?, ?> updateWindowingStrategy(WindowingStrategy<?, ?> inputStrategy) {
        return inputStrategy.withAlreadyMerged(!inputStrategy.getWindowFn().isNonMerging()).withTrigger(inputStrategy.getTrigger().getContinuationTrigger());
    }

    @Override
    public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
        GroupByKey.applicableTo(input);
        Coder<K> keyCoder = GroupByKey.getKeyCoder(input.getCoder());
        try {
            keyCoder.verifyDeterministic();
        }
        catch (Coder.NonDeterministicException e) {
            throw new IllegalStateException("the keyCoder of a GroupByKey must be deterministic", e);
        }
        return PCollection.createPrimitiveOutputInternal(input.getPipeline(), this.updateWindowingStrategy(input.getWindowingStrategy()), input.isBounded(), GroupByKey.getOutputKvCoder(input.getCoder()));
    }

    static <K, V> KvCoder<K, V> getInputKvCoder(Coder<KV<K, V>> inputCoder) {
        if (!(inputCoder instanceof KvCoder)) {
            throw new IllegalStateException("GroupByKey requires its input to use KvCoder");
        }
        return (KvCoder)inputCoder;
    }

    public static <K, V> Coder<K> getKeyCoder(Coder<KV<K, V>> inputCoder) {
        return GroupByKey.getInputKvCoder(inputCoder).getKeyCoder();
    }

    public static <K, V> Coder<V> getInputValueCoder(Coder<KV<K, V>> inputCoder) {
        return GroupByKey.getInputKvCoder(inputCoder).getValueCoder();
    }

    static <K, V> Coder<Iterable<V>> getOutputValueCoder(Coder<KV<K, V>> inputCoder) {
        return IterableCoder.of(GroupByKey.getInputValueCoder(inputCoder));
    }

    public static <K, V> KvCoder<K, Iterable<V>> getOutputKvCoder(Coder<KV<K, V>> inputCoder) {
        return KvCoder.of(GroupByKey.getKeyCoder(inputCoder), GroupByKey.getOutputValueCoder(inputCoder));
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        if (this.fewKeys) {
            builder.add(DisplayData.item("fewKeys", true).withLabel("Has Few Keys"));
        }
    }
}

