/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.values.Row;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
public abstract class TypedSchemaTransformProvider<ConfigT>
implements SchemaTransformProvider {
    abstract Class<ConfigT> configurationClass();

    abstract SchemaTransform from(ConfigT var1);

    Optional<List<String>> dependencies(ConfigT configuration, PipelineOptions options) {
        return Optional.empty();
    }

    @Override
    public final Schema configurationSchema() {
        try {
            return SchemaRegistry.createDefault().getSchema(this.configurationClass());
        }
        catch (NoSuchSchemaException e) {
            throw new RuntimeException("Unable to find schema for " + this.identifier() + " SchemaTransformProvider's configuration.");
        }
    }

    @Override
    public final SchemaTransform from(Row configuration) {
        return this.from(this.configFromRow(configuration));
    }

    @Override
    public final Optional<List<String>> dependencies(Row configuration, PipelineOptions options) {
        return this.dependencies(this.configFromRow(configuration), options);
    }

    private ConfigT configFromRow(Row configuration) {
        try {
            return SchemaRegistry.createDefault().getFromRowFunction(this.configurationClass()).apply(configuration);
        }
        catch (NoSuchSchemaException e) {
            throw new RuntimeException("Unable to find schema for " + this.identifier() + "SchemaTransformProvider's config");
        }
    }
}

