/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.CoGroup;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Join {
    public static final String LHS_TAG = "lhs";
    public static final String RHS_TAG = "rhs";

    public static <LhsT, RhsT> Impl<LhsT, RhsT> innerJoin(PCollection<RhsT> rhs) {
        return new Impl(JoinType.INNER, (PCollection)rhs);
    }

    public static <LhsT, RhsT> Impl<LhsT, RhsT> fullOuterJoin(PCollection<RhsT> rhs) {
        return new Impl(JoinType.OUTER, (PCollection)rhs);
    }

    public static <LhsT, RhsT> Impl<LhsT, RhsT> leftOuterJoin(PCollection<RhsT> rhs) {
        return new Impl(JoinType.LEFT_OUTER, (PCollection)rhs);
    }

    public static <LhsT, RhsT> Impl<LhsT, RhsT> rightOuterJoin(PCollection<RhsT> rhs) {
        return new Impl(JoinType.RIGHT_OUTER, (PCollection)rhs);
    }

    public static <LhsT, RhsT> Impl<LhsT, RhsT> innerBroadcastJoin(PCollection<RhsT> rhs) {
        return new Impl(JoinType.INNER_BROADCAST, (PCollection)rhs);
    }

    public static <LhsT, RhsT> Impl<LhsT, RhsT> leftOuterBroadcastJoin(PCollection<RhsT> rhs) {
        return new Impl(JoinType.LEFT_OUTER_BROADCAST, (PCollection)rhs);
    }

    public static class Impl<LhsT, RhsT>
    extends PTransform<PCollection<LhsT>, PCollection<Row>> {
        private final JoinType joinType;
        private final transient PCollection<RhsT> rhs;
        private final @Nullable FieldsEqual.Impl predicate;

        private Impl(JoinType joinType, PCollection<RhsT> rhs) {
            this(joinType, rhs, null);
        }

        private Impl(JoinType joinType, PCollection<RhsT> rhs, FieldsEqual.Impl predicate) {
            this.joinType = joinType;
            this.rhs = rhs;
            this.predicate = predicate;
        }

        public Impl<LhsT, RhsT> using(String ... fieldNames) {
            return new Impl<LhsT, RhsT>(this.joinType, this.rhs, FieldsEqual.left(fieldNames).right(fieldNames));
        }

        public Impl<LhsT, RhsT> using(Integer ... fieldIds) {
            return new Impl<LhsT, RhsT>(this.joinType, this.rhs, FieldsEqual.left(fieldIds).right(fieldIds));
        }

        public Impl<LhsT, RhsT> using(FieldAccessDescriptor fieldAccessDescriptor) {
            return new Impl<LhsT, RhsT>(this.joinType, this.rhs, FieldsEqual.left(fieldAccessDescriptor).right(fieldAccessDescriptor));
        }

        public Impl<LhsT, RhsT> on(FieldsEqual.Impl predicate) {
            return new Impl<LhsT, RhsT>(this.joinType, this.rhs, predicate);
        }

        @Override
        public PCollection<Row> expand(PCollection lhs) {
            FieldsEqual.Impl resolvedPredicate = this.predicate.resolve(lhs.getSchema(), this.rhs.getSchema());
            PCollectionTuple tuple = PCollectionTuple.of(Join.LHS_TAG, lhs).and(Join.RHS_TAG, this.rhs);
            switch (this.joinType) {
                case INNER: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs)).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs)).crossProductJoin());
                }
                case INNER_BROADCAST: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs)).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs).withSideInput()).crossProductJoin());
                }
                case OUTER: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs).withOptionalParticipation()).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs).withOptionalParticipation()).crossProductJoin());
                }
                case LEFT_OUTER: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs)).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs).withOptionalParticipation()).crossProductJoin());
                }
                case LEFT_OUTER_BROADCAST: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs)).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs).withOptionalParticipation().withSideInput()).crossProductJoin());
                }
                case RIGHT_OUTER: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs).withOptionalParticipation()).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs)).crossProductJoin());
                }
            }
            throw new RuntimeException("Unexpected join type");
        }
    }

    private static enum JoinType {
        INNER,
        OUTER,
        LEFT_OUTER,
        RIGHT_OUTER,
        INNER_BROADCAST,
        LEFT_OUTER_BROADCAST;

    }

    public static class FieldsEqual {
        public static Impl left(String ... fieldNames) {
            return new Impl(FieldAccessDescriptor.withFieldNames(fieldNames), FieldAccessDescriptor.create());
        }

        public static Impl left(Integer ... fieldIds) {
            return new Impl(FieldAccessDescriptor.withFieldIds(fieldIds), FieldAccessDescriptor.create());
        }

        public static Impl left(FieldAccessDescriptor fieldAccessDescriptor) {
            return new Impl(fieldAccessDescriptor, FieldAccessDescriptor.create());
        }

        public Impl right(String ... fieldNames) {
            return new Impl(FieldAccessDescriptor.create(), FieldAccessDescriptor.withFieldNames(fieldNames));
        }

        public Impl right(Integer ... fieldIds) {
            return new Impl(FieldAccessDescriptor.create(), FieldAccessDescriptor.withFieldIds(fieldIds));
        }

        public Impl right(FieldAccessDescriptor fieldAccessDescriptor) {
            return new Impl(FieldAccessDescriptor.create(), fieldAccessDescriptor);
        }

        public static class Impl
        implements Serializable {
            private FieldAccessDescriptor lhs;
            private FieldAccessDescriptor rhs;

            private Impl(FieldAccessDescriptor lhs, FieldAccessDescriptor rhs) {
                this.lhs = lhs;
                this.rhs = rhs;
            }

            public Impl left(String ... fieldNames) {
                return new Impl(FieldAccessDescriptor.withFieldNames(fieldNames), this.rhs);
            }

            public Impl left(Integer ... fieldIds) {
                return new Impl(FieldAccessDescriptor.withFieldIds(fieldIds), this.rhs);
            }

            public Impl left(FieldAccessDescriptor fieldAccessDescriptor) {
                return new Impl(fieldAccessDescriptor, this.rhs);
            }

            public Impl right(String ... fieldNames) {
                return new Impl(this.lhs, FieldAccessDescriptor.withFieldNames(fieldNames));
            }

            public Impl right(Integer ... fieldIds) {
                return new Impl(this.lhs, FieldAccessDescriptor.withFieldIds(fieldIds));
            }

            public Impl right(FieldAccessDescriptor fieldAccessDescriptor) {
                return new Impl(this.lhs, fieldAccessDescriptor);
            }

            private Impl resolve(Schema lhsSchema, Schema rhsSchema) {
                return new Impl(this.lhs.resolve(lhsSchema), this.rhs.resolve(rhsSchema));
            }
        }
    }
}

