/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.AutoValue_MetricName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;

@Experimental(value=Experimental.Kind.METRICS)
@AutoValue
public abstract class MetricName
implements Serializable {
    public abstract String getNamespace();

    public abstract String getName();

    public String toString() {
        return this.getNamespace() + ":" + this.getName();
    }

    public static MetricName named(String namespace, String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"Metric namespace must be non-empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Metric name must be non-empty");
        return new AutoValue_MetricName(namespace, name);
    }

    public static MetricName named(Class<?> namespace, String name) {
        Preconditions.checkArgument((namespace != null ? 1 : 0) != 0, (Object)"Metric namespace must be non-null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Metric name must be non-empty");
        return new AutoValue_MetricName(namespace.getName(), name);
    }
}

