/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;

public final class CoderHelpers {
    private CoderHelpers() {
    }

    public static <T> byte[] toByteArray(T value, Coder<T> coder) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            coder.encode(value, (OutputStream)baos);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding value: " + value, e);
        }
        return baos.toByteArray();
    }

    public static <T> T fromByteArray(byte[] serialized, Coder<T> coder) {
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized);
        try {
            return (T)coder.decode((InputStream)bais);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error decoding bytes for coder: " + coder, e);
        }
    }
}

