/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.zipfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workarounds.BufferedOutputStreamWithCloseDetection;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.FileDoesNotExistValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="ZIP_FILE", name="i18n::ActionZipFile.Name", description="i18n::ActionZipFile.Description", image="Zip.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionZipFile.keyword"}, documentationUrl="/workflow/actions/zipfile.html")
public class ActionZipFile
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionZipFile.class;
    private String zipFilename = null;
    public int compressionRate = 1;
    public int ifZipFileExists = 2;
    public int afterZip = 0;
    private String wildCard = null;
    private String excludeWildCard = null;
    private String sourceDirectory = null;
    private String movetoDirectory = null;
    private boolean addFileToResult = false;
    private boolean isFromPrevious = false;
    private boolean createParentFolder = false;
    private boolean addDate = false;
    private boolean addTime = false;
    private boolean specifyFormat = false;
    private String dateTimeFormat = null;
    private boolean createMoveToDirectory = false;
    private boolean includingSubFolders = true;
    private String storedSourcePathDepth = "1";

    public ActionZipFile(String n) {
        super(n, "");
    }

    public ActionZipFile() {
        this("");
    }

    public Object clone() {
        ActionZipFile je = (ActionZipFile)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(500);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"zipfilename", (String)this.zipFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"compressionrate", (int)this.compressionRate));
        retval.append("      ").append(XmlHandler.addTagValue((String)"ifzipfileexists", (int)this.ifZipFileExists));
        retval.append("      ").append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildCard));
        retval.append("      ").append(XmlHandler.addTagValue((String)"wildcardexclude", (String)this.excludeWildCard));
        retval.append("      ").append(XmlHandler.addTagValue((String)"sourcedirectory", (String)this.sourceDirectory));
        retval.append("      ").append(XmlHandler.addTagValue((String)"movetodirectory", (String)this.movetoDirectory));
        retval.append("      ").append(XmlHandler.addTagValue((String)"afterzip", (int)this.afterZip));
        retval.append("      ").append(XmlHandler.addTagValue((String)"addfiletoresult", (boolean)this.addFileToResult));
        retval.append("      ").append(XmlHandler.addTagValue((String)"isfromprevious", (boolean)this.isFromPrevious));
        retval.append("      ").append(XmlHandler.addTagValue((String)"createparentfolder", (boolean)this.createParentFolder));
        retval.append("      ").append(XmlHandler.addTagValue((String)"adddate", (boolean)this.addDate));
        retval.append("      ").append(XmlHandler.addTagValue((String)"addtime", (boolean)this.addTime));
        retval.append("      ").append(XmlHandler.addTagValue((String)"SpecifyFormat", (boolean)this.specifyFormat));
        retval.append("      ").append(XmlHandler.addTagValue((String)"date_time_format", (String)this.dateTimeFormat));
        retval.append("      ").append(XmlHandler.addTagValue((String)"createMoveToDirectory", (boolean)this.createMoveToDirectory));
        retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (boolean)this.includingSubFolders));
        retval.append("      ").append(XmlHandler.addTagValue((String)"stored_source_path_depth", (String)this.storedSourcePathDepth));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.zipFilename = XmlHandler.getTagValue((Node)entrynode, (String)"zipfilename");
            this.compressionRate = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"compressionrate"), (int)-1);
            this.ifZipFileExists = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"ifzipfileexists"), (int)-1);
            this.afterZip = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"afterzip"), (int)-1);
            this.wildCard = XmlHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.excludeWildCard = XmlHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
            this.sourceDirectory = XmlHandler.getTagValue((Node)entrynode, (String)"sourcedirectory");
            this.movetoDirectory = XmlHandler.getTagValue((Node)entrynode, (String)"movetodirectory");
            this.addFileToResult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.isFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"isfromprevious"));
            this.createParentFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"createparentfolder"));
            this.addDate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"adddate"));
            this.addTime = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"addtime"));
            this.specifyFormat = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.dateTimeFormat = XmlHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.createMoveToDirectory = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"createMoveToDirectory"));
            this.includingSubFolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.storedSourcePathDepth = XmlHandler.getTagValue((Node)entrynode, (String)"stored_source_path_depth");
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionZipFile.UnableLoadActionXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createParentFolder(String filename) {
        FileObject parentfolder = null;
        boolean result = false;
        try {
            parentfolder = HopVfs.getFileObject((String)filename).getParent();
            if (!parentfolder.exists()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.CanNotFindFolder", (String[])new String[]{"" + parentfolder.getName()}));
                }
                parentfolder.createFolder();
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.FolderCreated", (String[])new String[]{"" + parentfolder.getName()}));
                }
            } else if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.FolderExists", (String[])new String[]{"" + parentfolder.getName()}));
            }
            result = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.CanNotCreateFolder", (String[])new String[]{"" + parentfolder.getName()}), e);
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRowFile(IWorkflowEngine<WorkflowMeta> parentWorkflow, Result result, String realZipfilename, String realWildcard, String realWildcardExclude, String realSourceDirectoryOrFile, String realMovetodirectory, boolean createparentfolder) {
        boolean fileexists = false;
        File tempFile = null;
        boolean resultat = false;
        boolean renameOk = false;
        boolean orginExist = false;
        FileObject originFile = null;
        ZipInputStream zin = null;
        OutputStream dest = null;
        BufferedOutputStreamWithCloseDetection buff = null;
        ZipOutputStream out = null;
        String localSourceFilename = realSourceDirectoryOrFile;
        try {
            originFile = HopVfs.getFileObject((String)realSourceDirectoryOrFile);
            localSourceFilename = HopVfs.getFilename((FileObject)originFile);
            orginExist = originFile.exists();
        }
        catch (Exception ex) {
        }
        finally {
            if (originFile != null) {
                try {
                    originFile.close();
                }
                catch (IOException ex) {
                    this.logError("Error closing file '" + originFile.toString() + "'", ex);
                }
            }
        }
        Object localrealZipfilename = realZipfilename;
        if (realZipfilename != null && orginExist) {
            FileObject fileObject = null;
            try {
                int i;
                FileObject[] fileList;
                Pattern patternExclude;
                Pattern pattern;
                fileObject = HopVfs.getFileObject((String)localrealZipfilename);
                localrealZipfilename = HopVfs.getFilename((FileObject)fileObject);
                if (fileObject.exists()) {
                    fileexists = true;
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileExists1.Label", (String[])new String[0]) + (String)localrealZipfilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileExists2.Label", (String[])new String[0]));
                    }
                }
                if (createparentfolder) {
                    this.createParentFolder((String)localrealZipfilename);
                }
                if (this.ifZipFileExists == 3 && fileexists) {
                    resultat = false;
                }
                if (this.ifZipFileExists == 2 && fileexists) {
                    if (this.addFileToResult) {
                        ResultFile resultFile = new ResultFile(0, fileObject, parentWorkflow.getWorkflowName(), this.toString());
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    }
                    resultat = true;
                }
                if (this.afterZip == 2 && realMovetodirectory == null) {
                    resultat = false;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.AfterZip_No_DestinationFolder_Defined.Label", (String[])new String[0]));
                }
                FileObject sourceFileOrFolder = HopVfs.getFileObject((String)localSourceFilename);
                boolean isSourceDirectory = sourceFileOrFolder.getType().equals((Object)FileType.FOLDER);
                if (isSourceDirectory) {
                    pattern = !Utils.isEmpty((CharSequence)realWildcard) ? Pattern.compile(realWildcard) : null;
                    patternExclude = !Utils.isEmpty((CharSequence)realWildcardExclude) ? Pattern.compile(realWildcardExclude) : null;
                    fileList = this.includingSubFolders ? sourceFileOrFolder.findFiles((FileSelector)new ZipJobEntryPatternFileSelector(pattern, patternExclude)) : sourceFileOrFolder.getChildren();
                } else {
                    pattern = null;
                    patternExclude = null;
                    fileList = new FileObject[]{sourceFileOrFolder};
                }
                if (fileList.length == 0) {
                    resultat = false;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.FolderIsEmpty", (String[])new String[]{localSourceFilename}));
                }
                if (!this.checkContainsFile(localSourceFilename, fileList, isSourceDirectory)) {
                    resultat = false;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.NoFilesInFolder", (String[])new String[]{localSourceFilename}));
                }
                if (this.ifZipFileExists == 0 && fileexists) {
                    if (((String)localrealZipfilename).toLowerCase().endsWith(".zip")) {
                        localrealZipfilename = ((String)localrealZipfilename).substring(0, ((String)localrealZipfilename).length() - 4);
                    }
                    localrealZipfilename = (String)localrealZipfilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + ".zip";
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileNameChange1.Label", (String[])new String[0]) + (String)localrealZipfilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileNameChange1.Label", (String[])new String[0]));
                    }
                } else if (this.ifZipFileExists == 1 && fileexists) {
                    File fileZip = this.getFile((String)localrealZipfilename);
                    tempFile = File.createTempFile(fileZip.getName(), null);
                    tempFile.delete();
                    renameOk = fileZip.renameTo(tempFile);
                    if (!renameOk) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Rename_Temp1.Label", (String[])new String[0]) + fileZip.getAbsolutePath() + BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Rename_Temp2.Label", (String[])new String[0]) + tempFile.getAbsolutePath() + BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Rename_Temp3.Label", (String[])new String[0]));
                    }
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileAppend1.Label", (String[])new String[0]) + (String)localrealZipfilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileAppend2.Label", (String[])new String[0]));
                    }
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.Files_Found1.Label", (String[])new String[0]) + fileList.length + BaseMessages.getString(PKG, (String)"ActionZipFile.Files_Found2.Label", (String[])new String[0]) + localSourceFilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Files_Found3.Label", (String[])new String[0]));
                }
                byte[] buffer = new byte[18024];
                dest = HopVfs.getOutputStream((String)localrealZipfilename, (boolean)false);
                buff = new BufferedOutputStreamWithCloseDetection(dest);
                out = new ZipOutputStream((OutputStream)buff);
                HashSet<String> fileSet = new HashSet<String>();
                if (renameOk) {
                    zin = new ZipInputStream(new FileInputStream(tempFile));
                    ZipEntry entry = zin.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        if (!fileSet.contains(name)) {
                            int len;
                            out.putNextEntry(new ZipEntry(name));
                            while ((len = zin.read(buffer)) > 0) {
                                out.write(buffer, 0, len);
                            }
                            fileSet.add(name);
                        }
                        entry = zin.getNextEntry();
                    }
                    zin.close();
                }
                out.setMethod(8);
                if (this.compressionRate == 0) {
                    out.setLevel(0);
                } else if (this.compressionRate == 1) {
                    out.setLevel(-1);
                }
                if (this.compressionRate == 2) {
                    out.setLevel(9);
                }
                if (this.compressionRate == 3) {
                    out.setLevel(1);
                }
                FileObject[] zippedFiles = new FileObject[fileList.length];
                int fileNum = 0;
                for (i = 0; i < fileList.length && !parentWorkflow.isStopped(); ++i) {
                    int len;
                    String relativeName;
                    FileObject file;
                    boolean isTargetDirectory;
                    boolean getIt = true;
                    boolean getItexclude = false;
                    if (isSourceDirectory) {
                        String filename = this.includingSubFolders ? fileList[i].getName().getPath() : fileList[i].getName().getBaseName();
                        if (pattern != null) {
                            Matcher matcher = pattern.matcher(filename);
                            getIt = matcher.matches();
                        }
                        if (patternExclude != null) {
                            Matcher matcherexclude = patternExclude.matcher(filename);
                            getItexclude = matcherexclude.matches();
                        }
                    }
                    String targetFilename = HopVfs.getFilename((FileObject)fileList[i]);
                    if (sourceFileOrFolder.getType().equals((Object)FileType.FILE)) {
                        targetFilename = localSourceFilename;
                    }
                    boolean bl = isTargetDirectory = (file = HopVfs.getFileObject((String)targetFilename)).exists() && file.getType().equals((Object)FileType.FOLDER);
                    if (!getIt || getItexclude || isTargetDirectory || fileSet.contains(targetFilename)) continue;
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.Add_FilesToZip1.Label", (String[])new String[0]) + fileList[i] + BaseMessages.getString(PKG, (String)"ActionZipFile.Add_FilesToZip2.Label", (String[])new String[0]) + localSourceFilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Add_FilesToZip3.Label", (String[])new String[0]));
                    }
                    InputStream in = HopVfs.getInputStream((FileObject)file);
                    String fullName = fileList[i].getName().getPath();
                    String basePath = sourceFileOrFolder.getName().getPath();
                    if (isSourceDirectory) {
                        relativeName = fullName.startsWith(basePath) ? fullName.substring(basePath.length() + 1) : fullName;
                    } else if (this.isFromPrevious) {
                        int depth = this.determineDepth(this.resolve(this.storedSourcePathDepth));
                        relativeName = this.determineZipfilenameForDepth(fullName, depth);
                    } else {
                        relativeName = fileList[i].getName().getBaseName();
                    }
                    out.putNextEntry(new ZipEntry(relativeName));
                    while ((len = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                    out.closeEntry();
                    in.close();
                    zippedFiles[fileNum] = fileList[i];
                    ++fileNum;
                }
                out.close();
                buff.close();
                dest.close();
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.TotalZippedFiles", (String[])new String[]{"" + zippedFiles.length}));
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                if (this.afterZip == 1 || this.afterZip == 2) {
                    for (i = 0; i < zippedFiles.length; ++i) {
                        if (zippedFiles[i] == null) continue;
                        FileObject fileObjectd = zippedFiles[i];
                        if (!isSourceDirectory) {
                            fileObjectd = HopVfs.getFileObject((String)localSourceFilename);
                        }
                        if (this.afterZip == 1) {
                            boolean deleted = fileObjectd.delete();
                            if (!deleted) {
                                resultat = false;
                                this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Delete_File1.Label", (String[])new String[0]) + localSourceFilename + Const.FILE_SEPARATOR + zippedFiles[i] + BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Delete_File2.Label", (String[])new String[0]));
                            }
                            if (!this.log.isDebug()) continue;
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.File_Deleted1.Label", (String[])new String[0]) + localSourceFilename + Const.FILE_SEPARATOR + zippedFiles[i] + BaseMessages.getString(PKG, (String)"ActionZipFile.File_Deleted2.Label", (String[])new String[0]));
                            continue;
                        }
                        if (this.afterZip != 2) continue;
                        FileObject fileObjectm = null;
                        try {
                            fileObjectm = HopVfs.getFileObject((String)(realMovetodirectory + Const.FILE_SEPARATOR + fileObjectd.getName().getBaseName()));
                            fileObjectd.moveTo(fileObjectm);
                        }
                        catch (IOException e) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Move_File1.Label", (String[])new String[0]) + zippedFiles[i] + BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Move_File2.Label", (String[])new String[0]) + e.getMessage());
                            resultat = false;
                        }
                        finally {
                            block99: {
                                try {
                                    if (fileObjectm != null) {
                                        fileObjectm.close();
                                    }
                                }
                                catch (Exception e) {
                                    if (fileObjectm == null) break block99;
                                    this.logError("Error closing file '" + fileObjectm.toString() + "'", e);
                                }
                            }
                        }
                        if (!this.log.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.File_Moved1.Label", (String[])new String[0]) + zippedFiles[i] + BaseMessages.getString(PKG, (String)"ActionZipFile.File_Moved2.Label", (String[])new String[0]));
                    }
                }
                if (this.addFileToResult) {
                    ResultFile resultFile = new ResultFile(0, fileObject, parentWorkflow.getWorkflowName(), this.toString());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                }
                resultat = true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_CreateZipFile1.Label", (String[])new String[0]) + (String)localrealZipfilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_CreateZipFile2.Label", (String[])new String[0]), e);
                resultat = false;
            }
            finally {
                if (fileObject != null) {
                    try {
                        fileObject.close();
                        fileObject = null;
                    }
                    catch (IOException ex) {
                        this.logError("Error closing file '" + fileObject.toString() + "'", ex);
                    }
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (buff != null) {
                        buff.close();
                    }
                    if (dest != null) {
                        dest.close();
                    }
                    if (zin != null) {
                        zin.close();
                    }
                }
                catch (IOException ex) {
                    this.logError("Error closing zip file entry for file '" + originFile.toString() + "'", ex);
                }
            }
        } else {
            resultat = false;
            if (localrealZipfilename == null) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.No_ZipFile_Defined.Label", (String[])new String[0]));
            }
            if (!orginExist) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.No_FolderCible_Defined.Label", (String[])new String[]{localSourceFilename}));
            }
        }
        return resultat;
    }

    private int determineDepth(String depthString) throws HopException {
        DecimalFormat df = new DecimalFormat("0");
        ParsePosition pp = new ParsePosition(0);
        df.setParseIntegerOnly(true);
        try {
            Number n = df.parse(depthString, pp);
            if (n == null) {
                return 1;
            }
            if (pp.getErrorIndex() == 0) {
                throw new HopException("Unable to convert stored depth '" + depthString + "' to depth at position " + pp.getErrorIndex());
            }
            return n.intValue();
        }
        catch (Exception e) {
            throw new HopException("Unable to convert stored depth '" + depthString + "' to depth", (Throwable)e);
        }
    }

    private String determineZipfilenameForDepth(String filename, int depth) throws HopException {
        try {
            if (Utils.isEmpty((CharSequence)filename)) {
                return null;
            }
            if (depth == 0) {
                return filename;
            }
            FileObject fileObject = HopVfs.getFileObject((String)filename);
            FileObject folder = fileObject.getParent();
            String baseName = fileObject.getName().getBaseName();
            if (depth == 1) {
                return baseName;
            }
            StringBuilder path = new StringBuilder(baseName);
            for (int d = 1; d < depth && folder != null; folder = folder.getParent(), ++d) {
                path.insert(0, '/');
                path.insert(0, folder.getName().getBaseName());
            }
            return path.toString();
        }
        catch (Exception e) {
            throw new HopException("Unable to get zip filename '" + filename + "' to depth " + depth, (Throwable)e);
        }
    }

    private File getFile(String filename) {
        try {
            String uri = HopVfs.getFileObject((String)this.resolve(filename)).getName().getPath();
            return new File(uri);
        }
        catch (HopFileException ex) {
            this.logError("Error in Fetching URI for File: " + filename, ex);
            return new File(filename);
        }
    }

    private boolean checkContainsFile(String realSourceDirectoryOrFile, FileObject[] filelist, boolean isDirectory) throws FileSystemException {
        boolean retval = false;
        for (int i = 0; i < filelist.length; ++i) {
            FileObject file = filelist[i];
            if (!file.exists() || !file.getType().equals((Object)FileType.FILE)) continue;
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        List rows = result.getRows();
        String realWildcard = null;
        String realWildcardExclude = null;
        String realMovetodirectory = this.resolve(this.movetoDirectory);
        boolean sanityControlOK = true;
        if (this.afterZip == 2) {
            if (Utils.isEmpty((CharSequence)realMovetodirectory)) {
                sanityControlOK = false;
                this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.AfterZip_No_DestinationFolder_Defined.Label", (String[])new String[0]));
            } else {
                FileObject moveToDirectory = null;
                try {
                    moveToDirectory = HopVfs.getFileObject((String)realMovetodirectory);
                    if (moveToDirectory.exists()) {
                        if (moveToDirectory.getType() == FileType.FOLDER) {
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.MoveToFolderExist", (String[])new String[]{realMovetodirectory}));
                            }
                        } else {
                            sanityControlOK = false;
                            this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.MoveToFolderNotFolder", (String[])new String[]{realMovetodirectory}));
                        }
                    } else {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.MoveToFolderNotNotExist", (String[])new String[]{realMovetodirectory}));
                        }
                        if (this.createMoveToDirectory) {
                            moveToDirectory.createFolder();
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.MoveToFolderCreaterd", (String[])new String[]{realMovetodirectory}));
                            }
                        } else {
                            sanityControlOK = false;
                            this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.MoveToFolderNotNotExist", (String[])new String[]{realMovetodirectory}));
                        }
                    }
                }
                catch (Exception e) {
                    sanityControlOK = false;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.ErrorGettingMoveToFolder.Label", (String[])new String[]{realMovetodirectory}), e);
                }
                finally {
                    if (moveToDirectory != null) {
                        realMovetodirectory = HopVfs.getFilename((FileObject)moveToDirectory);
                        try {
                            moveToDirectory.close();
                        }
                        catch (Exception e) {
                            this.logError("Error moving to directory", e);
                            sanityControlOK = false;
                        }
                    }
                }
            }
        }
        if (!sanityControlOK) {
            return this.errorResult(result);
        }
        if (this.isFromPrevious && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.ArgFromPrevious.Found", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
        }
        if (this.isFromPrevious && rows != null) {
            try {
                for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                    RowMetaAndData resultRow = (RowMetaAndData)rows.get(iteration);
                    String realTargetdirectory = resultRow.getString(0, null);
                    if (!Utils.isEmpty((CharSequence)realTargetdirectory)) {
                        String realZipfilename;
                        if (!Utils.isEmpty((CharSequence)resultRow.getString(1, null))) {
                            realWildcard = resultRow.getString(1, null);
                        }
                        if (!Utils.isEmpty((CharSequence)resultRow.getString(2, null))) {
                            realWildcardExclude = resultRow.getString(2, null);
                        }
                        if (!Utils.isEmpty((CharSequence)(realZipfilename = resultRow.getString(3, null)))) {
                            if (this.processRowFile((IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result, realZipfilename, realWildcard, realWildcardExclude, realTargetdirectory, realMovetodirectory, this.createParentFolder)) continue;
                            return this.errorResult(result);
                        }
                        this.logError("destination zip filename is empty! Ignoring row...");
                        continue;
                    }
                    this.logError("Target directory is empty! Ignoring row...");
                }
            }
            catch (Exception e) {
                this.logError("Error during process!", e);
                result.setResult(false);
                result.setNrErrors(1L);
            }
        } else if (!this.isFromPrevious) {
            if (!Utils.isEmpty((CharSequence)this.sourceDirectory)) {
                String realTargetdirectory;
                String realZipfilename = this.getFullFilename(this.resolve(this.zipFilename), this.addDate, this.addTime, this.specifyFormat, this.dateTimeFormat);
                boolean success = this.processRowFile((IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result, realZipfilename, realWildcard = this.resolve(this.wildCard), realWildcardExclude = this.resolve(this.excludeWildCard), realTargetdirectory = this.resolve(this.sourceDirectory), realMovetodirectory, this.createParentFolder);
                if (success) {
                    result.setResult(true);
                } else {
                    this.errorResult(result);
                }
            } else {
                this.logError("Source folder/file is empty! Ignoring row...");
            }
        }
        return result;
    }

    private Result errorResult(Result result) {
        result.setNrErrors(1L);
        result.setResult(false);
        return result;
    }

    public String getFullFilename(String filename, boolean addDate, boolean addTime, boolean specifyFormat, String datetimeFolder) {
        if (Utils.isEmpty((CharSequence)filename)) {
            return null;
        }
        String realfilename = this.resolve(filename);
        int lenstring = realfilename.length();
        int lastindexOfDot = realfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        Object retval = realfilename.substring(0, lastindexOfDot);
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (specifyFormat && !Utils.isEmpty((CharSequence)datetimeFolder)) {
            daf.applyPattern(datetimeFolder);
            String dt = daf.format(now);
            retval = (String)retval + dt;
        } else {
            if (addDate) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = (String)retval + "_" + d;
            }
            if (addTime) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = (String)retval + "_" + t;
            }
        }
        retval = (String)retval + realfilename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public void setWildcard(String wildcard) {
        this.wildCard = wildcard;
    }

    public void setWildcardExclude(String wildcardExclude) {
        this.excludeWildCard = wildcardExclude;
    }

    public void setSourceDirectory(String sourcedirectory) {
        this.sourceDirectory = sourcedirectory;
    }

    public void setMoveToDirectory(String movetodirectory) {
        this.movetoDirectory = movetodirectory;
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getMoveToDirectory() {
        return this.movetoDirectory;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public boolean isCreateMoveToDirectory() {
        return this.createMoveToDirectory;
    }

    public void setCreateMoveToDirectory(boolean createMoveToDirectory) {
        this.createMoveToDirectory = createMoveToDirectory;
    }

    public String getWildcard() {
        return this.wildCard;
    }

    public String getWildcardExclude() {
        return this.excludeWildCard;
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addFileToResult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addFileToResult;
    }

    public void setcreateparentfolder(boolean createparentfolder) {
        this.createParentFolder = createparentfolder;
    }

    public void setDateInFilename(boolean adddate) {
        this.addDate = adddate;
    }

    public boolean isDateInFilename() {
        return this.addDate;
    }

    public void setTimeInFilename(boolean addtime) {
        this.addTime = addtime;
    }

    public boolean isTimeInFilename() {
        return this.addTime;
    }

    public boolean isSpecifyFormat() {
        return this.specifyFormat;
    }

    public void setSpecifyFormat(boolean specifyFormat) {
        this.specifyFormat = specifyFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public boolean getcreateparentfolder() {
        return this.createParentFolder;
    }

    public void setDatafromprevious(boolean isfromprevious) {
        this.isFromPrevious = isfromprevious;
    }

    public boolean getDatafromprevious() {
        return this.isFromPrevious;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx1 = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx1, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx1, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileDoesNotExistValidator()});
        if (3 == this.ifZipFileExists) {
            FileDoesNotExistValidator.putFailIfExists((ValidatorContext)ctx1, (boolean)true);
        }
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "zipFilename", remarks, ctx1);
        if (2 == this.afterZip) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "moveToDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        }
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "sourceDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    public boolean isIncludingSubFolders() {
        return this.includingSubFolders;
    }

    public void setIncludingSubFolders(boolean includesSubFolders) {
        this.includingSubFolders = includesSubFolders;
    }

    public String getStoredSourcePathDepth() {
        return this.storedSourcePathDepth;
    }

    public void setStoredSourcePathDepth(String storedSourcePathDepth) {
        this.storedSourcePathDepth = storedSourcePathDepth;
    }

    public static class ZipJobEntryPatternFileSelector
    implements FileSelector {
        private Pattern pattern;
        private Pattern patternExclude;

        public ZipJobEntryPatternFileSelector(Pattern pattern, Pattern patternExclude) {
            this.pattern = pattern;
            this.patternExclude = patternExclude;
        }

        public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
            return true;
        }

        public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
            boolean include;
            if (fileInfo.getFile().getType().equals((Object)FileType.FILE)) {
                String name;
                include = true;
                if (this.pattern != null) {
                    name = fileInfo.getFile().getName().getBaseName();
                    include = this.pattern.matcher(name).matches();
                }
                if (include && this.patternExclude != null) {
                    name = fileInfo.getFile().getName().getBaseName();
                    include = !this.patternExclude.matcher(name).matches();
                }
            } else {
                include = false;
            }
            return include;
        }
    }
}

