/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.joinrows;

import java.util.List;
import org.apache.hop.core.Condition;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.joinrows.JoinRowsMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ConditionEditor;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JoinRowsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = JoinRowsMeta.class;
    private TextVar wSortDir;
    private Text wPrefix;
    private Text wCache;
    private CCombo wMainTransform;
    private ConditionEditor wCondition;
    private final JoinRowsMeta input;
    private final Condition condition;
    private Condition backupCondition;

    public JoinRowsDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (JoinRowsMeta)((Object)in);
        this.condition = this.input.getCondition();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        this.backupCondition = (Condition)this.condition.clone();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlSortDir = new Label((Composite)this.shell, 131072);
        wlSortDir.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.TempDir.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSortDir);
        FormData fdlSortDir = new FormData();
        fdlSortDir.left = new FormAttachment(0, 0);
        fdlSortDir.right = new FormAttachment(middle, -margin);
        fdlSortDir.top = new FormAttachment((Control)this.wTransformName, margin);
        wlSortDir.setLayoutData((Object)fdlSortDir);
        Button wbSortDir = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbSortDir);
        wbSortDir.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Browse.Button", (String[])new String[0]));
        FormData fdbSortDir = new FormData();
        fdbSortDir.right = new FormAttachment(100, 0);
        fdbSortDir.top = new FormAttachment((Control)this.wTransformName, margin);
        wbSortDir.setLayoutData((Object)fdbSortDir);
        this.wSortDir = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wSortDir.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Temp.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wSortDir);
        this.wSortDir.addModifyListener(lsMod);
        FormData fdSortDir = new FormData();
        fdSortDir.left = new FormAttachment(middle, 0);
        fdSortDir.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSortDir.right = new FormAttachment((Control)wbSortDir, -margin);
        this.wSortDir.setLayoutData((Object)fdSortDir);
        wbSortDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DirectoryDialog dd = new DirectoryDialog(JoinRowsDialog.this.shell, 0);
                dd.setFilterPath(JoinRowsDialog.this.wSortDir.getText());
                String dir = dd.open();
                if (dir != null) {
                    JoinRowsDialog.this.wSortDir.setText(dir);
                }
            }
        });
        this.wSortDir.addModifyListener(e -> this.wSortDir.setToolTipText(this.variables.resolve(this.wSortDir.getText())));
        Label wlPrefix = new Label((Composite)this.shell, 131072);
        wlPrefix.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.TempFilePrefix.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPrefix);
        FormData fdlPrefix = new FormData();
        fdlPrefix.left = new FormAttachment(0, 0);
        fdlPrefix.right = new FormAttachment(middle, -margin);
        fdlPrefix.top = new FormAttachment((Control)wbSortDir, margin * 2);
        wlPrefix.setLayoutData((Object)fdlPrefix);
        this.wPrefix = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPrefix);
        this.wPrefix.addModifyListener(lsMod);
        FormData fdPrefix = new FormData();
        fdPrefix.left = new FormAttachment(middle, 0);
        fdPrefix.top = new FormAttachment((Control)wbSortDir, margin * 2);
        fdPrefix.right = new FormAttachment(100, 0);
        this.wPrefix.setLayoutData((Object)fdPrefix);
        this.wPrefix.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Prefix.Label", (String[])new String[0]));
        Label wlCache = new Label((Composite)this.shell, 131072);
        wlCache.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Cache.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCache);
        FormData fdlCache = new FormData();
        fdlCache.left = new FormAttachment(0, 0);
        fdlCache.right = new FormAttachment(middle, -margin);
        fdlCache.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        wlCache.setLayoutData((Object)fdlCache);
        this.wCache = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCache);
        this.wCache.addModifyListener(lsMod);
        FormData fdCache = new FormData();
        fdCache.left = new FormAttachment(middle, 0);
        fdCache.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        fdCache.right = new FormAttachment(100, 0);
        this.wCache.setLayoutData((Object)fdCache);
        Label wlMainTransform = new Label((Composite)this.shell, 131072);
        wlMainTransform.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.MainTransform.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMainTransform);
        FormData fdlMainTransform = new FormData();
        fdlMainTransform.left = new FormAttachment(0, 0);
        fdlMainTransform.right = new FormAttachment(middle, -margin);
        fdlMainTransform.top = new FormAttachment((Control)this.wCache, margin);
        wlMainTransform.setLayoutData((Object)fdlMainTransform);
        this.wMainTransform = new CCombo((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wMainTransform);
        List prevTransforms = this.pipelineMeta.findPreviousTransforms(this.pipelineMeta.findTransform(this.transformName));
        for (TransformMeta transformMeta : prevTransforms) {
            this.wMainTransform.add(transformMeta.getName());
        }
        this.wMainTransform.addModifyListener(lsMod);
        FormData fdMainTransform = new FormData();
        fdMainTransform.left = new FormAttachment(middle, 0);
        fdMainTransform.top = new FormAttachment((Control)this.wCache, margin);
        fdMainTransform.right = new FormAttachment(100, 0);
        this.wMainTransform.setLayoutData((Object)fdMainTransform);
        Label wlCondition = new Label((Composite)this.shell, 0);
        wlCondition.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Condition.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCondition);
        FormData fdlCondition = new FormData();
        fdlCondition.left = new FormAttachment(0, 0);
        fdlCondition.top = new FormAttachment((Control)this.wMainTransform, margin);
        wlCondition.setLayoutData((Object)fdlCondition);
        RowMeta inputfields = null;
        try {
            inputfields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
        }
        catch (HopException ke) {
            inputfields = new RowMeta();
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JoinRowsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JoinRowsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wCondition = new ConditionEditor((Composite)this.shell, 2048, this.condition, (IRowMeta)inputfields);
        FormData fdCondition = new FormData();
        fdCondition.left = new FormAttachment(0, 0);
        fdCondition.top = new FormAttachment((Control)wlCondition, margin);
        fdCondition.right = new FormAttachment(100, 0);
        fdCondition.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wCondition.setLayoutData((Object)fdCondition);
        this.wCondition.addModifyListener(lsMod);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.input.getPrefix() != null) {
            this.wPrefix.setText(this.input.getPrefix());
        }
        if (this.input.getDirectory() != null) {
            this.wSortDir.setText(this.input.getDirectory());
        }
        this.wCache.setText("" + this.input.getCacheSize());
        if (this.input.getMainTransform() != null) {
            this.wMainTransform.setText(this.input.getLookupTransformName());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.input.setCondition(this.backupCondition);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        if (this.wCondition.getLevel() > 0) {
            this.wCondition.goUp();
        } else {
            this.transformName = this.wTransformName.getText();
            this.input.setPrefix(this.wPrefix.getText());
            this.input.setDirectory(this.wSortDir.getText());
            this.input.setCacheSize(Const.toInt((String)this.wCache.getText(), (int)-1));
            this.input.setMainTransform(this.pipelineMeta.findTransform(this.wMainTransform.getText()));
            this.input.setMainTransformName(this.wMainTransform.getText());
            this.dispose();
        }
    }
}

